#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"
#include "gcmapps.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif

static void transPlanets _(( PLAYER *aWorld, WORD x_offset, WORD y_offset ));
static Bool appendMap _(( PLAYER *toWorld, PLAYER *fromWorld ));
static void eliminateEqualPlanets _(( PlanetList *stay, PlanetList *go ));


/*  appendMap:   Die Planeten zweier Welten vereinen
 *               fromWorld >> toWorld
 */

#define THO 1

#if THO
static int list_cmp _(( const void *, const void * ));

static int list_cmp(P(const void *) l1p, P(const void *) l2p)
PP(const void *l1p;)
PP(const void *l2p;)
{
	const PlanetList *l1 = *((const PlanetList **)l1p);
	const PlanetList *l2 = *((const PlanetList **)l2p);
	
	if (l1->l_number < l2->l_number)
		return(-1);
	if (l1->l_number > l2->l_number)
		return(1);
	return(0);
}


static Bool appendMap(P(PLAYER *) toWorld, P(PLAYER *) fromWorld)
PP(PLAYER *toWorld;)
PP(PLAYER *fromWorld;)
{
	PlanetList *list;
	PlanetList **array;
	size_t array_size;
	size_t i;
	size_t new_size;
	
	for (list = toWorld->pl_planetlist; list->l_next != NULL; list = list->l_next)
		;
	list->l_next = fromWorld->pl_planetlist;
	fromWorld->pl_planetlist = NULL;
	array_size = 0;
	for (list = toWorld->pl_planetlist; list != NULL; list = list->l_next)
		array_size++;
	array = (PlanetList **)MALLOC(array_size * sizeof(PlanetList *), "appendMap");
	if (array == NULL)
		return(FALSE);
	for (i = 0, list = toWorld->pl_planetlist; list != NULL; i++, list = list->l_next)
		array[i] = list;
	qsort(array, array_size, sizeof(PlanetList *), list_cmp);
	new_size = 1;
	for (i = 1; i < array_size; i++)
	{
		if (array[new_size-1]->l_number == array[i]->l_number)
		{
			eliminateEqualPlanets(array[new_size-1], array[i]);
		} else {
			array[new_size] = array[i];
			new_size++;
		}
	}
	for (i = 0; i < (new_size-1); i++)
	{
		array[i]->l_next = array[i+1];
	}
	array[new_size-1]->l_next = NULL;
	toWorld->pl_planetlist = array[0];
	FREE(array, array_size * sizeof(PlanetList *));
	return(TRUE);
}

#else

static Bool appendMap(P(PLAYER *) toWorld, P(PLAYER *) fromWorld)
PP(PLAYER *toWorld;)
PP(PLAYER *fromWorld;)
{
	PlanetList *source, *destination;
	PlanetList *presource, *predestination;
	PlanetList *startsource;
	Bool ende;
	
	ende = FALSE;
	destination = toWorld->pl_planetlist;
	source = fromWorld->pl_planetlist;
	predestination = destination;
	presource = source;

	while (destination != NULL && ende == FALSE)
	{
		startsource = source;
		presource = source;
		while (source != NULL &&
			   source->l_number < destination->l_number)
		{
			presource = source;
			source = presource->l_next;
		}
		if (source == NULL)
		{
			if (startsource != NULL)
			{
				if (predestination == toWorld->pl_planetlist)
					toWorld->pl_planetlist = startsource;
				else
					predestination->l_next = startsource;
				presource->l_next = destination;
			}
			ende = TRUE;
		} else {
			if (source->l_number == destination->l_number)
			{
				if (startsource == source)
				{
					startsource = source->l_next;
					eliminateEqualPlanets (destination, source);
					source = startsource;
				} else {
					presource->l_next = source->l_next;
					eliminateEqualPlanets (destination, source);				
					source = presource->l_next;
				}
			}
			if (startsource != NULL && startsource->l_number < destination->l_number)
			{
				if (predestination == toWorld->pl_planetlist)
					toWorld->pl_planetlist = startsource;
				else
					predestination->l_next = startsource;
				presource->l_next = destination;
				predestination = presource;
			}
		}
		predestination = destination;
		destination = predestination->l_next;
	}
	if (source != NULL && ende == FALSE)
		predestination->l_next = source;
	return(TRUE);
}
#endif /* THO */


/*
 * Alle Planeten des Eigentuemers 'player' um 'offset' verschieben
 */
static void transPlanets(P(PLAYER *) aWorld, P(WORD) offset_x, P(WORD) offset_y)
PP(PLAYER *aWorld;)
PP(WORD offset_x;)
PP(WORD offset_y;)
{
	PlanetList *aPt;
	LIMES *limes;
	int maxMapSize = gc_global.maxMapSize;

	if (limesline)
	{
		limes = aWorld->pl_limes;
		while (limes != NULL)
		{
			limes->l_x -= offset_x;
			limes->l_y -= offset_y;
			if (limes->l_x > maxMapSize) limes->l_x -= maxMapSize;
			if (limes->l_x < 1) limes->l_x += maxMapSize;
			if (limes->l_y > maxMapSize) limes->l_y -= maxMapSize;
			if (limes->l_y < 1) limes->l_y += maxMapSize;
			limes = limes->l_next;
		}
	}
	for (aPt = aWorld->pl_planetlist; aPt != NULL; aPt = aPt->l_next)
	{
		aPt->l_koordinate.x -= offset_x;
		aPt->l_koordinate.y -= offset_y;
		while (aPt->l_koordinate.x > maxMapSize)
			aPt->l_koordinate.x -= maxMapSize;
		while (aPt->l_koordinate.x < 1)
			aPt->l_koordinate.x += maxMapSize;
		while (aPt->l_koordinate.y > maxMapSize)
			aPt->l_koordinate.y -= maxMapSize;
		while (aPt->l_koordinate.y < 1)
			aPt->l_koordinate.y += maxMapSize;
	}
}


#if THO
Bool joinMaps(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{
	PlanetList *toPt, *fromPt;
	WORD maps, test;
	WORD offset_x, offset_y;
	PLAYER *other, *test_player;
	
	if (verbose)
		fprintf(stderr, "join maps\n");
	
	/*
	 * Zunaechst alle anderen Karten untereinander verbinden
	 */
	for (test = 1; test <= gc_global.anz_spieler; test++)
	{
		test_player = get_player(test);
		if (test_player != NULL && test_player != aWorld && test_player->pl_planetlist != NULL)
		{
			for (maps = 1; maps <= gc_global.anz_spieler; maps++)
			{
				other = get_player(maps);
				if (other != NULL && other != aWorld &&
					other != test_player && other->pl_planetlist != NULL)
				{
					for (fromPt = other->pl_planetlist; fromPt != NULL; fromPt = fromPt->l_next)
					{
						if ((toPt = findPlanet(test_player, fromPt->l_number, NULL)) != NULL)
						{
							offset_x = fromPt->l_koordinate.x - toPt->l_koordinate.x;
							offset_y = fromPt->l_koordinate.y - toPt->l_koordinate.y;
							if (verbose)
							{
								fprintf(stderr, "planet %d matches between %s and %s\n", fromPt->l_number, test_player->pl_name, other->pl_name);
								if (debug)
									fprintf(stderr, "offset = %d,%d\n", offset_x, offset_y);
							}
							transPlanets(other, offset_x, offset_y);
							if (appendMap(test_player, other) == FALSE)
								return(FALSE);
							break;
						}
					}
				}
			}
		}
	}
	
	/*
	 * Dann alle Karten mit Spielerkarte verbinden
	 */
	for (maps = 1; maps <= gc_global.anz_spieler; maps++)
	{
		other = get_player(maps);
		if (other != NULL && other != aWorld && other->pl_planetlist != NULL)
		{
			for (fromPt = other->pl_planetlist; fromPt != NULL; fromPt = fromPt->l_next)
			{
				if ((toPt = findPlanet(aWorld, fromPt->l_number, NULL)) != NULL)
				{
					offset_x = fromPt->l_koordinate.x - toPt->l_koordinate.x;
					offset_y = fromPt->l_koordinate.y - toPt->l_koordinate.y;
					if (verbose)
					{
						fprintf(stderr, "planet %d matches between %s and %s\n", fromPt->l_number, aWorld->pl_name, other->pl_name);
						if (debug)
							fprintf(stderr, "offset = %d,%d\n", offset_x, offset_y);
					}
					transPlanets(other, offset_x, offset_y);
					if (appendMap(aWorld, other) == FALSE)
						return(FALSE);
					break;
				}
			}
		}
	}

	/*
	 * Karten wegschmeissen, in denen keine Uebereinstimmung war
	 */
	for (maps = 1; maps <= gc_global.anz_spieler; maps++)
	{
		other = get_player(maps);
		if (debug)
		{
			if (other != NULL && other->pl_heimat != 0)
			{
				fprintf(stderr, "Heimatplanet %s = %d\n", other->pl_name, other->pl_heimat);
			}
		}
		if (other != NULL && other != aWorld && other->pl_planetlist != NULL)
		{
			if (!quiet)
				fprintf(stderr, "no matching planet from %s\n", other->pl_name);
			freeMap(other);
		}
	}
	return(TRUE);
}

#else

Bool joinMaps(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{
	PlanetList *mapsPt, *cardPt;
	WORD maps, card;
	WORD offset_x, offset_y;
	PLAYER *one, *other;
	Bool found_one;
	
	if (verbose)
		fprintf(stderr,"join maps\n");

	for (maps = 1; maps <= gc_global.anz_spieler; maps++)
	{
		one = get_player(maps);
		if (one->pl_planetlist != NULL)
		{
			for (card = 1; card <= gc_global.anz_spieler; card++)
			{
				other = get_player (card);
				if (one != other && other->pl_planetlist != NULL)
				{
					if (other == aWorld)
					{
						other = one;
						one = aWorld;
					}
					found_one = FALSE;
					mapsPt = one->pl_planetlist;
					cardPt = other->pl_planetlist;
					while (mapsPt != NULL && found_one == FALSE)
					{
						while (cardPt != NULL &&
							   cardPt->l_number < mapsPt->l_number)
							cardPt = cardPt->l_next;
						if (cardPt != NULL &&
							cardPt->l_number == mapsPt->l_number)
						{
							found_one = TRUE;
							offset_x = cardPt->l_koordinate.x - mapsPt->l_koordinate.x;
							offset_y = cardPt->l_koordinate.y - mapsPt->l_koordinate.y;
							if (verbose)
							{
								fprintf(stderr, "planet %d matches for %s nr %3d and %s nr %3d\n",
										mapsPt->l_number, one->pl_name, one->pl_number,
										other->pl_name, other->pl_number);
								if (debug)
									fprintf(stderr, "offset = %d,%d\n", offset_x, offset_y);
							}
							transPlanets(other, offset_x, offset_y);
							appendMap(one, other);
							other->pl_planetlist = NULL;
						}
						mapsPt = mapsPt->l_next;
					}
				}
			}
		}
	}
	return(TRUE);
}
#endif


/* Die Funktion 'eliminateEqualPlanets' muss noch daraufhin getestet und
 * optimiert werden, dass wirklich nur die uninteressanteren Planeten
 * rausgeschmissen werden. Also Planeten ohne Info oder ...
 */

static void eliminateEqualPlanets(P(PlanetList *) stay, P(PlanetList *) go)
PP(PlanetList *stay;)
PP(PlanetList *go;)
{
	Bool copy_go_to_stay;

	copy_go_to_stay = FALSE;
	switch (stay->l_status)
	{
	case STATUS_UNKNOWN:				/* nur Koordinaten */
		if (go->l_status > STATUS_UNKNOWN)
			copy_go_to_stay = TRUE;
		else
			OFREE(go);
		break;
	case STATUS_INFO:
		if (go->l_status > STATUS_INFO)
			copy_go_to_stay = TRUE;
		else
			OFREE(go);
		break;
	case STATUS_OWN:					/* eigener Planet */
		OFREE(go);		
		break;
	case STATUS_ENEMY:
		if (go->l_status == STATUS_OWN)
			copy_go_to_stay = TRUE;
		else
			OFREE(go);
		break;
	}
	if (copy_go_to_stay)
	{
		go->l_next = stay->l_next;
		go->l_planet = stay->l_planet;
		*stay = *go;
		OFREE(go);
	}
}


/* EOF */
