#include <stdio.h>
#include <time.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"
#define EXTERN
#include "gcmapps.h"


#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif


static PLAYER *me;


/* Prototypen */

static Bool read_gcb _(( char *pathname, GC_MISC *gcb ));
static Bool read_vln _(( PLAYER *player, Bool must_exist ));
static Bool read_pln _(( PLAYER *player ));
static Bool read_nas _(( PLAYER *player ));
static Bool read_map _(( PLAYER *player ));
static void updateMps _(( char *fname, PLAYER *player ));
static char *compress_file_name _(( char *src ));
static PLAYER *find_player _(( char *filename ));
static void usage _(( void ));
static void mem_err _(( void ));


void get_map_args(P(int) argc, P(char **) argv,
	P(BYTE (*map_func)(char *, PLAYER *)) PP(map_func))
PP(int argc;)
PP(char **argv;)
PP(BYTE (*map_func) _(( char *, PLAYER * ));)
{
	char	fnameIn[MAX_PATHLEN], fnameOut[MAX_PATHLEN];
	WORD	circle;
	LIMES	*limes;
	PLAYER	*player;
	WORD	limes_number;
	Bool	join_maps = FALSE;
	Bool	search_player;
	char	*argp;
	Bool	optarg;
	WORD	rest_spieler = 0;
	char	all_player[MAX_SPIELER*MAX_NAMELG];
	char	*auto_player = all_player;
	
	circle = 0;
	limes_number = 0;
	limes = NULL;
	fnameIn[0] = fnameOut[0] = '\0';
	map_offset.x = map_offset.y = 0;
	while (rest_spieler != 0 || --argc)
	{
		if (rest_spieler > 0)
		{
			argp = auto_player;
			auto_player += MAX_NAMELG;
			rest_spieler--;
		} else {
			argp = *++argv;
		}
		if (*argp == '-')
		{
			optarg = FALSE;
			while (!optarg && *++argp)
			{
				switch (*argp)
				{
				case 'a':
					rest_spieler = suche_spielername(all_player, EXT_MAP, MAX_SPIELER);
					if (rest_spieler == 0 && !quiet)
						fprintf(stderr, "warning: no maps found\n");
					auto_player = all_player;
					break;
				case 'c':
					if (argc < 1) usage ();
					optarg = TRUE;
					gebiet = TRUE;
					if (circle < MAX_RADIEN)
					{
						WORD number;
						while ((circle < MAX_RADIEN) && argc)
						{
							argp = argv[1];
							number = atoi(argp);
							if ((*argp == '-' || *argp != '0') && number == 0)
								break;
							radius[circle++] = number;
							--argc;
							++argv;
						}
					} else {
						fprintf (stderr," Too many radien, only %d allowed =:^(\n", MAX_RADIEN);
						fprintf (stderr," Using the first %d only\n", MAX_RADIEN);
					}
					break;
				case 'd':
					debug++;
					verbose = TRUE;
					break;
				case 'f':
					if (--argc < 0) usage ();
					if (*(argp = *++argv) == '-') usage();
					strcpy(fontname, argp);
					optarg = TRUE;
					break;
				case 'g':
					if (argp[1] == 's') 
					{
						++argp;
						gsfix = TRUE;
						if (strcmp(fontname, PS_FONT) == 0)
							strcpy(fontname, GS_FONT);
					} else {
						gitter = TRUE;
					}
					break;
				case 'l':
					switch (argp[1])
					{
					case 'p':
						if (argc < 2) usage ();
						optarg = TRUE;
						while (argc)
						{
							WORD number;
							
							argp = argv[1];
							number = atoi(argp);
							if ((*argp == '-' || *argp != '0') && number == 0)
								break;
							if (AddLime(&limes, number, 0.0, 0.0, limes_number) == NULL)
								mem_err();
							--argc;
							++argv;
						}
						limes_number++;
						break;
					case 'k':
						if (argc < 4) usage ();
						optarg = TRUE;
						while (argc)
						{
							double x, y;
							
							argp = argv[1];
							x = atof(argp);
							if ((*argp == '-' || *argp != '0') && x == 0)
								break;
							y = atof(argv[2]);
							if (AddLime(&limes, 0, x, y, limes_number) == NULL)
								mem_err();
							argc -= 2;
							argv += 2;
						}
						limes_number++;
						break;
					}
					limesline = TRUE;
					break;
				case 'm':
					if (messydos)
						fprintf (stderr," Only -M OR -m, -m is ignorred\n");
					else
						monster = TRUE;
					break;
				case 'M':
					messydos = TRUE;
					if (monster)
					{
						fprintf (stderr, " Only -M OR -m, -M OVERRIDES -m\n");
						monster = FALSE;
					}
					break;
				case 'n':
					normal = TRUE;
					if (monster)
					{
						fprintf (stderr," Only -n OR -m, -n OVERRIDES -m\n");
						monster = FALSE;
					}
					break;
				case 'o':
					if (--argc < 0) usage();
					if (*(argp = *++argv) == '-' && argp[1] != '\0') usage();
					/* check for old -o radius option */
					if (atoi(argp) != 0)
						fprintf(stderr, "warning: -o is now -c\n");
					else
						STRCPY(fnameOut, argp);
					optarg = TRUE;
					break;
				case 'q':
					quiet = TRUE;
					break;
				case 'r':
					showRange = TRUE;
					break;
				case 's':
					if (--argc < 0) usage ();
					if (*(argp = *++argv) == '-') usage();
					sscanf(argp, "%lf", &scale);
					scale /= 100.0;
					optarg = TRUE;
					break;
				case 'S':
					showScouted = TRUE;
					break;
				case 't':
					if (--argc < 1) usage ();
					argp = *++argv;
					map_offset.x = atoi(argp);
					if (map_offset.x == 0 && *argp != '0') usage();
					argp = *++argv;
					map_offset.y = atoi(argp);
					if (map_offset.y == 0 && *argp != '0') usage();
					optarg = TRUE;
					-- argc;
					break;
				case 'v':
					verbose = TRUE;
					break;
				case 'x':
					plotStatus = FALSE;
					break;
				case 'z':
					if (argp[1] == 'p')
					{
						if (argc < 4) usage ();
						if (*(argp = *++argv) == '-') usage();
						map_min.x = atoi(argp);
						if (*(argp = *++argv) == '-') usage();
						map_max.x  = atoi(argp);
						if (*(argp = *++argv) == '-') usage();
						map_min.y = atoi(argp);
						if (*(argp = *++argv) == '-') usage();
						map_max.y = atoi(argp);
						part = TRUE;
						zoom = FALSE;
						optarg = TRUE;
						argc -= 4;
					} else {
						zoom = TRUE;
					}
					break;
				case 'h':
				case '?':
					usage ();
					break;
				default:
					fprintf (stderr, "unknown option '%c'.\n", *argp);
					usage();
				}
			}
		} else {
			STRCPY (fnameIn, argp);
			compress_file_name (fnameIn);
			search_player = FALSE;
			if (me == NULL)
			{
				if (read_gcb(fnameIn, &gc_global) == FALSE)
					exit(1);
				me = player = get_player(gc_global.sp_nummer);
				if (*fnameOut == '\0')
					STRCPY (fnameOut, fnameIn);
			} else {
				player = find_player(fnameIn);
				if (player == NULL)
				{
					if (!quiet)
						fprintf(stderr, "warning: player %s not found\n", fnameIn);
					player = (PLAYER *)CALLOC((size_t)1, sizeof(PLAYER), "getargs: player");
					if (player == NULL)
						mem_err();
					search_player = TRUE;
					strcpy(player->pl_name, compress_file_name(fnameIn));
				}
				if (player->pl_planets != NULL)
				{
					if (!quiet && player != me)
						fprintf(stderr, "warning: player %s specified twice\n", fnameIn);
					player = NULL;
				} else {
					player->pl_planets = (PLANET **)CALLOC((size_t)(gc_global.anz_planeten), sizeof(PLANET *), "getargs: Planets");
					if (player->pl_planets == NULL)
						mem_err();
				}
			}
			if (player != NULL)
			{
				strcpy(player->pl_path, fnameIn);
				player->pl_limes = limes;
				player->pl_limes_number = limes_number;
				if (monster)
				{
					if (read_nas(player) == FALSE)
						exit(1);
					if (read_pln(player) == FALSE)
						exit(1);
				}
				if (read_vln(player, player == me ? TRUE : FALSE) == FALSE)
					exit(1);
				if (read_map(player) == FALSE)
					exit(1);
				if (normal == FALSE)
					if (MergeInfo(player) != OK)
						mem_err();
				if (search_player)
				{
					PlanetList *list;
					PLANET *planet;
					PLAYER *real_player;
					WORD i;
					
					FindHomePlanets();
					for (list = player->pl_planetlist; list != NULL; list = list->l_next)
					{
						for (i = 1; i <= gc_global.anz_spieler; i++)
						{
							real_player = get_player(i);
							if (list->l_number == real_player->pl_heimat)
							{
								planet = find_planet(player, list->l_number, NULL);
								if (planet == NULL)
									planet = find_planet(real_player, list->l_number, NULL);
								if (planet != NULL && planet->p_owner != 0)
								{
									if (!quiet)
										fprintf(stderr, "notice: real name of %s was %s\n",
											player->pl_name, real_player->pl_name);
									player->pl_number = planet->p_owner;
									strcpy(player->pl_name, real_player->pl_name);
									if (real_player->pl_planets)
										free(real_player->pl_planets);
									free(real_player);
									gc_global.spieler[player->pl_number-1] = player;
								}
							}
						}
					}
				}
				UpdateLimesPos(player, limes);
				updateMps(fnameIn, player);
				if (player != me)
				{
					join_maps = TRUE;
				}
			}
		}
	}
	
	if (me == NULL)
	{
		fprintf (stderr, "no input file.\n\n");
		usage ();
	}
	
	switch (create_map(fnameOut, me, join_maps, map_func))
	{
	case FEHLER_C:
		fprintf(stderr, "can't create %s%s\n", fnameOut, EXT_PS);
		exit(1);
		break;
	case FEHLER_W:
		fprintf(stderr, "error writing %s%s\n", fnameOut, EXT_PS);
		exit(1);
		break;
	case FEHLER_M:
		mem_err();
		break;
	}
	
	for (argc = 1; argc <= gc_global.anz_spieler; argc++)
	{
		player = get_player(argc);
		delete_player(player);
		OFREE(player);
	}
	FREE(gc_global.spieler, gc_global.anz_spieler * sizeof(PLAYER *));
	gc_global.spieler = NULL;
}


static PLAYER *find_player(P(char *) filename)
PP(char *filename;)
{
	PLAYER *player;
	WORD i;
	char fnamebuf[10];
	char searchbuf[10];
	
	make_player_filename(searchbuf, filename);
	for (i = 1; i <= gc_global.anz_spieler; i++)
	{
		player = get_player(i);
		if (player != NULL)
		{
			make_player_filename(fnamebuf, player->pl_name);
			if (strcmp(fnamebuf, searchbuf) == 0)
				return(player);
		}
	}
	return(NULL);
}


static char *compress_file_name(P(char *) src)
PP(char *src;)
{
	char *p, *dot, *basename;
	
	basename = src;
	for (p = src, dot = NULL; *p; p++)
	{
		if (*p == '.')
			dot = p;
		else if (*p == '\\' || *p == '/')
		{
			dot = NULL;
			basename = p+1;
		}
	}
	if (dot)
		*dot = '\0';
	return(basename);
}


static Bool read_gcb(P(char *) pathname, P(GC_MISC *) gcb)
PP(char *pathname;)
PP(GC_MISC *gcb;)
{
	switch (get_gcb(pathname, gcb))
	{
	case FEHLER_O:
		fprintf(stderr, "can't open %s%s\n", pathname, EXT_GCB);
		return(FALSE);
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case FEHLER_V:
		fprintf(stderr, "wrong GCB-File Version in %s (%d.%d); need %d.%d\n",
			pathname,
			gcb->major, gcb->minor,
			GC_MAJOR, GC_MINOR);
		return(FALSE);
	case FEHLER_STYPEN:
		fprintf(stderr, "can handle only %d types of ships\n", MAX_STYPEN);
		return(FALSE);
	case FEHLER_SPIELER:
		fprintf(stderr, "can handle only %d players\n", MAX_SPIELER);
		return(FALSE);
	case FEHLER_SPIELER_NUMMER:
		fprintf(stderr, "illegal player number in %s\n", pathname);
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "error reading %s%s\n", pathname, EXT_GCB);
		return(FALSE);
	}
	return(TRUE);
}


static Bool read_pln(P(PLAYER *) player)
PP(PLAYER *player;)
{
	switch (get_pln(player, player->pl_path))
	{
	case FEHLER_R:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_PLN);
		return(FALSE);
	case FEHLER_O:
		switch (get_plb(player, player->pl_path))
		{
		case FEHLER_R:
			fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_PLB);
			return(FALSE);
		case FEHLER_O:
			if (!quiet)
				fprintf(stderr, "warning: can't find a pln or plb file for %s\n", player->pl_path);
			return(TRUE);
		case FEHLER_M:
			mem_err();
			return(FALSE);
		case OK:
			break;
		default:
			fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_PLB);
			return(FALSE);
		}
		break;
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_PLN);
		return(FALSE);
	}
	return(TRUE);
}


static Bool read_nas(P(PLAYER *) player)
PP(PLAYER *player;)
{
	switch (get_nas(player, player->pl_path, NULL))
	{
	case FEHLER_R:
	case FEHLER_F:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_NAS);
		return(FALSE);
	case FEHLER_O:
		switch (get_bas(player, player->pl_path, NULL))
		{
		case FEHLER_R:
			fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_BAS);
			return(FALSE);
		case FEHLER_O:
			if (!quiet)
				fprintf(stderr, "warning: can't find a bas or nas file for %s\n", player->pl_path);
			return(TRUE);
		case FEHLER_M:
			mem_err();
			return(FALSE);
		case OK:
			break;
		default:
			fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_BAS);
			return(FALSE);
		}
		break;
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_NAS);
		return(FALSE);
	}
	return(TRUE);
}


static Bool read_vln(P(PLAYER *) player, P(Bool) must_exist)
PP(PLAYER *player;)
PP(Bool must_exist;)
{
	switch (get_vln(player, player->pl_path))
	{
	case FEHLER_R:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_VLN);
		return(FALSE);
	case FEHLER_O:
		switch (get_vlb(player, player->pl_path))
		{
		case FEHLER_R:
			fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_VLB);
			return(FALSE);
		case FEHLER_O:
			if (!quiet)
				fprintf(stderr, "%scan't find a vln or vlb file for %s\n",
					must_exist ? "" : "warning: ", player->pl_path);
			return(must_exist ? FALSE : TRUE);
		case FEHLER_M:
			mem_err();
			return(FALSE);
		case OK:
			break;
		default:
			fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_VLB);
			return(FALSE);
		}
		break;
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_VLN);
		return(FALSE);
	}
	return(TRUE);
}


static Bool read_map(P(PLAYER *) player)
PP(PLAYER *player;)
{
	switch (get_map(player, player->pl_path, FALSE))
	{
	case FEHLER_R:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_MAP);
		return(FALSE);
	case FEHLER_O:
		fprintf(stderr, "warning: can't find map file for %s\n", player->pl_path);
		return(TRUE);
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case FEHLER_V:
		fprintf(stderr, "Version mismatch in %s%s\n", player->pl_path, EXT_MAP);
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_MAP);
		return(FALSE);
	}
	return(TRUE);
}


static void updateMps(P(char *) fname, P(PLAYER *) player)
PP(char *fname;)
PP(PLAYER *player;)
{
	switch (get_mps(fname, player))
	{
	case FEHLER_M:
		mem_err();
		break;
	case FEHLER_O:
		fprintf(stderr, "can't open %s%s\n", fname, EXT_MPS);
		exit(1);
		break;
	case OK:
		/* SortLimes(player); */
		switch (put_mps(fname, player))
		{
		case FEHLER_C:
			fprintf(stderr, "can't create %s%s\n", fname, EXT_MPS);
			exit(1);
			break;
		case OK:
			break;
		}
	}
}


static void usage(P(void))
{
	fprintf (stderr, "%s v%s, Bloody Harry (Schmidt), %s\n", program_name, Version, VDate);
	fprintf (stderr, "Usage: %s [options] input [input2 [input3 .. ]]\n", program_name);
	fprintf (stderr, "Options:\n");
	fprintf (stderr, "      -h                       print this help message\n");
	fprintf (stderr, "      -v                       verbose output (default off)\n");
	fprintf (stderr, "      -x                       suppress planet information (default off)\n");
	fprintf (stderr, "      -z                       zoom map to maximum size (default off)\n");
	fprintf (stderr, "      -zp minx maxx miny maxy  show only a piece of the map (default off)\n");
	fprintf (stderr, "      -r                       show spy ranges\n");
	fprintf (stderr, "      -g                       print raster\n");
	fprintf (stderr, "      -gs                      fix margins for ghostscript\n");
	fprintf (stderr, "      -s scale                 x/y-factor (default: 100%%)\n");
	fprintf (stderr, "      -t xoffset yoffset       set alternative map origin\n");
	fprintf (stderr, "      -c radius                draw circle(s) around the homePL (up to %d)\n", MAX_RADIEN);
	fprintf (stderr, "      -l                       draw boundarys\n");
	fprintf (stderr, "      -lp PL1 PL2....          draw boundary along the planets\n");
	fprintf (stderr, "      -lk X1 Y1 X2 Y2 ...      draw boundary along the coord.\n");
	fprintf (stderr, "      -m                       show NatDef and Fort's\n");
	fprintf (stderr, "      -M                       save memory, -m is ignored\n");
	fprintf (stderr, "      -n                       normal non zoomed Map, -m is ignored\n");
	fprintf (stderr, "      -f fontname              PS-font to use (default: %s)\n", fontname);
	fprintf (stderr, "      -o filename              specify output filename\n");
	fprintf (stderr, "      -a                       read all maps found in directory\n");
	fprintf (stderr, "      -S                       show scouted planets\n");
	exit (2);
}


static void mem_err(P(void))
{
	fprintf(stderr, "not enough memory\n");
	exit(1);
}

/* EOF */
