#include <stdio.h>
#include <time.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"

char *program_name = "genlgb";
int verbose = TRUE;
int quiet = FALSE;
int debug = 0;

static BYTE read_nas _(( PLAYER * ));
static BYTE read_vln _(( PLAYER *player, BYTE must_exist ));
static BYTE read_pln _(( PLAYER *player ));
static BYTE read_gcb _(( char *pathname, GC_MISC *gcb ));
static void gen_lgb _(( FILE *fp, PLANET *planet ));
static void mem_err _(( void ));
int main _(( int, char ** ));


static void mem_err(P(void))
{
	fprintf(stderr, "not enough memory\n");
	exit(1);
}


static BYTE read_gcb(P(char *) pathname, P(GC_MISC *) gcb)
PP(char *pathname;)
PP(GC_MISC *gcb;)
{
	switch (get_gcb(pathname, gcb))
	{
	case FEHLER_O:
		fprintf(stderr, "can't open %s%s\n", pathname, EXT_GCB);
		return(FALSE);
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case FEHLER_V:
		fprintf(stderr, "wrong GCB-File Version in %s (%d.%d); need %d.%d\n",
			pathname,
			gcb->major, gcb->minor,
			GC_MAJOR, GC_MINOR);
		return(FALSE);
	case FEHLER_STYPEN:
		fprintf(stderr, "can handle only %d types of ships\n", MAX_STYPEN);
		return(FALSE);
	case FEHLER_SPIELER:
		fprintf(stderr, "can handle only %d players\n", MAX_SPIELER);
		return(FALSE);
	case FEHLER_SPIELER_NUMMER:
		fprintf(stderr, "illegal player number in %s\n", pathname);
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "error reading %s%s\n", pathname, EXT_GCB);
		return(FALSE);
	}
	return(TRUE);
}


static BYTE read_nas(P(PLAYER *) player)
PP(PLAYER *player;)
{
	switch (get_nas(player, player->pl_path, NULL))
	{
	case FEHLER_R:
	case FEHLER_F:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_NAS);
		return(FALSE);
	case FEHLER_O:
		switch (get_bas(player, player->pl_path, NULL))
		{
		case FEHLER_R:
			fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_BAS);
			return(FALSE);
		case FEHLER_O:
			if (!quiet)
				fprintf(stderr, "warning: can't find a bas or nas file for %s\n", player->pl_path);
			return(TRUE);
		case FEHLER_M:
			mem_err();
			return(FALSE);
		case OK:
			break;
		default:
			fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_BAS);
			return(FALSE);
		}
		break;
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_NAS);
		return(FALSE);
	}
	return(TRUE);
}


static BYTE read_pln(P(PLAYER *) player)
PP(PLAYER *player;)
{
	switch (get_pln(player, player->pl_path))
	{
	case FEHLER_R:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_PLN);
		return(FALSE);
	case FEHLER_O:
		switch (get_plb(player, player->pl_path))
		{
		case FEHLER_R:
			fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_PLB);
			return(FALSE);
		case FEHLER_O:
			if (!quiet)
				fprintf(stderr, "warning: can't find a pln or plb file for %s\n", player->pl_path);
			return(TRUE);
		case FEHLER_M:
			mem_err();
			return(FALSE);
		case OK:
			break;
		default:
			fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_PLB);
			return(FALSE);
		}
		break;
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_PLN);
		return(FALSE);
	}
	return(TRUE);
}


static BYTE read_vln(P(PLAYER *) player, P(BYTE) must_exist)
PP(PLAYER *player;)
PP(BYTE must_exist;)
{
	switch (get_vln(player, player->pl_path))
	{
	case FEHLER_R:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_VLN);
		return(FALSE);
	case FEHLER_O:
		switch (get_vlb(player, player->pl_path))
		{
		case FEHLER_R:
			fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_VLB);
			return(FALSE);
		case FEHLER_O:
			if (!quiet)
				fprintf(stderr, "%scan't find a vln or vlb file for %s\n",
					must_exist ? "" : "warning: ", player->pl_path);
			return(must_exist ? FALSE : TRUE);
		case FEHLER_M:
			mem_err();
			return(FALSE);
		case OK:
			break;
		default:
			fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_VLB);
			return(FALSE);
		}
		break;
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_VLN);
		return(FALSE);
	}
	return(TRUE);
}


static void gen_lgb(P(FILE *) fp, P(PLANET *) planet)
PP(FILE *fp;)
PP(PLANET *planet;)
{
	int i;
	
	fprintf(fp, "****************** Planet %4d *************************\n", planet->p_number);
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "* Position: %3d,%-3d   Besitzer: %-*s  *\n", planet->p_pos_x, planet->p_pos_y, MAX_NAMELG, owner_name(planet));
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "* Bevoelkerung: %-5d Loyalitaet: %-2d                   *\n", planet->p_ladung[LAD_KOLONIST], planet->p_loyal);
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "* Festungen: %-4d     Verteidigungsfaktor: %-4d        *\n", planet->p_new_festungen, planet->p_nat_def);
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "* Anzahl Schiffe im System: %-4d                       *\n", planet->p_num_ships);
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "* Schiffsproduktion:   Werft Groesse S-Typ  PE         *\n");
	fprintf(fp, "*                      -----------------------         *\n");
	for (i = 0; i < MAX_WERFT; i++)
	{
	fprintf(fp, "*                      %3d      %3d   %3d   %3d        *\n", i+1, planet->p_werft[i].w_groesse, planet->p_werft[i].w_typ, planet->p_werft[i].w_pe);
	}
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "*     Prod.-Anlagen   maximal  momentan  Kits  xPE     *\n");
	fprintf(fp, "*     --------------------------------------------     *\n");
	fprintf(fp, "*     Minen       ==>   %3d      %3d     %3d   %3d     *\n", planet->p_max_minen, planet->p_minen, planet->p_ladung[LAD_MKITS], planet->p_ladung[LAD_MPE]);
	fprintf(fp, "*     Landw.      ==>   %3d      %3d     %3d   %3d     *\n", planet->p_max_landw, planet->p_landw, planet->p_ladung[LAD_LKITS], planet->p_ladung[LAD_LPE]);
	fprintf(fp, "*     Raffinerien ==>   %3d      %3d     %3d   %3d     *\n", planet->p_max_raffs, planet->p_raffs, planet->p_ladung[LAD_RKITS], planet->p_ladung[LAD_RPE]);
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "*     Fabriken    ==>   %3d      %3d     %3d           *\n", planet->p_ladung[LAD_KOLONIST] / 10, planet->p_fabriken, planet->p_ladung[LAD_FKITS]);
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "* Verfuegbare Produktionseinheiten: %-4d               *\n", planet->p_pe);
	fprintf(fp, "*                                                      *\n");
	fprintf(fp, "********************************************************\n");
	fprintf(fp, "\n");
}


int main(P(int) argc, P(char **) argv)
PP(int argc;)
PP(char **argv;)
{
	char *argp;
	PLAYER *player;
	FILE *fp = stdout;
	WORD i;
	PLANET *planet;
	
	while (--argc)
	{
		argp = *++argv;
		if (read_gcb(argp, &gc_global) != FALSE)
		{
			player = get_player(gc_global.sp_nummer);
			strcpy(player->pl_path, argp);
			if (read_nas(player) != FALSE)
			{
				read_pln(player);
				read_vln(player, FALSE);
				reset_to_initial_state(player);
				for (i = 1; i <= gc_global.anz_planeten; i++)
				{
					planet = find_planet(player, i, NULL);
					if (planet != NULL)
						gen_lgb(fp, planet);
				}
			}
			delete_player(player);
		}
	}
	exit(0);
	return(0);
}
