#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

static BYTE _put_nas _(( PLAYER *, FILE * ));

/*
 * NAS-Datei schreiben
 */
static BYTE _put_nas(P(PLAYER *) player, P(FILE *) datei)
PP(PLAYER *player;)
PP(FILE *datei;)
{
	WORD ende, zaehler;
	PLANET *planet, **planets;
	
	planets = player->pl_planets;
	ende = 0;
	for (zaehler = 0; zaehler < gc_global.anz_planeten; zaehler++)
		if (planets[zaehler] != NULL)
			++ende;
	
	player->pl_known_planets = ende;

	if (EOF == fprintf(datei, "%d\n", ende))
		return(FEHLER_W);
	
	ende = gc_global.anz_planeten;
	for (zaehler = 0; zaehler < ende; zaehler++)
	{
		planet = planets[zaehler];
		if (planet != NULL)
		{
			if (fprint_planet1(datei, planet))
				return(FEHLER_W);
			if (fprint_planet2(datei, planet))
				return(FEHLER_W);
		}
	}

	if (ferror(datei) || fflush(datei) == EOF)
		return(FEHLER_W);
	return(OK);
}


BYTE put_nas(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *planeten_datei;
	BYTE ok;
	char datei[MAX_PATHLEN];
	
	sprintf(datei, "%s%s", pathname, EXT_NAS);

	if ((planeten_datei = fopen(datei, FWRITE_TEXT)) == NULL)
		return(FEHLER_O);

	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	ok = _put_nas(player, planeten_datei);

	f_close(planeten_datei);
	if (ok == OK)
		player->pl_bas_file_changed = FALSE;
	return(ok);
}



