#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

static BYTE _put_map _(( PLAYER *, FILE * ));

/*
 * MAP-Datei schreiben
 */
static BYTE _put_map(P(PLAYER *) player, P(FILE *) map_datei)
PP(PLAYER *player;)
PP(FILE *map_datei;)
{
	PLANET **planets;
	PLANET *planet;
	int i, status;
	
	planets = player->pl_planets;
	fprintf(map_datei, "%d\n", gc_global.starDate);
	fprintf(map_datei, "%d\n", gc_global.maxMapSize);
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		
		if (planet && position_known(planet))
		{
			status = planet_status(player, planet);
			fprintf(map_datei, "%d %d %d %d\n",
				planet->p_number,
				planet->p_pos_x,
				planet->p_pos_y,
				status);
		}
		if (ferror(map_datei))
			return(FEHLER_W);
	}
	return(OK);
}


BYTE put_map(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *map_datei;
	BYTE fehler;
	char datei[MAX_PATHLEN];
	
	sprintf(datei, "%s%s", pathname, EXT_MAP);

	if ((map_datei = fopen(datei, FWRITE_TEXT)) == NULL)
	{
		return(FEHLER_C);
	}
	if (verbose)
		fprintf (stderr, "writing %s ...\n", datei);
	fehler = _put_map(player, map_datei);
	f_close(map_datei);
	return(fehler);
}



