#include <stdio.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"

static BYTE _get_vln _(( PLAYER *, FILE *, char * ));

/*
 * VLN-Datei einlesen
 */
static BYTE _get_vln(P(PLAYER *) player, P(FILE *) vln_datei, P(char *) filename)
PP(PLAYER *player;)
PP(FILE *vln_datei;)
PP(char *filename;)
{
	int nachricht, wort2, wort3, wort4;
	STATIC char r_buf[2048];
	PLANET *planet;
	int new_planet;
	WORD platzierung = 0;
	
	while (NULL != fgets(r_buf, (int) sizeof(r_buf), vln_datei))
	{
		if (sscanf(r_buf, "%d %d %d %d", &nachricht, &wort2, &wort3, &wort4) != 4)
			return(FEHLER_F);
		switch (nachricht)
		{
		case 0:		/* Sternzeit */
			if (gc_global.starDate == 0)
				gc_global.starDate = wort2;
			else if (gc_global.starDate != wort2 && !quiet)
				fprintf(stderr, "warning: %s out of date (%d)\n", filename, wort2);
			break;

		case 1:		/* Info ueber Festungen */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return(errno);
			if (new_planet || (planet->p_festungen != wort3 && planet->p_festungen != -1))
				player->pl_bas_file_changed = TRUE;
			planet->p_festungen = wort3;
			break;

		case 2:		/* Bonus */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return(errno);
			if (new_planet || planet->p_bonus != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_bonus = wort3;
			break;

		case 3:		/* Info ueber Eigentuemer eines Planeten */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return(errno);
			if (new_planet || planet->p_owner != wort3)
				player->pl_bas_file_changed = TRUE;
			planet->p_owner = wort3;
			break;

		case 4:		/* Info ueber Planetenposition */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return(errno);
			if (new_planet || planet->p_pos_x != wort3 || planet->p_pos_y != wort4)
				player->pl_bas_file_changed = TRUE;
			planet->p_pos_x = wort3;
			planet->p_pos_y = wort4;
			break;
		
		case 5:		/* Eigenes Schiff zerstoert */
			if (wort3 < 1 || wort3 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort4 < 1 || wort4 > gc_global.anz_planeten)
				return(FEHLER_F);
			break;
		
		case 6:		/* Feindliches Schiff zerstoert */
			if (wort2 < 1 || wort2 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_planeten)
				return(FEHLER_F);
			
			break;
		
		case 7:		/* Angriff auf Planet */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_spieler)
				return(FEHLER_F);
			planet = find_planet(player, wort2, FALSE);
			break;
		
		case 50:	/* Eigene Platzierung */
			player->pl_platz = wort2;
			player->pl_score = wort3;
			player->pl_zuwachs = wort4;
			break;
		
		case 51:	/* Info ueber Top 5 */
			{
				PLAYER *who;
				
				if (wort2 < 1 || wort2 > gc_global.anz_spieler)
					return(FEHLER_F);
				who = get_player(wort2);
				platzierung++;
				who->pl_platz = platzierung;
				who->pl_score = wort3;
				who->pl_zuwachs = wort4;
			}
			break;
		
		case 52:	/* Anonyme Scoreliste */
			if (wort2 >= 1 && wort2 <= gc_global.anz_spieler)
			{
				gc_global.anonym[wort2-1] = wort3;
			}
			break;
			
		case 101:	/* Info ueber Tech-Level */
			if (wort2 < 0 || wort2 >= ANZ_FG)
				return(FEHLER_F);
			player->pl_tech_level_pes[wort2] = wort3;
			player->pl_tech_level[wort2] = wort4;
			player->pl_tech_level_newpes[wort2] = wort3;
			player->pl_tech_level_new[wort2] = wort4;
			break;
		}
	}
	return(OK);
}


BYTE get_vln(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *vln_datei;
    char datei[MAX_PATHLEN];
	BYTE fehler;
	
	sprintf(datei, "%s%s", pathname, EXT_VLN);

	if ((vln_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		return(FEHLER_O);
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_vln(player, vln_datei, datei);
	f_close(vln_datei);
	return(fehler);
}




