#include <stdio.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif


typedef struct _plist {
	PLANET planet;
	struct _plist *next;
} PLIST;

static BYTE _get_pln _(( FILE *, PLAYER * ));

/*
 * PLN-Datei einlesen
 */
static BYTE _get_pln(P(FILE *) pln_datei, P(PLAYER *) player)
PP(FILE *pln_datei;)
PP(PLAYER *player;)
{
	WORD nummer, eigner;
	WORD wz;
	UBYTE spieler;
	STATIC char r_buf[2048];
	PLANET *planet;
	char *p;
	PLANET old_planet;
	int new_planet;
	PLIST *plist = NULL;
	PLIST *pl;
	WORD x, y;

	spieler = gc_global.sp_nummer;
	while (fgets(r_buf, (int)sizeof(r_buf), pln_datei) != NULL)
	{
		p = r_buf;
		nummer = (WORD)sgetint(&p);
		x = (WORD)sgetint(&p);
		y = (WORD)sgetint(&p);
		eigner = (WORD)sgetint(&p);

		/*
		 * erst mal schauen, ob wir den schon gehabt haben
		 */
		for (pl = plist; pl != NULL; pl = pl->next)
			if (pl->planet.p_number == nummer)
				break;
		if (pl != NULL)
		{
			planet = &pl->planet;
		} else {
			if ((planet = find_planet(player, nummer, &new_planet)) == NULL)
				return(errno);
		}
		old_planet = *planet;
		
		planet->p_pos_x = x;
		planet->p_pos_y = y;

		if (spieler != eigner)
		{
			/*
			 * wenns kein eigener Planet ist, kommt moeglicherweise
			 * nochmal ne Info nach dem Angriff
			 */
			if (pl == NULL)
			{
				if ((pl = NEW(PLIST, "_get_pln")) == NULL)
					return(FEHLER_M);
				pl->next = plist;
				plist = pl;
				planet = &pl->planet;
				memset(planet, 0, sizeof(*planet));
				planet->p_number = nummer;
				planet->p_owner = eigner;
				planet->p_pos_x = x;
				planet->p_pos_y = y;
			}
		}

		if (eigner != 0)
			planet->p_owner = eigner;
		planet->p_nat_def = (UBYTE) sgetint(&p);

		planet->p_pe = (WORD)sgetint(&p);

		planet->p_max_minen = (UBYTE) sgetint(&p);
		planet->p_minen = (UBYTE) sgetint(&p);
		planet->p_max_landw = (UBYTE) sgetint(&p);
		planet->p_landw = (UBYTE) sgetint(&p);
		planet->p_max_raffs = (UBYTE) sgetint(&p);
		planet->p_raffs = (UBYTE) sgetint(&p);

		planet->p_fabriken = (WORD)sgetint(&p);

		planet->p_ladung[LAD_SPARES] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_MPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_LPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_RPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_MKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_LKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_RKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_FKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_KOLONIST] = (WORD)sgetint(&p);

		planet->p_festungen = (WORD)sgetint(&p);
		planet->p_loyal = (WORD)sgetint(&p);
		planet->p_kampf = (WORD)sgetint(&p);

		planet->p_num_ships = (WORD)sgetint(&p);

		for (wz = 0; wz < MAX_WERFT; wz++)
		{
			planet->p_werft[wz].w_groesse = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe_in_runde = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe = (WORD)sgetint(&p);
			planet->p_werft[wz].w_typ = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_erster = (UBYTE) sgetint(&p);
		}

		planet->p_visited = (WORD)sgetint(&p);
		planet->p_bonus = (WORD)sgetint(&p);

		planet->p_no_use1 = (WORD)sgetint(&p);
		planet->p_no_use2 = (WORD)sgetint(&p);
		
		if (pl == NULL)
		{
			if (new_planet || memcmp(planet, &old_planet, GR__PLANET) != 0)
				player->pl_bas_file_changed = TRUE;
		}
	}

	while (plist != NULL)
	{
		planet = find_planet(player, plist->planet.p_number, &new_planet);
		if (planet == NULL)
			return(errno);
		plist->planet.p_old = planet->p_old;
		if (new_planet || memcmp(planet, &plist->planet, GR__PLANET) != 0)
		{
			*planet = plist->planet;
			player->pl_bas_file_changed = 1;
		}
		pl = plist->next;
		OFREE(plist);
		plist = pl;
	}
	player->pl_num_planets = 0;
	for (nummer = 1; nummer <= gc_global.anz_planeten; nummer++)
	{
		planet = find_planet(player, nummer, NULL);
		if (planet != NULL && planet->p_owner == spieler)
			player->pl_num_planets++;
	}
	return(OK);
}


BYTE get_pln(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *pln_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;
	
	/* PLN Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLN);
	if ((pln_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		return(FEHLER_O);
	}

	if (verbose)
		fprintf (stderr, "reading %s ... \n", datei);
	fehler = _get_pln(pln_datei, player);
	f_close(pln_datei);
	return(fehler);
}




