#include <stdio.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif


typedef struct _plist {
	PLANET planet;
	struct _plist *next;
} PLIST;

static BYTE _get_plb _(( WORD , FILE *, PLAYER * ));

/*
 * PLB-Datei einlesen
 */
static BYTE _get_plb(P(WORD) pl_zahl, P(FILE *) plb_datei, P(PLAYER *) player)
PP(WORD pl_zahl;)
PP(FILE *plb_datei;)
PP(PLAYER *player;)
{
	WORD zaehler, wz, bonus, nummer;
	UBYTE eigner, spieler, X, Y, r_buf[PLB_ST_GR], offset;
	PLANET *planet;
	PLANET old_planet;
	int new_planet;
	PLIST *plist = NULL;
	PLIST *pl;
	
	spieler = player->pl_number;
	for (zaehler = 0; zaehler < pl_zahl; zaehler++)
	{
		offset = 0;
		if (fread(r_buf, PLB_ST_GR, 1, plb_datei) != 1)
		{
			return(FEHLER_R);
		}

		bgetword(nummer);
		bgetbyte(X);
		bgetbyte(Y);
		bonus = r_buf[59+2];
		/* Eigentlich nur fuer BAS, da in PLB nur bekannte Pl stehen */
		if (X || Y || bonus)
		{
			/*
			 * erst mal schauen, ob wir den schon gehabt haben
			 */
			for (pl = plist; pl != NULL; pl = pl->next)
				if (pl->planet.p_number == nummer)
					break;
			if (pl != NULL)
			{
				planet = &pl->planet;
			} else {
				planet = find_planet(player, nummer, &new_planet);
				if (planet == NULL)
					return(errno);
			}

			old_planet = *planet;
			
			bgetbyte(eigner);

			planet->p_pos_x = X;
			planet->p_pos_y = Y;

			if (spieler != eigner)
			{
				/*
				 * wenns kein eigener Planet ist, kommt moeglicherweise
				 * nochmal ne Info nach dem Angriff
				 */
				if (pl == NULL)
				{
					if ((pl = NEW(PLIST, "_get_pln")) == NULL)
						return(FEHLER_M);
					pl->next = plist;
					plist = pl;
					planet = &pl->planet;
					memset(planet, 0, sizeof(*planet));
					planet->p_number = nummer;
					planet->p_owner = eigner;
					planet->p_pos_x = X;
					planet->p_pos_y = Y;
				}
			}
			
			if (eigner != 0)
				planet->p_owner = eigner;
			
			bget_rest_of_planet(planet, r_buf, offset);
			
			if (pl == NULL)
			{
				if (new_planet || memcmp(planet, &old_planet, GR__PLANET) != 0)
					player->pl_bas_file_changed = TRUE;
			}
		}
	}

	while (plist != NULL)
	{
		planet = find_planet(player, plist->planet.p_number, &new_planet);
		if (planet == NULL)
			return(errno);
		plist->planet.p_old = planet->p_old;
		if (new_planet || memcmp(planet, &plist->planet, GR__PLANET) != 0)
		{
			*planet = plist->planet;
			player->pl_bas_file_changed = 1;
		}
		pl = plist->next;
		OFREE(plist);
		plist = pl;
	}
	player->pl_num_planets = 0;
	for (nummer = 1; nummer <= gc_global.anz_planeten; nummer++)
	{
		planet = find_planet(player, nummer, NULL);
		if (planet != NULL && planet->p_owner == spieler)
			player->pl_num_planets++;
	}
	return(OK);
}


BYTE get_plb(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *plb_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;
	WORD pl_zahl;
	
	/* PLB Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLB);
	if ((plb_datei = fopen(datei, FREAD_BIN)) == NULL)
	{
		return(FEHLER_O);
	}
	
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	pl_zahl = (WORD)(datei_laenge(plb_datei) / PLB_ST_GR);
	fehler = _get_plb(pl_zahl, plb_datei, player);
	f_close(plb_datei);
	return(fehler);
}



