#include <stdio.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"

static BYTE _get_nas _(( FILE *, PLAYER *, WORD * ));

/*
 * NAS-Datei einlesen
 */
static BYTE _get_nas(P(FILE *) nas_datei, P(PLAYER *) player, P(WORD *) found)
PP(FILE *nas_datei;)
PP(PLAYER *player;)
PP(WORD *found;)
{
	WORD nummer, eigner;
	int pl_zahl;
	WORD zaehler, wz;
	STATIC char r_buf[2048];
	PLANET *planet;
	char *p;
	int new_planet;

	*found = 0;
	if (fgets(r_buf, (int)sizeof(r_buf), nas_datei) == NULL)
		return(FEHLER_R);
	p = r_buf;
	pl_zahl = (int)sgetint(&p);
	zaehler = 0;
	while (fgets(r_buf, (int)sizeof(r_buf), nas_datei) != NULL)
	{
		p = r_buf;
		nummer = (WORD) sgetint(&p);

		if ((planet = find_planet(player, nummer, &new_planet)) == NULL)
		{
			return(errno);
		}
		planet->p_old = 1;
		zaehler++;

		planet->p_number = nummer;
		planet->p_pos_x = (WORD) sgetint(&p);
		planet->p_pos_y = (WORD) sgetint(&p);

		eigner = (WORD) sgetint(&p);

		if (eigner != 0)
			planet->p_owner = eigner;
		planet->p_nat_def = (UBYTE) sgetint(&p);

		planet->p_pe = (WORD)sgetint(&p);

		planet->p_max_minen = (UBYTE) sgetint(&p);
		planet->p_minen = (UBYTE) sgetint(&p);
		planet->p_max_landw = (UBYTE) sgetint(&p);
		planet->p_landw = (UBYTE) sgetint(&p);
		planet->p_max_raffs = (UBYTE) sgetint(&p);
		planet->p_raffs = (UBYTE) sgetint(&p);

		planet->p_fabriken = (WORD)sgetint(&p);

		planet->p_ladung[LAD_SPARES] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_MPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_LPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_RPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_MKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_LKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_RKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_RKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_KOLONIST] = (WORD)sgetint(&p);

		planet->p_festungen = (WORD)sgetint(&p);
		planet->p_loyal = (WORD)sgetint(&p);
		planet->p_kampf = (WORD)sgetint(&p);

		planet->p_num_ships = (WORD)sgetint(&p);

		for (wz = 0; wz < MAX_WERFT; wz++)
		{
			planet->p_werft[wz].w_groesse = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe_in_runde = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe = (WORD)sgetint(&p);
			planet->p_werft[wz].w_typ = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_erster = (UBYTE) sgetint(&p);
		}

		planet->p_visited = (WORD)sgetint(&p);
		planet->p_bonus = (WORD)sgetint(&p);
		planet->p_no_use1 = (WORD)sgetint(&p);
		planet->p_no_use2 = (WORD)sgetint(&p);
	}
	if (zaehler != pl_zahl)
		return(FEHLER_R);
	*found = zaehler;
	return(OK);
}


BYTE get_nas(P(PLAYER *) player, P(char *) pathname, P(WORD *) bas_pl_zahl)
PP(PLAYER *player;)
PP(char *pathname;)
PP(WORD *bas_pl_zahl;)
{
	FILE *nas_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;
	WORD found;

	/* NAS Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_NAS);
	if ((nas_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		return(FEHLER_O);
	}

	if (verbose)
		fprintf (stderr, "reading %s ... ", datei);
	fehler = _get_nas(nas_datei, player, &found);
	if (verbose)
		fprintf(stderr, "found %d planets\n", found);
	f_close(nas_datei);
	player->pl_bas_file_changed = FALSE;
	if (bas_pl_zahl != NULL)
		*bas_pl_zahl = found;
	return(fehler);
}




