#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif

static BYTE _get_gcb _(( FILE *, GC_MISC * ));

/* Hier wird die Hauptstruktur mit den Spielrundendaten initialisiert   */
/* Muss unbedingt vor get_config aufgerufen werden, wegen Initalisierung */
/* der Schiffsstruktur!!!!!!!!!!!!!                                     */

static BYTE _get_gcb(P(FILE *) gcb_datei, P(GC_MISC *) gcb)
PP(FILE *gcb_datei;)
PP(GC_MISC *gcb;)
{
	char *temp_zeiger, *space;
	WORD zaehler, grenze, tl;
	int wert;
	char line[BUFFER_GR+1];
	int heimat;
	PLAYER *player;

	/* Aktuelle Versionsnummer des Zugeditors */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading first line\n"); */
		return(FEHLER_R);
	}
	temp_zeiger = line;
	gcb->major = (UBYTE) sgetint(&temp_zeiger);
	if (*temp_zeiger != '.')
		return(FEHLER_F);
	temp_zeiger++;
	gcb->minor = (UBYTE) sgetint(&temp_zeiger);
	/* printf("major = %d, minor = %d\n", gcb->major, gcb->minor); */

	if (GC_VERSION_NUMBER(gcb->major, gcb->minor) < GC_MIN_VERSION)
	{
		return(FEHLER_V);
	}
	if (GC_VERSION_NUMBER(gcb->major, gcb->minor) > GC_VERSION)
	{
		return(FEHLER_V);
	}

	/* Kennung der GC-Runde */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading GC-ID\n"); */
		return(FEHLER_R);
	}
	sscanf(line, "%s ", gcb->gc_id);
	/* printf("GC-ID = %s\n", gcb->gc_id); */

	/* Eigene Spielernummer */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading player number\n"); */
		return(FEHLER_R);
	}
	if (sscanf(line, "%d ", &wert) != 1)
		return(FEHLER_F);
	gcb->sp_nummer = (UBYTE) wert;
	/* printf("player number %d\n", gcb->sp_nummer); */

	/* Nummer des Heimatplaneten */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading home planet\n"); */
		return(FEHLER_R);
	}
	if (sscanf(line, "%d ", &wert) != 1)
		return(FEHLER_F);
	heimat = wert;
	/* printf("home planet = %d\n", heimat); */

	/* Groesse des Universums */
	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading universe size\n"); */
		return(FEHLER_R);
	}
	if (sscanf(line, "%d ", &wert) != 1)
		return(FEHLER_F);
	gcb->maxMapSize = wert;
	/* printf("maxmapsize = %d\n", gcb->maxMapSize); */

	/* Anzahl der vorhandenen Planeten */
	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading number of planets\n"); */
		return(FEHLER_R);
	}
	if (sscanf(line, "%d ", &wert) != 1)
		return(FEHLER_F);
	/* printf("number of planets = %d\n", wert); */
	if (heimat <= 0 || heimat > wert)
		return(FEHLER_F);
	gcb->anz_planeten = wert;

	/* Anzahl der zulaessigen Task-Force */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading number of task forces\n"); */
		return(FEHLER_R);
	}
	if (sscanf(line, "%d ", &wert) != 1)
		return(FEHLER_F);
	/* printf("task forces = %d\n", wert); */
	gcb->max_tf = wert;

	/* Anzahl der teilnehmenden Spieler */
	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading number of players\n"); */
		return(FEHLER_R);
	}
	if (sscanf(line, "%d ", &wert) != 1)
		return(FEHLER_F);
	gcb->anz_spieler = wert;
	/* printf("number of players = %d\n", gcb->anz_spieler); */

	grenze = gcb->anz_spieler;
	if (grenze < 2 || grenze > MAX_SPIELER)
		return(FEHLER_SPIELER);
	if (gcb->sp_nummer < 1 || gcb->sp_nummer > gcb->anz_spieler)
		return(FEHLER_SPIELER_NUMMER);
	if (gcb->spieler == NULL)
	{
		gcb->spieler = (PLAYER **)CALLOC((size_t)(grenze), sizeof(PLAYER *), "_get_gcb: spieler");
		if (gcb->spieler == NULL)
			return(FEHLER_M);
		for (zaehler = 0; zaehler < gcb->anz_spieler; zaehler++)
		{
			if ((gcb->spieler[zaehler] = (PLAYER *)CALLOC((size_t)1, sizeof(PLAYER), "_geb_gcb: player")) == NULL)
				return(FEHLER_M);
		}
	}
	player = gcb->spieler[gcb->sp_nummer-1];
	player->pl_heimat = heimat;
	player->pl_number = gcb->sp_nummer;
	player->pl_planets = (PLANET **)CALLOC((size_t)(gcb->anz_planeten), sizeof(PLANET *), "_get_gcb: planets");
	if (player->pl_planets == NULL)
		return(FEHLER_M);

	/* Spielernamen einlesen */

	for (zaehler = 1; zaehler <= grenze; zaehler++)
	{
		PLAYER *p;

		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		{
			/* printf("error reading player name %d\n", zaehler); */
			return(FEHLER_R);
		}
		if ((space = strchr(line, '\r')) != NULL)
		{
			*space = '\0';
		} else
		{
			if ((space = strchr(line, '\n')) != NULL)
				*space = '\0';
		}
		p = gcb->spieler[zaehler-1];
		p->pl_number = zaehler;
		space = line;
		while (*space)
		{
			if (*space == ' ' && space[1] == ' ')
			{
				*space = '\0';
				space += 2;
				while (*space == ' ')
					space++;
				STRNCPY(p->pl_address, space, sizeof(p->pl_address));
				break;
			} else {
				space++;
			}
		}
		STRNCPY(p->pl_name, line, sizeof(p->pl_name));
		/* printf("player %d = %s\n", zaehler, p->pl_name); */
	}

	/* Anzahl der Schiffstypen */

	if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
	{
		/* printf("error reading number of shiptypes\n"); */
		return(FEHLER_R);
	}
	if (sscanf(line, "%d ", &wert) != 1)
		return(FEHLER_F);
	gcb->anz_stypen = (UBYTE) wert;
	/* printf("ship types = %d\n", gcb->anz_stypen); */

	grenze = gcb->anz_stypen;
	if (grenze > MAX_STYPEN)
		return(FEHLER_STYPEN);

	/* Schiffstypen einlesen */

	for (zaehler = 1; zaehler <= grenze; zaehler++)
	{
		SCH_TYP *schiff;

		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		{
			/* printf("error reading ship type %d\n", zaehler); */
			return(FEHLER_R);
		}
		schiff = SH_TYP(zaehler);
		if (sscanf(line, "%d %d %d %d %d",
			&schiff->t_att,
			&schiff->t_def,
			&schiff->t_transp,
			&schiff->t_kosten[0],
			&schiff->t_reichw[0]) != 5)
			return(FEHLER_F);
		for (tl = 1; tl < ANZ_TL; tl++)
		{
			schiff->t_kosten[tl] = schiff->t_kosten[0] - (WORD)((((long)schiff->t_kosten[0] * tl * regel.percent_construction) / 10 + 4) / 10);
			schiff->t_reichw[tl] = schiff->t_reichw[tl-1] + regel.range[tl-1];
		}
		/* printf("ship type %d = %d %d %d %d %d\n", zaehler,
			schiff->t_att, schiff->t_def, schiff->t_transp, schiff->t_kosten[0], schiff->t_reichw[0]);
		*/
	}

	/* Gueterkosten einlesen */

	for (zaehler = 0; zaehler < ANZ_GUETER; zaehler++)
	{
		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		{
			/* printf("error reading good %d\n", zaehler); */
			return(FEHLER_R);
		}
		if (sscanf(line, "%d ", &wert) != 1)
			return(FEHLER_F);
		gcb->kosten_goods[zaehler] = wert;
		/* printf("kosten_goods %d = %d\n", zaehler, gcb->kosten_goods[zaehler]);
		*/
	}

	/* Ladevolumen einlesen */

	for (zaehler = 0; zaehler < ANZ_LADUNG; zaehler++)
	{
		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		{
			/* printf("error reading ladung %d\n", zaehler); */
			return(FEHLER_R);
		}
		if (sscanf(line, "%d ", &wert) != 1)
			return(FEHLER_F);
		gcb->trans_goods[zaehler] = wert;
		/* printf("ladung %d = %d\n", zaehler, gcb->trans_goods[zaehler]);
		*/
	}

	/* Investitionen fuer Tech-Level einlesen */

	for (zaehler = 0; zaehler < ANZ_TL; zaehler++)
	{
		int cost;

		if (fgets(line, BUFFER_GR, gcb_datei) == NULL)
		{
			/* printf("error reading costs %d\n", zaehler); */
			return(FEHLER_R);
		}
		if (sscanf(line, "%d ", &cost) != 1)
			return(FEHLER_F);
		gcb->kosten_tl[zaehler] = cost;
		/* printf("costs %d = %d\n", zaehler, gcb->kosten_tl[zaehler]);
		*/
	}
	/* Datei sollte jetzt zu Ende sein */
	if (fgets(line, BUFFER_GR, gcb_datei) != NULL)
		return(FEHLER_F);
	return(OK);
}


BYTE get_gcb(P(char *) pathname, P(GC_MISC *) gcb)
PP(char *pathname;)
PP(GC_MISC *gcb;)
{
	FILE *gcb_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;

	/* Dateinamen zusammen basteln aus Spielername+Extension */
	sprintf(datei, "%s%s", pathname, EXT_GCB);

	if ((gcb_datei = fopen(datei, FREAD_TEXT)) == NULL)
		return(FEHLER_O);
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_gcb(gcb_datei, gcb);
	f_close(gcb_datei);
	return(fehler);
}




