#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif

static BYTE _get_flb _(( PLAYER *, FILE * ));

/*
 * FLB-Datei einlesen
 */
static BYTE _get_flb(P(PLAYER *) player, P(FILE *) flb_datei)
PP(PLAYER *player;)
PP(FILE *flb_datei;)
{
	long platz;
	UWORD s_zahl, zaehler, lz;
	SCHIFF * ship;
	SCHIFF **schiff;
	UBYTE r_buf[FLB_ST_GR];
	WORD offset;
	
	/* aus der Laenge der Datei die Anzahl der Schiffe berechnen */
    platz = datei_laenge(flb_datei);
    s_zahl = (UWORD) (platz / FLB_ST_GR);
	if (s_zahl > MAX_SCHIFFE)
		return(FEHLER_F);
	schiff = player->pl_ships;
    for (zaehler = 0; zaehler < s_zahl; zaehler++)
    {
		if ((ship = NEW(SCHIFF, "_get_flb")) == NULL)
		{
			return(FEHLER_M);
		}
		schiff[zaehler] = ship;
		
		if (fread(r_buf, FLB_ST_GR, 1, flb_datei) != 1)
    	{
	        return(FEHLER_R);
		}
		
		offset = 0;
		bgetword(ship->s_number);
		bgetword(ship->s_kills);
		bgetword(ship->s_pos);
		bgetword(ship->s_ziel);
		bgetbyte(ship->s_typ);
		bgetbyte(ship->s_atl);
		bgetbyte(ship->s_vtl);
		bgetbyte(ship->s_reichw);
		bgetbyte(ship->s_moved);
		bgetbyte(ship->s_distance);
		bgetbyte(ship->s_tf_nr);
		bgetbyte(ship->s_cur_def);
		bgetbyte(ship->s_cur_transp);
		for (lz = 0; lz < ANZ_LADUNG; lz++)
		{
			bgetbyte(ship->s_ladung[lz]);
		}
	}
    player->pl_num_ships = s_zahl;
	return(OK);
}


BYTE get_flb(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *flb_datei;
	BYTE fehler;
	char datei[MAX_PATHLEN];
	
	sprintf(datei, "%s%s", pathname, EXT_FLB);

	if ((flb_datei = fopen(datei, FREAD_BIN)) == NULL)
	{
		return(FEHLER_O);
	}
	if (verbose)
		fprintf (stderr, "reading %s ...\n", datei);
	fehler = _get_flb(player, flb_datei);
	f_close(flb_datei);
	return(fehler);
}



