#include <stdio.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"


static BYTE _vlb_to_vln _(( PLAYER *, FILE *, FILE * ));
static BYTE _vln_to_vlb _(( PLAYER *, FILE *, FILE * ));
static BYTE _plb_to_pln _(( WORD , FILE *, FILE *, PLAYER * ));
static BYTE _pln_to_plb _(( FILE *, FILE *, PLAYER * ));


/*
 * VLB -> VLN
 */
static BYTE _vlb_to_vln(P(PLAYER *) player, P(FILE *) vlb_datei, P(FILE *) vln_datei)
PP(PLAYER *player;)
PP(FILE *vlb_datei;)
PP(FILE *vln_datei;)
{
	long platz;
	int v_zahl, zaehler=0;
	WORD nachricht, wort2, wort3, wort4;
    PLANET *planet;
    int new_planet;
    WORD platzierung = 0;
    
	/* Die Zahl der Nachrichten berechnen fuer die Schleife */
    platz = datei_laenge(vlb_datei);
    v_zahl =(UWORD) (platz / VLB_ST_GR) ;

	while (zaehler < v_zahl && (nachricht = fgetword(vlb_datei)) != EOF)
	{
		/* Das 2. Wort auch einlesen */
		if ((wort2 = fgetword(vlb_datei)) == EOF ||
			(wort3 = fgetword(vlb_datei)) == EOF ||
			(wort4 = fgetword(vlb_datei)) == EOF)
		{
			return ferror(vlb_datei) ? FEHLER_R : FEHLER_F;
		}
		switch(nachricht)
		{
		case 0:
			fprintf(vln_datei, "0   %4d %4d %4d  Sternzeit = %d\n", wort2, wort3, wort4, wort2);
			break;

		case 1:
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "1   %4d %4d %4d  Festungen auf Planet %d = %d\n", wort2, wort3, wort4, wort2, wort3);
			break;
		
		case 2:	/* Bonus */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "2   %4d %4d %4d  Bonus fuer Planet %d = %d\n", wort2, wort3, wort4, wort2, wort3);
			break;
		
		case 3:
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "3   %4d %4d %4d  Besitzer fuer Planet %d = %d (%s)\n", wort2, wort3, wort4, wort2, wort3, spieler_name(wort3));
			break;

		case 4:
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			planet = find_planet(player, wort2, &new_planet);
			if (planet == NULL)
				return errno;
			fprintf(vln_datei, "4   %4d %4d %4d  Position Planet %d = %d,%d\n", wort2, wort3, wort4, wort2, wort3, wort4);
			break;

		case 5:		/* Eigenes Schiff zerstoert */
			if (wort3 < 1 || wort3 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort4 < 1 || wort4 > gc_global.anz_planeten)
				return(FEHLER_F);
			fprintf(vln_datei, "5   %4d %4d %4d  Schiff %d (Typ %d) bei Planet %d zerstoert\n", wort2, wort3, wort4, wort2, wort3, wort4);
			break;
		
		case 6:		/* Feindliches Schiff zerstoert */
			if (wort2 < 1 || wort2 > gc_global.anz_stypen)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_planeten)
				return(FEHLER_F);
			fprintf(vln_datei, "6   %4d %4d %4d  Feindliches Schiff vom Typ %d bei Planet %d zerstoert\n", wort2, wort3, wort4, wort2, wort3);
			break;
		
		case 7:		/* Angriff auf Planet */
			if (wort2 < 1 || wort2 > gc_global.anz_planeten)
				return(FEHLER_F);
			if (wort3 < 1 || wort3 > gc_global.anz_spieler)
				return(FEHLER_F);
			planet = find_planet(player, wort2, FALSE);
			fprintf(vln_datei, "7   %4d %4d %4d  Angriff auf Planet %d durch %d Schiffe von %s\n", wort2, wort3, wort4, wort2, wort4, spieler_name(wort3));
			break;
		
		case 50:	/* Eigene Platzierung */
			fprintf(vln_datei, "50  %4d %4d %4d  Platz: %d.  Score: %d  Zuwachs: %d\n", wort2, wort3, wort4, wort2, wort3, wort4);
			break;
		
		case 51:	/* Info ueber Top 5 */
			if (wort2 < 1 || wort2 > gc_global.anz_spieler)
				return(FEHLER_F);
			platzierung++;
			fprintf(vln_datei, "51  %4d %4d %4d  Top 5:  %d. %-*s  %d (+%d)\n",
				wort2, wort3, wort4, platzierung, MAX_NAMELG, spieler_name(wort2), wort3, wort4);
			break;
		
		case 52:	/* Anonyme Scoreliste */
			fprintf(vln_datei, "52  %4d %4d %4d  Anonyme Scoreliste: %2d. %u\n", wort2, wort3, wort4, wort2, wort3);
			break;
			
		case 101:
			if (wort2 < 0 || wort2 >= ANZ_FG)
				return(FEHLER_F);
			fprintf(vln_datei, "101 %4d %4d %4d  Techlevel %d = %d, %d PEs\n", wort2, wort3, wort4, wort2, wort4, wort3);
			break;
		
		default:
			fprintf(vln_datei, "%d %4d %4d %4d  (unbekannte Nachricht %d)\n", nachricht, wort2, wort3, wort4, nachricht);
			break;
		}
		if (ferror(vln_datei))
			return(FEHLER_W);
		zaehler++;
	}
	return zaehler == v_zahl ? OK : FEHLER_F;
}


BYTE vlb_to_vln(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *vlb_datei;
	FILE *vln_datei;
    char datei[MAX_PATHLEN];
	BYTE fehler;
	
	sprintf(datei, "%s%s", pathname, EXT_VLB);
	if ((vlb_datei = fopen(datei, FREAD_BIN)) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_VLN);
	if ((vln_datei = fopen(datei, FWRITE_TEXT)) == NULL)
	{
		f_close(vlb_datei);
		return FEHLER_C;
	}
	
	fehler = _vlb_to_vln(player, vlb_datei, vln_datei);
	f_close(vlb_datei);
	f_close(vln_datei);
	return(fehler);
}


/*
 * VLN -> VLB
 */
static BYTE _vln_to_vlb(P(PLAYER *) player, P(FILE *) vln_datei, P(FILE *) vlb_datei)
PP(PLAYER *player;)
PP(FILE *vln_datei;)
PP(FILE *vlb_datei;)
{
	int nachricht, wort2, wort3, wort4;
	STATIC char r_buf[2048];
	char *p;
	
	UNUSED(player);
	while (fgets(r_buf, (int) sizeof(r_buf), vln_datei) != NULL)
	{
		p = r_buf;
		nachricht = (int) sgetint(&p);
		wort2 = (int) sgetint(&p);
		wort3 = (int) sgetint(&p);
		wort4 = (int) sgetint(&p);
		fputword(vlb_datei, nachricht);
		fputword(vlb_datei, wort2);
		fputword(vlb_datei, wort3);
		fputword(vlb_datei, wort4);
	}
	if (ferror(vlb_datei) || fflush(vlb_datei) == EOF)
		return(FEHLER_W);
	return OK;
}


BYTE vln_to_vlb(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *vlb_datei;
	FILE *vln_datei;
    char datei[MAX_PATHLEN];
	BYTE fehler;
	
	sprintf(datei, "%s%s", pathname, EXT_VLN);
	if ((vln_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_VLB);
	if ((vlb_datei = fopen(datei, FWRITE_BIN)) == NULL)
	{
		f_close(vln_datei);
		return FEHLER_C;
	}
	
	fehler = _vln_to_vlb(player, vln_datei, vlb_datei);
	f_close(vln_datei);
	f_close(vlb_datei);
	return(fehler);
}


/*
 * PLB-Datei -> PLN-Datei
 */
static BYTE _plb_to_pln(P(WORD) pl_zahl, P(FILE *) plb_datei,
	P(FILE *) pln_datei, P(PLAYER *) player)
PP(WORD pl_zahl;)
PP(FILE *plb_datei;)
PP(FILE *pln_datei;)
PP(PLAYER *player;)
{
	WORD zaehler, wz, bonus, nummer;
	UBYTE eigner, X, Y, r_buf[PLB_ST_GR], offset;
	PLANET *planet;
	int new_planet;
	
	for (zaehler = 0; zaehler < pl_zahl; zaehler++)
	{
		if (fread(r_buf, PLB_ST_GR, 1, plb_datei) != 1)
		{
			return FEHLER_R;
		}

		offset = 0;
		bgetword(nummer);
		bgetbyte(X);
		bgetbyte(Y);
		bonus = r_buf[59+2];
		/* Eigentlich nur fuer BAS, da in PLB nur bekannte Pl stehen */
		if (X || Y || bonus)
		{
			/* Sucht Pl mit dieser Nr und
				erhoeht gg. die Zahl der bekannten Pl */
			planet = find_planet(player, nummer, &new_planet);
			if (planet == NULL)
				return errno;
			
			bgetbyte(eigner);

			planet->p_pos_x = X;
			planet->p_pos_y = Y;
			planet->p_owner = eigner;
			
			bget_rest_of_planet(planet, r_buf, offset);
			
			if (fprint_planet1(pln_datei, planet))
				return(FEHLER_W);
			if (fprint_planet2(pln_datei, planet))
				return(FEHLER_W);
		}
	}
	return OK;
}


BYTE plb_to_pln(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *plb_datei;
	FILE *pln_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;
	WORD pl_zahl;
	
	/* PLB Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLB);
	if ((plb_datei = fopen(datei, FREAD_BIN)) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_PLN);
	if ((pln_datei = fopen(datei, FWRITE_TEXT)) == NULL)
	{
		f_close(plb_datei);
		return FEHLER_C;
	}
	
	pl_zahl = (WORD)(datei_laenge(plb_datei) / PLB_ST_GR);
	fehler = _plb_to_pln(pl_zahl, plb_datei, pln_datei, player);
	f_close(plb_datei);
	f_close(pln_datei);
	return(fehler);
}


/*
 * PLN-Datei -> PLB-Datei
 */
static BYTE _pln_to_plb(P(FILE *) plb_datei, P(FILE *) pln_datei, P(PLAYER *) player)
PP(FILE *plb_datei;)
PP(FILE *pln_datei;)
PP(PLAYER *player;)
{
	WORD nummer;
	WORD wz;
	STATIC char r_buf[2048];
	PLANET *planet;
	char *p;
	int new_planet;

	while (NULL != fgets(r_buf, (int)sizeof(r_buf), pln_datei))
	{
		p = r_buf;
		nummer = (WORD)sgetint(&p);

		/* Sucht Pl mit dieser Nr und
		   erhoeht gg. die Zahl der bekannten Pl */
		if ((planet = find_planet(player, nummer, &new_planet)) == NULL)
		{
			return errno;
		}
		planet->p_pos_x = (WORD)sgetint(&p);
		planet->p_pos_y = (WORD)sgetint(&p);

		planet->p_owner = (WORD)sgetint(&p);
		planet->p_nat_def = (UBYTE) sgetint(&p);

		planet->p_pe = (WORD)sgetint(&p);

		planet->p_max_minen = (UBYTE) sgetint(&p);
		planet->p_minen = (UBYTE) sgetint(&p);
		planet->p_max_landw = (UBYTE) sgetint(&p);
		planet->p_landw = (UBYTE) sgetint(&p);
		planet->p_max_raffs = (UBYTE) sgetint(&p);
		planet->p_raffs = (UBYTE) sgetint(&p);

		planet->p_fabriken = (WORD)sgetint(&p);
		
		planet->p_ladung[LAD_SPARES] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_MPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_LPE] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_RPE] = (WORD)sgetint(&p);

		planet->p_ladung[LAD_MKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_LKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_RKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_FKITS] = (WORD)sgetint(&p);
		planet->p_ladung[LAD_KOLONIST] = (WORD)sgetint(&p);
		
		planet->p_festungen = (WORD)sgetint(&p);
		planet->p_loyal = (WORD)sgetint(&p);
		planet->p_kampf = (WORD)sgetint(&p);

		planet->p_num_ships = (WORD)sgetint(&p);

		for (wz = 0; wz < MAX_WERFT; wz++)
		{
			planet->p_werft[wz].w_groesse = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe_in_runde = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_pe = (WORD)sgetint(&p);
			planet->p_werft[wz].w_typ = (UBYTE) sgetint(&p);
			planet->p_werft[wz].w_erster = (UBYTE) sgetint(&p);
		}

		planet->p_visited = (WORD)sgetint(&p);
		planet->p_bonus = (WORD)sgetint(&p);
		planet->p_no_use1 = (WORD)sgetint(&p);
		planet->p_no_use2 = (WORD)sgetint(&p);
		
		fputword(plb_datei, planet->p_number);
		fput_planet(plb_datei, planet);
		if (ferror(plb_datei))
			return(FEHLER_W);
	}
	if (ferror(plb_datei) || fflush(plb_datei) == EOF)
		return(FEHLER_W);
	return OK;
}


BYTE pln_to_plb(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *plb_datei;
	FILE *pln_datei;
	char datei[MAX_PATHLEN];
	BYTE fehler;
	
	/* PLN Datei einlesen */
	sprintf(datei, "%s%s", pathname, EXT_PLN);
	if ((pln_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		return FEHLER_O;
	}
	sprintf(datei, "%s%s", pathname, EXT_PLB);
	if ((plb_datei = fopen(datei, FWRITE_BIN)) == NULL)
	{
		f_close(pln_datei);
		return FEHLER_C;
	}
	
	fehler = _pln_to_plb(plb_datei, pln_datei, player);
	f_close(pln_datei);
	f_close(plb_datei);
	return(fehler);
}


