#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <ctype.h>
#include "gcio.h"

#ifndef TRUE
#  define TRUE 1
#  define FALSE 0
#endif

#define MAXCHARS 1024
#define MAXRUNDEN 30

int verbose = TRUE;
int quiet = FALSE;
int debug = 0;
int _stksiz = 8192;

static FILE *FD_out;
static PLAYER *me;

static int Techlevel[MAXRUNDEN + 1];
static int Punkte[MAXRUNDEN + 1];


static int punkte _(( int ));
static void planeten _(( int ));
static int ja_nein _(( char * ));
static void leave _(( int ));
int main _(( int argc, char **argv ));


static int punkte(P(int) n)
PP(int n;)
{
	return ((n > 10000) ? 10 + (n - 10000) / 2000 : n / 1000);
}


static void planeten(P(int) Runden)
PP(int Runden;)
{
	int nr;
	PLANET *planet;
	int bevoelkerung;
	int verteidigungsfaktor;
	int i;
	long x;
	int Wachstum[MAXRUNDEN + 1];

	for (i = 0; i <= Runden; i++)
	{
		Wachstum[i] = 100 + regel.percent_medicine[Techlevel[i]];
		Punkte[i] = 0;
	}

	for (nr = 1; nr <= gc_global.anz_planeten; nr++)
	{
		planet = find_planet(me, nr, NULL);
		if (planet != NULL && planet->p_owner == me->pl_number &&
			position_known(planet))
		{
			bevoelkerung = planet->p_ladung[LAD_KOLONIST];
			verteidigungsfaktor = planet->p_nat_def;

			fprintf(FD_out, "Planet: %3d Verteidigungsfaktor %d\n", nr, verteidigungsfaktor);
			fprintf(FD_out, "Runde TL Bevlkerung  Punkte\n");
			x = bevoelkerung;
			for (i = 0; i <= Runden; i++)
			{
				fprintf(FD_out, "%2d    %d  %5d        %2d (+%2d)\n", i, Techlevel[i], (int) x, punkte((int) x), punkte((int) x) - punkte(bevoelkerung));
				bevoelkerung = (int) x;
				Punkte[i] += punkte(bevoelkerung);
				x = ((long) bevoelkerung * (long) (Wachstum[i] + (10 - verteidigungsfaktor))) / 100L;
				if (x > 30000L)
				{
					x = 30000L;
				}
			}
			fprintf(FD_out, "\n");
		}
	}
}


static int ja_nein(P(char *) str)
PP(char *str;)
{
	int c;
	char buf[MAXCHARS];

	do
	{
		printf(str);
		gets(buf);
		c = buf[0];
		puts("");
	} while (c != 'J' && c != 'j' && c != 'N' && c != 'n');

	return (c == 'J' || c == 'j');
}


static void leave(P(int) status)
PP(int status;)
{
	getchar();
}
	exit(status);



int main(P(int) argc, P(char **) argv)
PP(int argc;)
PP(char **argv;)
{
	int i;
	char str[MAXCHARS];
	char spieler_name[MAX_PATHLEN+1];
	long summe;
	WORD pl_zahl;
	int Runden;

	puts("******************************");
	puts("***     Endspurt (GC)      ***");
	puts("*** (c) 1992 J. Albuschies ***");
	puts("******************************");
	puts("");

	if (argc == 2)
	{
		STRCPY(spieler_name, argv[1]);
	} else {
		if (suche_spielername(spieler_name, EXT_GCB, 1) == 0)
		{
			puts("keine .gcb Datei gefunden");
			leave(1);
		}
	}
	if (get_gcb(spieler_name, &gc_global) != OK)
	{
		puts("Fehler beim Einlesen der gcb-Datei");
		leave(1);
	}
	me = get_player(gc_global.sp_nummer);

	if (get_nas(me, spieler_name, &pl_zahl) != OK)
	{
		if (get_bas(me, spieler_name, &pl_zahl) != OK)
		{
			puts(".nas oder .bas Datei nicht gefunden");
			leave(1);
		}
	}

	do
	{
		printf("Anzahl der Runden: ");
		fflush(stdout);
		gets(str);
		Runden = atoi(str);
	} while (Runden <= 0 || Runden > MAXRUNDEN);
	puts("");

	for (i = 0; i <= Runden; i++)
	{
		do
		{
			printf("Runde %2d: Techlevel Bevlkerung: ", i);
			gets(str);
			Techlevel[i] = atoi(str);
		}
		while (Techlevel[i] < 0 || Techlevel[i] > 9 || !isdigit(*str));

		if (ja_nein("Techlevel bleibt jetzt konstant? (J/N) "))
		{
			while (i < Runden)
			{
				Techlevel[i + 1] = Techlevel[i];
				i++;
			}
		}
	}
	puts("");

	do
	{
		printf("Ausgabedatei: ");
		gets(str);
		if (*str == '\0' && ja_nein("Abbruch? (J/N) "))
		{
			leave(1);
		}
		FD_out = fopen(str, "w");
	} while (FD_out == NULL);
	puts("");

	planeten(Runden);

	fprintf(FD_out, "Runde TL Punkte\n");
	summe = Punkte[0];
	fprintf(FD_out, "%2d:   %d  %5ld %+5d\n", 0, Techlevel[0], summe, 0);
	for (i = 1; i <=void ));
exte
	{
		fprintf(FD_out, "%2d:   %d  %5d %+5d\n", i, Techlevel[i], Punkte[i], Punkte[i] - Punkte[i - 1]);
		summe += Punkte[i];
	}
	fprintf(FD_out, "Summe:   %5ld\n", summe);
	fclose(FD_out);
	for (argc = 1; argc <= gc_global.anz_spieler; argc++)
	{
		me = get_player(argc);
		delete_player(me);
		OFREE(me);
	}
	FREE(gc_global.spieler, gc_global.anz_spieler * sizeof(PLAYER *));
	gc_global.spieler = NULL;
	puts("Programm beendet");
	leave(0);
	return (0);
}


/* EOF */
