#include <stdio.h>
#include <math.h>
#include "gchdr.h"
#include "gcio.h"
#include "editor.h"


#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif


CMD cmd_head = { &cmd_head, &cmd_head };
int cmds_have_changed;
WORD kosten_festung;


static char *ladungs_name _(( int ));
static char *gueter_name _(( int ));
static char *forschungs_name _(( int ));
static int add_geheim _(( PLANET *, WORD, WORD ));
static BYTE _get_bef _(( FILE * ));
static char *skip_space _(( char * ));
static char *skip_to_space _(( char * ));


static char *ladungs_name(P(int) ladung)
PP(int ladung;)
{
	switch (ladung)
	{
		case LAD_SPARES: return("Ersatzteile");
		case LAD_MPE   : return("MPE");
		case LAD_LPE   : return("LPE");
		case LAD_RPE   : return("RPE");
		case LAD_MKITS : return("M-Kits");
		case LAD_LKITS : return("L-Kits");
		case LAD_RKITS : return("R-Kits");
		case LAD_FKITS : return("F-Kits");
		case LAD_KOLONIST: return("Kolonisten");
		default: return("???");
	}
}


static char *gueter_name(P(int) art)
PP(int art;)
{
	switch (art)
	{
		case GUT_FESTUNG: return("Festungen");
		case GUT_MINEN  : return("Minen");
		case GUT_MKITS  : return("M-Kits");
		case GUT_LANDW  : return("Landwirtschaftliche Betriebe");
		case GUT_LKITS  : return("L-Kits");
		case GUT_RAFF   : return("Raffinerien");
		case GUT_RKITS  : return("R-Kits");
		case GUT_FABRIK : return("Fabriken");
		case GUT_FKITS  : return("F-Kits");
		case GUT_WERFT1 : return("Werft 1");
		case GUT_WERFT2 : return("Werft 2");
		case GUT_WERFT3 : return("Werft 3");
		default : return("???");
	}
}


static char *forschungs_name(P(int) fg)
PP(int fg;)
{
	switch (fg)
	{
		case FG_DEFENSE : return("Planetenverteidigung");
		case FG_SPY     : return("Nachrichtentechnik");
		case FG_MEDICINE: return("Medizin");
		case FG_ARMS    : return("Bewaffnung");
		case FG_SHIELDS : return("Schutzschilde");
		case FG_RANGE   : return("Antrieb");
		case FG_CONS    : return("Konstruktion");
		default: return("???");
	}
}


CMD *add_cmd(P(CMD_CODE) code, P(WORD) wort1, P(WORD) wort2, P(WORD) wort3)
PP(CMD_CODE code;)
PP(WORD wort1;)
PP(WORD wort2;)
PP(WORD wort3;)
{
	CMD *cmd;
	
	if ((cmd = NEW(CMD, "add_cmd")) == NULL)
	{
		err_memory();
		return(NULL);
	}
	cmd->cmd_valid = TRUE;
	cmd->cmd_code = code;
	cmd->cmd_vals.words.w1 = wort1;
	cmd->cmd_vals.words.w2 = wort2;
	cmd->cmd_vals.words.w3 = wort3;

	cmd->next = &cmd_head;
	cmd->prev = cmd_head.prev;
	cmd_head.prev->next = cmd;
	cmd_head.prev = cmd;
	cmds_have_changed = TRUE;
	return(cmd);
}


void cmd_string(P(CMD *) cmd, P(char *) command, P(char *) _comment)
PP(CMD *cmd;)
PP(char *command;)
PP(char *_comment;)
{
	switch (cmd->cmd_code)
	{
	case CMD_NONE:
		break;
	case CMD_MOVE_SHIP:
		sprintf(command, "B S %d %d",
			cmd->cmd_vals.move_ship.ship,
			cmd->cmd_vals.move_ship.planet);
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.move_ship.ship, FALSE);
			sprintf(_comment, "Bewege Schiff %d (Typ %d) nach %d",
				cmd->cmd_vals.move_ship.ship,
				s ? s->s_typ : 0,
				cmd->cmd_vals.move_ship.planet);
		}
		break;
	case CMD_MOVE_TF:
		sprintf(command, "B T %d %d",
			cmd->cmd_vals.move_tf.tf,
			cmd->cmd_vals.move_tf.planet);
		sprintf(_comment, "Bewege Task-Force %d nach %d",
			cmd->cmd_vals.move_tf.tf,
			cmd->cmd_vals.move_tf.planet);
		break;
	case CMD_LOAD_SHIP:
		sprintf(command, "%c S %d %d %d",
			cmd->cmd_vals.load_ship.anz > 0 ? 'L' : 'E',
			cmd->cmd_vals.load_ship.ship,
			cmd->cmd_vals.load_ship.lad+1,
			abs(cmd->cmd_vals.load_ship.anz));
		sprintf(_comment, "%slade Schiff %d mit %d %s",
			cmd->cmd_vals.load_ship.anz > 0 ? "Be" : "Ent",
			cmd->cmd_vals.load_ship.ship,
			abs(cmd->cmd_vals.load_ship.anz) * gc_global.trans_goods[cmd->cmd_vals.load_ship.lad],
			ladungs_name(cmd->cmd_vals.load_ship.lad));
		break;
	case CMD_LOAD_TF:
		sprintf(command, "%c T %d %d %d",
			cmd->cmd_vals.load_ship.anz > 0 ? 'L' : 'E',
			cmd->cmd_vals.load_tf.tf,
			cmd->cmd_vals.load_tf.lad+1,
			abs(cmd->cmd_vals.load_tf.anz));
		sprintf(_comment, "%slade Task-Force %d mit %d %s",
			cmd->cmd_vals.load_ship.anz > 0 ? "Be" : "Ent",
			cmd->cmd_vals.load_tf.tf,
			abs(cmd->cmd_vals.load_tf.anz) * gc_global.trans_goods[cmd->cmd_vals.load_tf.lad],
			ladungs_name(cmd->cmd_vals.load_tf.lad));
		break;
	case CMD_SCHROTT:
		sprintf(command, "V %d",
			cmd->cmd_vals.schrott.ship);
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.schrott.ship, FALSE);
			sprintf(_comment, "Verschrotte Schiff %d (Typ %d)",
				cmd->cmd_vals.schrott.ship,
				s ? s->s_typ : 0);
		}
		break;
	case CMD_TASKFORCE:
		sprintf(command, "Z %d %d",
			cmd->cmd_vals.taskforce.ship,
			cmd->cmd_vals.taskforce.tf);
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.taskforce.ship, FALSE);
			sprintf(_comment, "Ordne Schiff %d (Typ %d) Task-Force %d zu",
				cmd->cmd_vals.taskforce.ship,
				s ? s->s_typ : 0,
				cmd->cmd_vals.taskforce.tf);
		}
		break;
	case CMD_CHOWN:
		sprintf(command, "U %d %d",
			cmd->cmd_vals.chown.ship,
			cmd->cmd_vals.chown.player);
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.chown.ship, FALSE);
			sprintf(_comment, "Uebereigne Schiff %d (Typ %d) an %s",
				cmd->cmd_vals.chown.ship,
				s ? s->s_typ : 0,
				spieler_name(cmd->cmd_vals.chown.player));
		}
		break;
	case CMD_WERFT:
		sprintf(command, "W %d %d %d",
			cmd->cmd_vals.werft.pl,
			cmd->cmd_vals.werft.wft+1,
			cmd->cmd_vals.werft.typ);
		sprintf(_comment, "Produziere auf Planet %d in Werft %d Schiff %d",
			cmd->cmd_vals.werft.pl,
			cmd->cmd_vals.werft.wft+1,
			cmd->cmd_vals.werft.typ);
		break;
	case CMD_CONS_SHIP:
		sprintf(command, "S %d %d %d",
			cmd->cmd_vals.cons_ship.pl,
			cmd->cmd_vals.cons_ship.wft+1,
			cmd->cmd_vals.cons_ship.pe);
		sprintf(_comment, "Investiere auf Planet %d in Werft %d %d PE",
			cmd->cmd_vals.cons_ship.pl,
			cmd->cmd_vals.cons_ship.wft+1,
			cmd->cmd_vals.cons_ship.pe);
		break;
	case CMD_PRODUCE:
		sprintf(command, "P %d %d %d",
			cmd->cmd_vals.produce.pl,
			cmd->cmd_vals.produce.kind+1,
			cmd->cmd_vals.produce.anz);
		sprintf(_comment, "Investiere auf Planet %d %d PE in Produktion von %s",
			cmd->cmd_vals.produce.pl,
			cmd->cmd_vals.produce.anz,
			gueter_name(cmd->cmd_vals.produce.kind));
		break;
	case CMD_INSTALL:
		sprintf(command, "N %d %d %d",
			cmd->cmd_vals.install.pl,
			cmd->cmd_vals.install.kind+1,
			cmd->cmd_vals.install.anz);
		sprintf(_comment, "Installiere auf Planet %d %d %s",
			cmd->cmd_vals.install.pl,
			cmd->cmd_vals.install.anz,
			ladungs_name(cmd->cmd_vals.install.kind));
		break;
	case CMD_SPY:
		sprintf(command, "I %d %d %d",
			cmd->cmd_vals.spy.target,
			cmd->cmd_vals.spy.pe,
			cmd->cmd_vals.spy.planet);
		sprintf(_comment, "Spioniere auf Planet %d mit %d PE von Planet %d",
			cmd->cmd_vals.spy.target,
			cmd->cmd_vals.spy.pe,
			cmd->cmd_vals.spy.planet);
		break;
	case CMD_CORRUPT:
		sprintf(command, "K %d %d %d",
			cmd->cmd_vals.corrupt.target,
			cmd->cmd_vals.corrupt.pe,
			cmd->cmd_vals.corrupt.planet);
		sprintf(_comment, "Korrumpiere auf Planet %d mit %d PE von Planet %d",
			cmd->cmd_vals.corrupt.target,
			cmd->cmd_vals.corrupt.pe,
			cmd->cmd_vals.corrupt.planet);
		break;
	case CMD_FORSCH:
		sprintf(command, "F %d %d %d",
			cmd->cmd_vals.forsch.pl,
			cmd->cmd_vals.forsch.pe,
			cmd->cmd_vals.forsch.kind);
		sprintf(_comment, "Investiere auf Planet %d %d PE in %s",
			cmd->cmd_vals.forsch.pl,
			cmd->cmd_vals.forsch.pe,
			forschungs_name(cmd->cmd_vals.forsch.kind));
		break;
	case CMD_KOPFGELD:
		sprintf(command, "G %d %d",
			cmd->cmd_vals.kopfgeld.pe,
			cmd->cmd_vals.kopfgeld.player);
		sprintf(_comment, "Setze Kopfgeld von %d auf %s",
			cmd->cmd_vals.kopfgeld.pe,
			spieler_name(cmd->cmd_vals.kopfgeld.player));
		break;
	}
}


static int add_geheim(P(PLANET *) planet, P(WORD) target, P(WORD) pe)
PP(PLANET *planet;)
PP(WORD target;)
PP(WORD pe;)
{
	WORD i;
	MAD *m;
	
	for (i = 0; i < MAX_GEHEIM; i++)
	{
		m = &planet->p_geheim[i];
		if (m->m_pe == 0 ||
			(m->m_target == target &&
			 ((pe < 0 && m->m_pe < 0) || (pe > 0 && m->m_pe > 0))))
			break;
	}
	if (i == MAX_GEHEIM)
		return(FALSE);
	m->m_target = target;
	m->m_pe += pe;
	return(TRUE);
}


WORD calc_techlevel(P(WORD) pes)
PP(WORD pes;)
{
	WORD level;
	
	for (level = ANZ_TL-1; level >= 0 && gc_global.kosten_tl[level] > pes; level--)
		;
	return(level);
}


WORD count_ladung(P(SCHIFF *) s)
PP(SCHIFF *s;)
{
	WORD gesamt;
	WORD i;
	
	gesamt = 0;
	for (i = 0; i < ANZ_LADUNG; i++)
		gesamt += s->s_new_ladung[i];
	return(gesamt);
}


void do_cmd(P(CMD *) cmd)
PP(CMD *cmd;)
{
	if (cmd == NULL)
		return;
	
	switch (cmd->cmd_code)
	{
	case CMD_NONE:
		break;
	case CMD_MOVE_SHIP:
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.move_ship.ship, FALSE);
			if (s != NULL)
			{
				/* s->s_new_pos = 0; */
				s->s_new_ziel = cmd->cmd_vals.move_ship.planet;
			} else {
				cmd->cmd_valid = FALSE;
			}
		}
		break;
		
	case CMD_MOVE_TF:
		{
			SCHIFF **schiffe;
			SCHIFF *s;
			WORD i;
			WORD tf_nr;
			WORD dest;
			
			tf_nr = cmd->cmd_vals.move_tf.tf;
			dest = cmd->cmd_vals.move_tf.planet;
			schiffe = me->pl_ships;
			for (i = 0; i < me->pl_num_ships; i++)
			{
				s = schiffe[i];
				if (s->s_new_tf_nr == tf_nr)
				{
					if (!(s->s_schrott) && s->s_new_ziel == 0 &&
						s->s_new_pos != dest && s->s_pos != dest && s->s_pos != 0)
					{
						/* s->s_new_pos = 0; */
						s->s_new_ziel = dest;
					}
				}
			}
		}
		break;
	
	case CMD_LOAD_SHIP:
		{
			SCHIFF *s;
			PLANET *planet;
			WORD diff, ladung;
			
			diff = cmd->cmd_vals.load_ship.anz;
			ladung = cmd->cmd_vals.load_ship.lad;
			s = find_ship(me, cmd->cmd_vals.load_ship.ship, FALSE);
			if (s != NULL)
			{
				planet = find_planet(me, s->s_pos, NULL);
				if (planet)
				{
					s->s_new_ladung[ladung] += diff;
					planet->p_new_ladung[ladung] -= gc_global.trans_goods[ladung] * diff;
				}
			}
		}
		break;
		
	case CMD_LOAD_TF:
		{
			SCHIFF *s;
			PLANET *planet;
			WORD diff, ladung, tf;
			SCHIFF **schiffe;
			WORD i;
			WORD this_diff;
			
			diff = cmd->cmd_vals.load_tf.anz;
			ladung = cmd->cmd_vals.load_tf.lad;
			tf = cmd->cmd_vals.load_tf.tf;
			schiffe = me->pl_ships;
			for (i = 0; i < me->pl_num_ships && diff != 0; i++)
			{
				s = schiffe[i];
				if (s->s_new_tf_nr == tf)
				{
					planet = find_planet(me, s->s_pos, NULL);
					if (planet)
					{
						if (diff > 0)
						{
							this_diff = SH_TYP(s->s_typ)->t_transp - count_ladung(s);
							if (this_diff > diff)
								this_diff = diff;
						} else {
							this_diff = -(s->s_new_ladung[ladung]);
							if (this_diff < diff)
								this_diff = diff;
						}
						s->s_new_ladung[ladung] += this_diff;
						planet->p_new_ladung[ladung] -= gc_global.trans_goods[ladung] * this_diff;
						diff -= this_diff;
					}
				}
			}
			if (diff != 0)
			{
				/* that did not work */
			}
		}
		break;
		
	case CMD_SCHROTT:
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.schrott.ship, FALSE);
			if (s != NULL)
			{
				s->s_schrott = 1;
			} else {
				cmd->cmd_valid = FALSE;
			}
		}
		break;
		
	case CMD_TASKFORCE:
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.taskforce.ship, FALSE);
			if (s != NULL)
			{
				s->s_new_tf_nr = cmd->cmd_vals.taskforce.tf;
			} else {
				cmd->cmd_valid = FALSE;
			}
		}
		break;
		
	case CMD_CHOWN:
		{
			SCHIFF *s;
			
			s = find_ship(me, cmd->cmd_vals.chown.ship, FALSE);
			if (s != NULL)
			{
				s->s_new_owner = cmd->cmd_vals.chown.player;
			} else {
				cmd->cmd_valid = FALSE;
			}
		}
		break;
	
	case CMD_WERFT:
		{
			PLANET *planet;
			WFT *wft;
			WORD wz;
			
			planet = find_planet(me, cmd->cmd_vals.werft.pl, NULL);
			if (planet != NULL)
			{
				wz = cmd->cmd_vals.werft.wft;
				wft = &planet->p_new_werft[wz];
				wft->w_typ = cmd->cmd_vals.werft.typ;
				if (planet->p_werft[wz].w_erster ||
					cmd->cmd_vals.werft.typ != planet->p_werft[wz].w_typ)
				{
					wft->w_erster = TRUE;
				} else {
					wft->w_erster = FALSE;
				}
				if (cmd->cmd_vals.werft.typ != planet->p_werft[wz].w_typ)
				{
					wft->w_pe = 0;
				} else {
					wft->w_pe = planet->p_werft[wz].w_pe;
				}
			}
		}
		break;
	
	case CMD_CONS_SHIP:
		{
			PLANET *planet;
			WFT *wft;
			
			planet = find_planet(me, cmd->cmd_vals.cons_ship.pl, NULL);
			if (planet != NULL)
			{
				wft = &planet->p_new_werft[cmd->cmd_vals.cons_ship.wft];
				wft->w_pe_in_runde += cmd->cmd_vals.cons_ship.pe;
				planet->p_new_pe -= cmd->cmd_vals.cons_ship.pe;
			}
		}
		break;
		
	case CMD_SPY:
		{
			PLANET *planet;
			
			planet = find_planet(me, cmd->cmd_vals.spy.planet, NULL);
			if (planet != NULL)
			{
				if (add_geheim(planet, cmd->cmd_vals.spy.target, cmd->cmd_vals.spy.pe) != FALSE)
					planet->p_new_pe -= cmd->cmd_vals.spy.pe;
			}
		}
		break;
	
	case CMD_CORRUPT:
		{
			PLANET *planet;
			
			planet = find_planet(me, cmd->cmd_vals.corrupt.planet, NULL);
			if (planet != NULL)
			{
				if (add_geheim(planet, cmd->cmd_vals.corrupt.target, -cmd->cmd_vals.corrupt.pe) != FALSE)
					planet->p_new_pe -= cmd->cmd_vals.corrupt.pe;
			}
		}
		break;
		
	case CMD_FORSCH:
		{
			PLANET *planet;
			WORD diff;
			WORD kind;
			
			planet = find_planet(me, cmd->cmd_vals.forsch.pl, NULL);
			if (planet != NULL)
			{
				diff = cmd->cmd_vals.forsch.pe;
				kind = cmd->cmd_vals.forsch.kind;
				planet->p_forschen[kind] += diff;
				me->pl_tech_level_newpes[kind] += diff;
				planet->p_new_pe -= diff;
				me->pl_tech_level_new[kind] = calc_techlevel(me->pl_tech_level_newpes[kind]);
			}
		}
		break;
		
	case CMD_PRODUCE:
		{
			PLANET *planet;
			WORD diff, kind;
			
			planet = find_planet(me, cmd->cmd_vals.produce.pl, NULL);
			if (planet != NULL)
			{
				diff = cmd->cmd_vals.produce.anz;
				kind = cmd->cmd_vals.produce.kind;
				switch (kind)
				{
				case GUT_FESTUNG:
					planet->p_new_festungen += diff;
					if (kosten_festung == 0)
						planet->p_new_pe -= diff * (gc_global.kosten_goods[GUT_FESTUNG] - me->pl_tech_level_new[FG_DEFENSE]);
					else
						planet->p_new_pe -= diff * kosten_festung;
					break;
				case GUT_MINEN:
					planet->p_new_minen += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_MINEN];
					break;
				case GUT_MKITS:
					planet->p_new_ladung[LAD_MKITS] += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_MKITS];
					break;
				case GUT_LANDW:
					planet->p_new_landw += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_LANDW];
					break;
				case GUT_LKITS:
					planet->p_new_ladung[LAD_LKITS] += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_LKITS];
					break;
				case GUT_RAFF:
					planet->p_new_raffs += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_RAFF];
					break;
				case GUT_RKITS:
					planet->p_new_ladung[LAD_RKITS] += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_RKITS];
					break;
				case GUT_FABRIK:
					planet->p_new_fabriken += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_FABRIK];
					break;
				case GUT_FKITS:
					planet->p_new_ladung[LAD_FKITS] += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_FKITS];
					break;
				case GUT_WERFT1:
					planet->p_new_werft[0].w_groesse += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_WERFT1];
					break;
				case GUT_WERFT2:
					planet->p_new_werft[1].w_groesse += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_WERFT2];
					break;
				case GUT_WERFT3:
					planet->p_new_werft[2].w_groesse += diff;
					planet->p_new_pe -= diff * gc_global.kosten_goods[GUT_WERFT3];
					break;
				}
			}
		}
		break;
	
	case CMD_INSTALL:
		{
			PLANET *planet;
			WORD diff, kind;
			
			planet = find_planet(me, cmd->cmd_vals.install.pl, NULL);
			if (planet != NULL)
			{
				diff = cmd->cmd_vals.install.anz;
				kind = cmd->cmd_vals.install.kind;
				switch (kind)
				{
				case LAD_MKITS:
					planet->p_inst_mkits += diff;
					break;
				case LAD_LKITS:
					planet->p_inst_lkits += diff;
					break;
				case LAD_RKITS:
					planet->p_inst_rkits += diff;
					break;
				case LAD_FKITS:
					planet->p_inst_fkits += diff;
					break;
				}
			}
		}
		break;
	
	case CMD_KOPFGELD:
		me->pl_kg_pes = cmd->cmd_vals.kopfgeld.pe;
		me->pl_kg_player = cmd->cmd_vals.kopfgeld.player;
		break;
	}
}


long cmd_count(P(void))
{
	long count = 0;
	CMD *cmd;
	
	FOR_ALL_CMDS(cmd)
	{
		count++;
	}
	return(count);
}


BYTE write_bef(P(PLAYER *) player, P(char *) pathname, P(char *) editor_name)
PP(PLAYER *player;)
PP(char *pathname;)
PP(char *editor_name;)
{
	CMD *cmd;
	char datei[MAX_PATHLEN];
	FILE *bef_datei;
	char command[80];
	char _comment[80];
	
	if (CMD_LIST_EMPTY() || cmds_have_changed == FALSE)
		return OK;
	recalc_bef(player);
	sprintf(datei, "%s%s", pathname, EXT_BEF);
	if (!player->pl_bef_file_renamed)
	{
		char save_name[MAX_PATHLEN], *p;
		
		strcpy(save_name, datei);
		p = strrchr(save_name, '\\');
		if (p == NULL)
			p = strrchr(save_name, '/');
		if (p == NULL)
			p = save_name;
		else
			++p;
		sprintf(p, "old_befs%s", EXT_BEF);
		(void) unlink(save_name);
		rename(datei, save_name);
		player->pl_bef_file_renamed = TRUE;
	}
	
	bef_datei = fopen(datei, "w");
	if (bef_datei == NULL)
		return(FEHLER_C);
	fprintf(bef_datei, "#BEF %s %u %u %s\n", gc_global.gc_id, player->pl_number, gc_global.starDate, editor_name);
	FOR_ALL_CMDS(cmd)
	{
		if (cmd->cmd_valid)
		{
			cmd_string(cmd, command, _comment);
			fprintf(bef_datei, "%s\n", command);
			if (ferror(bef_datei))
				break;
		}
	}
	
	fprintf(bef_datei, "#END\n");
	if (ferror(bef_datei) || fflush(bef_datei) == EOF)
	{
		f_close(bef_datei);
		return(FEHLER_W);
	}
	f_close(bef_datei);
	cmds_have_changed = FALSE;
	return(OK);
}


WORD gesamt_rest(P(PLAYER *) player)
PP(PLAYER *player;)
{
	WORD pes;
	WORD i;
	PLANET **planets;
	PLANET *planet;
	
	planets = player->pl_planets;
	pes = 0;
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		if (planet && planet->p_owner == player->pl_number)
			pes += planet->p_new_pe;
	}
	return(pes);
}


WORD koord_distance(P(WORD) x1, P(WORD) y1, P(WORD) x2, P(WORD) y2)
PP(WORD x1;)
PP(WORD y1;)
PP(WORD x2;)
PP(WORD y2;)
{
	long distance_x, distance_y;
	
	distance_x = (long)(x1 - x2);
	if (distance_x < 0)
		distance_x = -distance_x;
	if (distance_x > (gc_global.maxMapSize / 2))
		distance_x = gc_global.maxMapSize - distance_x;
	distance_x *= distance_x;
	distance_y = (long)(y1 - y2);
	if (distance_y < 0)
		distance_y = -distance_y;
	if (distance_y > (gc_global.maxMapSize / 2))
		distance_y = gc_global.maxMapSize - distance_y;
	distance_y *= distance_y;
	return((WORD)(sqrt((double)(distance_x + distance_y)) + 0.5));
}


WORD planet_distance(P(PLANET *) p1, P(PLANET *) p2)
PP(PLANET *p1;)
PP(PLANET *p2;)
{
	if (p1 != NULL && p2 != NULL &&
		position_known(p1) && position_known(p2))
	{
		return(koord_distance(p1->p_pos_x, p1->p_pos_y, p2->p_pos_x, p2->p_pos_y));
	}
	return(-1);
}


CMD *cmd_move_ship(P(SCHIFF *) s, P(WORD) dest)
PP(SCHIFF *s;)
PP(WORD dest;)
{
	CMD *cmd = NULL;
	
	if (!(s->s_schrott) && s->s_new_ziel == 0 &&
		s->s_new_pos != dest && s->s_pos != dest && s->s_pos != 0)
	{
		cmd = add_cmd(CMD_MOVE_SHIP, s->s_number, dest, 0);
		do_cmd(cmd);
		ship_changed(me, s);
		cmds_changed();
	}
	return(cmd);
}


CMD *cmd_move_taskforce(P(WORD) tf_nr, P(WORD) dest)
PP(WORD tf_nr;)
PP(WORD dest;)
{
	SCHIFF **schiffe;
	SCHIFF *s;
	WORD i;
	CMD *cmd = NULL;
	int moved_any;
	
	schiffe = me->pl_ships;
	moved_any = FALSE;
	for (i = 0; i < me->pl_num_ships && moved_any == FALSE; i++)
	{
		s = schiffe[i];
		if (s->s_new_tf_nr == tf_nr)
		{
			if (!(s->s_schrott) && s->s_new_ziel == 0 &&
				s->s_new_pos != dest && s->s_pos != dest && s->s_pos != 0)
			{
				moved_any = TRUE;
			}
		}
	}
	if (moved_any)
	{
		cmd = add_cmd(CMD_MOVE_TF, tf_nr, dest, 0);
		do_cmd(cmd);
		cmds_changed();
		for (i = 0; i < me->pl_num_ships && moved_any == FALSE; i++)
		{
			s = schiffe[i];
			if (s->s_new_tf_nr == tf_nr)
			{
				if (!(s->s_schrott) && s->s_new_ziel == 0 &&
					s->s_new_pos != dest && s->s_pos != dest && s->s_pos != 0)
				{
					ship_changed(me, s);
				}
			}
		}
	}
	return(cmd);
}


CMD *cmd_chown(P(SCHIFF *) s, P(WORD) pl_number)
PP(SCHIFF *s;)
PP(WORD pl_number;)
{
	CMD *cmd = NULL;
	
	if (pl_number != me->pl_number)
	{
		cmd = add_cmd(CMD_CHOWN, s->s_number, pl_number, 0);
		do_cmd(cmd);
		cmds_changed();
		ship_changed(me, s);
	}
	return(cmd);
}


CMD *cmd_change_taskforce(P(SCHIFF *) s, P(WORD) new_tf_nr)
PP(SCHIFF *s;)
PP(WORD new_tf_nr;)
{
	CMD *cmd = NULL;
	
	cmd = add_cmd(CMD_TASKFORCE, s->s_number, new_tf_nr, 0);
	do_cmd(cmd);
	cmds_changed();
	ship_changed(me, s);
	return(cmd);
}


CMD *cmd_spy(P(WORD) target, P(WORD) pes, P(PLANET *) planet)
PP(WORD target;)
PP(WORD pes;)
PP(PLANET *planet;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_SPY, target, pes, planet->p_number);
	do_cmd(cmd);
	cmds_changed();
	planet_changed(me, planet);
	return(cmd);
}


CMD *cmd_corrupt(P(WORD) target, P(WORD) pes, P(PLANET *) planet)
PP(WORD target;)
PP(WORD pes;)
PP(PLANET *planet;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_CORRUPT, target, pes, planet->p_number);
	do_cmd(cmd);
	cmds_changed();
	planet_changed(me, planet);
	return(cmd);
}


CMD *cmd_kopfgeld(P(WORD) pes, P(WORD) pl_number)
PP(WORD pes;)
PP(WORD pl_number;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_KOPFGELD, pes, pl_number, 0);
	do_cmd(cmd);
	cmds_changed();
	return(cmd);
}


CMD *cmd_schrott(P(SCHIFF *) s)
PP(SCHIFF *s;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_SCHROTT, s->s_number, 0, 0);
	do_cmd(cmd);
	cmds_changed();
	ship_changed(me, s);
	return(cmd);
}


/*
 * PE in Forschungsgebiet stecken.
 * Differenz kann positiv oder negativ sein
 */
CMD *cmd_forsch(P(PLANET *) planet, P(WORD) diff, P(WORD) gebiet)
PP(PLANET *planet;)
PP(WORD diff;)
PP(WORD gebiet;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_FORSCH, planet->p_number, diff, gebiet);
	do_cmd(cmd);
	cmds_changed();
	planet_changed(me, planet);
	return(cmd);
}


/*
 * Kits installieren.
 * Differenz kann positiv oder negativ sein
 */
CMD *cmd_install(P(PLANET *) planet, P(WORD) kind, P(WORD) diff)
PP(PLANET *planet;)
PP(WORD kind;)
PP(WORD diff;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_INSTALL, planet->p_number, kind, diff);
	do_cmd(cmd);
	cmds_changed();
	planet_changed(me, planet);
	return(cmd);
}


/*
 * Gueter produzieren.
 * Differenz kann positiv oder negativ sein
 */
CMD *cmd_produce(P(PLANET *) planet, P(WORD) kind, P(WORD) diff)
PP(PLANET *planet;)
PP(WORD kind;)
PP(WORD diff;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_PRODUCE, planet->p_number, kind, diff);
	do_cmd(cmd);
	cmds_changed();
	planet_changed(me, planet);
	return(cmd);
}


/*
 * Werften umbauen.
 */
CMD *cmd_werft(P(PLANET *) planet, P(WORD) no, P(WORD) typ)
PP(PLANET *planet;)
PP(WORD no;)
PP(WORD typ;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_WERFT, planet->p_number, no, typ);
	do_cmd(cmd);
	cmds_changed();
	planet_changed(me, planet);
	return(cmd);
}


/*
 * Schiffe bauen.
 */
CMD *cmd_cons_ship(P(PLANET *) planet, P(WORD) no, P(WORD) pe)
PP(PLANET *planet;)
PP(WORD no;)
PP(WORD pe;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_CONS_SHIP, planet->p_number, no, pe);
	do_cmd(cmd);
	cmds_changed();
	planet_changed(me, planet);
	return(cmd);
}


/*
 * Schiff Be-/Entladen
 * Differenz positiv: beladen
 * Differenz negativ: entladen
 */
CMD *cmd_load_ship(P(SCHIFF *) s, P(WORD) diff, P(WORD) ladung)
PP(SCHIFF *s;)
PP(WORD diff;)
PP(WORD ladung;)
{
	CMD *cmd;
	
	cmd = add_cmd(CMD_LOAD_SHIP, s->s_number, ladung, diff);
	do_cmd(cmd);
	cmds_changed();
	ship_changed(me, s);
	return(cmd);
}


/*
 * Taskforce Be-/Entladen
 * Differenz positiv: beladen
 * Differenz negativ: entladen
 */
CMD *cmd_load_taskforce(P(WORD) tf_nr, P(WORD) diff, P(WORD) ladung)
PP(WORD tf_nr;)
PP(WORD diff;)
PP(WORD ladung;)
{
	SCHIFF **schiffe;
	SCHIFF *s;
	WORD i;
	CMD *cmd = NULL;
	int did_any;
	
	schiffe = me->pl_ships;
	did_any = FALSE;
	for (i = 0; i < me->pl_num_ships && did_any == FALSE; i++)
	{
		s = schiffe[i];
		if (s->s_new_tf_nr == tf_nr)
		{
			did_any = TRUE;
		}
	}
	if (did_any)
	{
		cmd = add_cmd(CMD_LOAD_TF, tf_nr, diff, ladung);
		do_cmd(cmd);
		cmds_changed();
		for (i = 0; i < me->pl_num_ships; i++)
		{
			s = schiffe[i];
			if (s->s_new_tf_nr == tf_nr)
			{
				ship_changed(me, s);
			}
		}
	}
	return(cmd);
}


static char *skip_space(P(char *) p)
PP(char *p;)
{
	while (*p == ' ' || *p == '\t')
		p++;
	return(p);
}


static char *skip_to_space(P(char *) p)
PP(char *p;)
{
	while (*p != '\0' && *p != ' ' && *p != '\t')
		p++;
	return(p);
}


FILE *bef_exists(P(char *) pathname, P(char *) gc_id,
	P(WORD *) pl_number, P(WORD *) starDate)
PP(char *pathname;)
PP(char *gc_id;)
PP(WORD *pl_number;)
PP(WORD *starDate;)
{
	char datei[MAX_PATHLEN];
	FILE *bef_datei;
	STATIC char r_buf[2048];
	char *p, *p2;
	
	sprintf(datei, "%s%s", pathname, EXT_BEF);
	if ((bef_datei = fopen(datei, "r")) != NULL)
	{
		if (fgets(r_buf, (int)sizeof(r_buf), bef_datei) == NULL)
		{
			f_close(bef_datei);
			return(NULL);
		}
		p = r_buf;
		if (strncmp(p, "#BEF", 4) != 0 && strncmp(p, "#bef", 4) != 0)
		{
			f_close(bef_datei);
			return(NULL);
		}
		p = skip_space(skip_to_space(p+4));
		if (*p == '\0')
		{
			f_close(bef_datei);
			return(NULL);
		}
		p2 = skip_to_space(p);
		if (*p2 == '\0')
		{
			f_close(bef_datei);
			return(NULL);
		}
		*p2++ = '\0';
		strncpy(gc_id, p, MAX_NAMELG);
		p = skip_space(p2);
		*pl_number = atoi(p);
		p = skip_space(skip_to_space(p));
		if (*p == '\0')
		{
			f_close(bef_datei);
			return(NULL);
		}
		*starDate = atoi(p);
		return(bef_datei);
	}
	return(NULL);
}


static BYTE _get_bef(P(FILE *) bef_datei)
PP(FILE *bef_datei;)
{
	STATIC char r_buf[2048];
	char *p, *p1, *p2, *p3;
	WORD diff;
	CMD *cmd;
	
	while (fgets(r_buf, (int)sizeof(r_buf), bef_datei) != NULL)
	{
		p = skip_space(r_buf);
		if (*p == '\0')
			continue;
		if (strncmp(p, "#end", 4) == 0 || strncmp(p, "#END", 4) == 0)
			break;
		cmd = NULL;
		switch (*p)
		{
		case 'b': /* Schiff/Taskforce bewegen */
		case 'B':
			p = skip_space(skip_to_space(p));
			switch (*p)
			{
			case 's':
			case 'S':
				p1 = skip_space(skip_to_space(p));
				p2 = skip_space(skip_to_space(p1));
				if (*p1 == '\0' || *p2 == '\0') return(FEHLER_F);
				cmd = add_cmd(CMD_MOVE_SHIP, atoi(p1), atoi(p2), 0);
				break;
			case 't':
			case 'T':
				p1 = skip_space(skip_to_space(p));
				p2 = skip_space(skip_to_space(p1));
				if (*p1 == '\0' || *p2 == '\0') return(FEHLER_F);
				cmd = add_cmd(CMD_MOVE_TF, atoi(p1), atoi(p2), 0);
				break;
			default:
				return(FEHLER_F);
			}
			break;
		
		case 'l': /* Schiff/Taskforce beladen */
		case 'L':
		case 'e': /* Schiff/Taskforce entladen */
		case 'E':
			if (*p == 'e' || *p == 'E')
				diff = -1;
			else
				diff = 1;
			p = skip_space(skip_to_space(p));
			switch (*p)
			{
			case 's':
			case 'S':
				p1 = skip_space(skip_to_space(p));
				p2 = skip_space(skip_to_space(p1));
				p3 = skip_space(skip_to_space(p2));
				if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
				diff *= atoi(p3);
				cmd = add_cmd(CMD_LOAD_SHIP, atoi(p1), atoi(p2)-1, diff);
				break;
			case 't':
			case 'T':
				p1 = skip_space(skip_to_space(p));
				p2 = skip_space(skip_to_space(p1));
				p3 = skip_space(skip_to_space(p2));
				if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
				diff *= atoi(p3);
				cmd = add_cmd(CMD_LOAD_TF, atoi(p1), atoi(p2)-1, diff);
				break;
			default:
				return(FEHLER_F);
			}
			break;
		
		case 'v': /* Schiff verschrotten */
		case 'V':
			p1 = skip_space(skip_to_space(p));
			if (*p1 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_SCHROTT, atoi(p1), 0, 0);
			break;
		
		case 'z': /* Schiff Taskforce zuordnen */
		case 'Z':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			if (*p1 == '\0' || *p2 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_TASKFORCE, atoi(p1), atoi(p2), 0);
			break;
		
		case 'u': /* Schiff uebereignen */
		case 'U':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			if (*p1 == '\0' || *p2 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_CHOWN, atoi(p1), atoi(p2), 0);
			break;
		
		case 'w': /* Werftproduktion */
		case 'W':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			p3 = skip_space(skip_to_space(p2));
			if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_WERFT, atoi(p1), atoi(p2)-1, atoi(p3));
			break;
		
		case 's': /* Schiffbau */
		case 'S':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			p3 = skip_space(skip_to_space(p2));
			if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_CONS_SHIP, atoi(p1), atoi(p2)-1, atoi(p3));
			break;
		
		case 'p': /* Produktion */
		case 'P':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			p3 = skip_space(skip_to_space(p2));
			if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_PRODUCE, atoi(p1), atoi(p2)-1, atoi(p3));
			break;
		
		case 'n': /* Kits Installieren */
		case 'N':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			p3 = skip_space(skip_to_space(p2));
			if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_INSTALL, atoi(p1), atoi(p2)-1, atoi(p3));
			break;
		
		case 'i': /* Spionage */
		case 'I':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			p3 = skip_space(skip_to_space(p2));
			if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_SPY, atoi(p1), atoi(p2), atoi(p3));
			break;
		
		case 'k': /* Korruption */
		case 'K':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			p3 = skip_space(skip_to_space(p2));
			if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_CORRUPT, atoi(p1), atoi(p2), atoi(p3));
			break;
		
		case 'f': /* Forschung */
		case 'F':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			p3 = skip_space(skip_to_space(p2));
			if (*p1 == '\0' || *p2 == '\0' || *p3 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_FORSCH, atoi(p1), atoi(p2), atoi(p3));
			break;
		
		case 'g': /* Kopfgeld */
		case 'G':
			p1 = skip_space(skip_to_space(p));
			p2 = skip_space(skip_to_space(p1));
			if (*p1 == '\0' || *p2 == '\0') return(FEHLER_F);
			cmd = add_cmd(CMD_KOPFGELD, atoi(p1), atoi(p2), 0);
			break;
		
		default:
			return(FEHLER_F);
		}
		do_cmd(cmd);
	}
	return(OK);
}


BYTE get_bef(P(PLAYER *) player, P(char *) pathname)
PP(PLAYER *player;)
PP(char *pathname;)
{
	FILE *bef_datei;
	char gc_id[MAX_NAMELG];
	WORD pl_number;
	WORD starDate;
	BYTE fehler;
	
	bef_datei = bef_exists(pathname, gc_id, &pl_number, &starDate);
	if (bef_datei == NULL)
		return(FEHLER_O);
	if (strcmp(gc_id, gc_global.gc_id) != 0 ||
		pl_number != player->pl_number ||
		starDate != gc_global.starDate)
	{
		f_close(bef_datei);
		return(FEHLER_V);
	}
	delete_all_cmds(player);
	reset_to_initial_state(player);
	fehler = _get_bef(bef_datei);
	f_close(bef_datei);
	cmd_recalc(player);
	cmds_have_changed = FALSE;
	return(fehler);
}


void cmd_recalc(P(PLAYER *) player)
PP(PLAYER *player;)
{
	CMD *cmd;
	
	if(player){} /* UNUSED */
	reset_to_initial_state(me);
	FOR_ALL_CMDS(cmd)
	{
		do_cmd(cmd);
	}
}


void cmd_delete(P(CMD *) cmd)
PP(CMD *cmd;)
{
	if (cmd != NULL && cmd != &cmd_head)
	{
		cmd->prev->next = cmd->next;
		cmd->next->prev = cmd->prev;
		OFREE(cmd);
		cmd_recalc(me);
		cmds_changed();
		cmds_have_changed = TRUE;
	}
}


void delete_all_cmds(P(PLAYER *) player)
PP(PLAYER *player;)
{
	CMD *cmd, *next;
	
	if (player != NULL)
	{
		if (!CMD_LIST_EMPTY())
		{
			cmd = cmd_head.next;
			while (cmd != &cmd_head)
			{
				next = cmd->next;
				OFREE(cmd);
				cmd = next;
			}
			cmd_head.next = cmd_head.prev = &cmd_head;
		}
	}
}


void undo_last_cmd(P(void))
{
	if (!CMD_LIST_EMPTY())
	{
		cmd_delete(cmd_head.prev);
	}
}


void undo_last_ship_cmd(P(void))
{
	CMD *cmd;
	
	for (cmd = cmd_head.prev; cmd != &cmd_head; cmd = cmd->prev)
	{
		switch (cmd->cmd_code)
		{
		case CMD_MOVE_SHIP:
		case CMD_LOAD_SHIP:
		case CMD_MOVE_TF:
		case CMD_TASKFORCE:
		case CMD_SCHROTT:
		case CMD_CHOWN:
			cmd_delete(cmd_head.prev);
			return;
		default:
			/* do nothing */;
		}
	}
}


PLANET *find_pe_planet(P(PLAYER *) player)
PP(PLAYER *player;)
{
	WORD i;
	PLANET **planets;
	PLANET *planet;
	
	planets = player->pl_planets;
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		if (planet != NULL && planet->p_new_pe != 0 && planet->p_owner == player->pl_number)
		{
			return(planet);
		}
	}
	return(NULL);
}


void recalc_bef(P(PLAYER *) player)
PP(PLAYER *player;)
{
	WORD i, j;
	PLANET **planets;
	PLANET *planet;
	SCHIFF **ships;
	SCHIFF *s;
	int did_any;
	
	delete_all_cmds(player);
	
	/*
	 * Forschung
	 */
	planets = player->pl_planets;
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		if (planet != NULL && planet->p_owner == player->pl_number)
		{
			for (j = 0; j < ANZ_FG; j++)
			{
				if (planet->p_forschen[j])
				{
					if (add_cmd(CMD_FORSCH, planet->p_number, planet->p_forschen[j], j) == NULL)
						return;
				}
			}
		}
	}
	
	/*
	 * Spionage + Korruption
	 */
	planets = player->pl_planets;
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		if (planet != NULL && planet->p_owner == player->pl_number)
		{
			for (j = 0; j < MAX_GEHEIM; j++)
			{
				if (planet->p_geheim[j].m_target)
				{
					if (planet->p_geheim[j].m_pe < 0)
					{
						if (add_cmd(CMD_CORRUPT, planet->p_geheim[j].m_target, -planet->p_geheim[j].m_pe, planet->p_number) == NULL)
							return;
					} else {
						if (add_cmd(CMD_SPY, planet->p_geheim[j].m_target, planet->p_geheim[j].m_pe, planet->p_number) == NULL)
							return;
					}
				}
			}
		}
	}
	
	/*
	 * Schiffe beladen, bewegen und uebereignen.
	 */
	ships = player->pl_ships;
	for (i = 0; i < player->pl_num_ships; i++)
	{
		s = ships[i];
		did_any = FALSE;
		if (s->s_schrott)
		{
			/* zu verschrottende Schiffe koennen vorher nur entladen werden */
			for (j = 0; j < ANZ_LADUNG; j++)
			{
				if (s->s_new_ladung[j] < s->s_ladung[j])
				{
					if (add_cmd(CMD_LOAD_SHIP, s->s_number, j, s->s_new_ladung[j] - s->s_ladung[j]) == NULL)
						return;
				}
			}
			if (add_cmd(CMD_SCHROTT, s->s_number, 0, 0) == NULL)
				return;
			did_any = TRUE;
		} else {
			/* be-/entladen */
			for (j = 0; j < ANZ_LADUNG; j++)
			{
				if (s->s_new_ladung[j] != s->s_ladung[j])
				{
					if (add_cmd(CMD_LOAD_SHIP, s->s_number, j, s->s_new_ladung[j] - s->s_ladung[j]) == NULL)
						return;
					did_any = TRUE;
				}
			}
			/* zuordnen */
			if (s->s_new_tf_nr != s->s_tf_nr)
			{
				if (add_cmd(CMD_TASKFORCE, s->s_number, s->s_new_tf_nr, 0) == NULL)
					return;
				did_any = TRUE;
			}
			/* bewegen */
			if (s->s_new_ziel != s->s_ziel && s->s_new_ziel != 0)
			{
				if (add_cmd(CMD_MOVE_SHIP, s->s_number, s->s_new_ziel, 0) == NULL)
					return;
				did_any = TRUE;
			}
			/* uebereignen */
			if (s->s_new_owner != 0)
			{
				if (add_cmd(CMD_CHOWN, s->s_number, s->s_new_owner, 0) == NULL)
					return;
				did_any = TRUE;
			}
			if (did_any)
				ship_changed(player, s);
		}
	}
	
	/*
	 * Produktion auf Planeten
	 */
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		if (planet != NULL && planet->p_owner == player->pl_number)
		{
			WORD festungen;
			
			/* Kits */
			if (planet->p_inst_mkits != 0)
				if (add_cmd(CMD_INSTALL, planet->p_number, LAD_MKITS, planet->p_inst_mkits) == NULL)
					return;
			if (planet->p_inst_lkits != 0)
				if (add_cmd(CMD_INSTALL, planet->p_number, LAD_LKITS, planet->p_inst_lkits) == NULL)
					return;
			if (planet->p_inst_rkits != 0)
				if (add_cmd(CMD_INSTALL, planet->p_number, LAD_RKITS, planet->p_inst_rkits) == NULL)
					return;
			if (planet->p_inst_fkits != 0)
				if (add_cmd(CMD_INSTALL, planet->p_number, LAD_FKITS, planet->p_inst_fkits) == NULL)
					return;
			
			/* Produktion */
			festungen = planet->p_festungen;
			if (festungen == -1)
				festungen = 0;
			if (planet->p_new_festungen != festungen)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_FESTUNG, planet->p_new_festungen - festungen) == NULL)
					return;
			if (planet->p_new_minen != planet->p_minen)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_MINEN, planet->p_new_minen - planet->p_minen) == NULL)
					return;
			if (planet->p_new_ladung[LAD_MKITS] != planet->p_ladung[LAD_MKITS])
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_MKITS, planet->p_new_ladung[LAD_MKITS] - planet->p_ladung[LAD_MKITS]) == NULL)
					return;
			if (planet->p_new_landw != planet->p_landw)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_LANDW, planet->p_new_landw - planet->p_landw) == NULL)
					return;
			if (planet->p_new_ladung[LAD_LKITS] != planet->p_ladung[LAD_LKITS])
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_LKITS, planet->p_new_ladung[LAD_LKITS] - planet->p_ladung[LAD_LKITS]) == NULL)
					return;
			if (planet->p_new_raffs != planet->p_raffs)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_RAFF, planet->p_new_raffs - planet->p_raffs) == NULL)
					return;
			if (planet->p_new_ladung[LAD_RKITS] != planet->p_ladung[LAD_RKITS])
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_RKITS, planet->p_new_ladung[LAD_RKITS] - planet->p_ladung[LAD_RKITS]) == NULL)
					return;
			if (planet->p_new_fabriken != planet->p_fabriken)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_FABRIK, planet->p_new_fabriken - planet->p_fabriken) == NULL)
					return;
			if (planet->p_new_ladung[LAD_FKITS] != planet->p_ladung[LAD_FKITS])
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_FKITS, planet->p_new_ladung[LAD_FKITS] - planet->p_ladung[LAD_FKITS]) == NULL)
					return;
			if (planet->p_new_werft[0].w_groesse != planet->p_werft[0].w_groesse)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_WERFT1, planet->p_new_werft[0].w_groesse - planet->p_werft[0].w_groesse) == NULL)
					return;
			if (planet->p_new_werft[1].w_groesse != planet->p_werft[1].w_groesse)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_WERFT2, planet->p_new_werft[1].w_groesse - planet->p_werft[1].w_groesse) == NULL)
					return;
			if (planet->p_new_werft[2].w_groesse != planet->p_werft[2].w_groesse)
				if (add_cmd(CMD_PRODUCE, planet->p_number, GUT_WERFT3, planet->p_new_werft[2].w_groesse - planet->p_werft[2].w_groesse) == NULL)
					return;
			
			/* Schiffsumstellungen */
			if (planet->p_new_werft[0].w_typ != planet->p_werft[0].w_typ)
				if (add_cmd(CMD_WERFT, planet->p_number, 0, planet->p_new_werft[0].w_typ) == NULL)
					return;
			if (planet->p_new_werft[1].w_typ != planet->p_werft[1].w_typ)
				if (add_cmd(CMD_WERFT, planet->p_number, 1, planet->p_new_werft[1].w_typ) == NULL)
					return;
			if (planet->p_new_werft[2].w_typ != planet->p_werft[2].w_typ)
				if (add_cmd(CMD_WERFT, planet->p_number, 2, planet->p_new_werft[2].w_typ) == NULL)
					return;
			
			/* Schiffsbau */
			if (planet->p_new_werft[0].w_pe_in_runde != planet->p_werft[0].w_pe_in_runde)
				if (add_cmd(CMD_CONS_SHIP, planet->p_number, 0, planet->p_new_werft[0].w_pe_in_runde - planet->p_werft[0].w_pe_in_runde) == NULL)
					return;
			if (planet->p_new_werft[1].w_pe_in_runde != planet->p_werft[1].w_pe_in_runde)
				if (add_cmd(CMD_CONS_SHIP, planet->p_number, 1, planet->p_new_werft[1].w_pe_in_runde - planet->p_werft[1].w_pe_in_runde) == NULL)
					return;
			if (planet->p_new_werft[2].w_pe_in_runde != planet->p_werft[2].w_pe_in_runde)
				if (add_cmd(CMD_CONS_SHIP, planet->p_number, 2, planet->p_new_werft[2].w_pe_in_runde - planet->p_werft[2].w_pe_in_runde) == NULL)
					return;
		}
	}
	
	/*
	 * und zum Schluss Kopfgeld aussetzen
	 */
	if (player->pl_kg_player)
		if (add_cmd(CMD_KOPFGELD, player->pl_kg_pes, player->pl_kg_player, 0) == NULL)
			return;
	
	/*
	 * und jetzt alles neu durchrechnen
	 */
	cmd_recalc(player);
	cmds_changed();
	cmds_have_changed = TRUE;
}


WORD costs_of_ship(P(WFT *) wft)
PP(WFT *wft;)
{
	WORD kosten;
	
	if (wft->w_typ == 0)
		return(0);
	kosten = SH_TYP(wft->w_typ)->t_kosten[me->pl_tech_level_new[FG_CONS]];
	if (wft->w_erster)
	{
		kosten += (kosten >> 1) + (kosten & 1);
	}
	return(kosten);
}


/*
 * Auf allen Planeten PEs in die Werften stecken
 */
void cons_ships(P(PLAYER *) player)
PP(PLAYER *player;)
{
	WORD i;
	WORD wft;
	PLANET **planets, *planet;
	int did_some = FALSE;
	WORD pe;
	CMD *cmd;
	
	planets = player->pl_planets;
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		if (planet != NULL && planet->p_owner == player->pl_number)
		{
			for (wft = 0; wft < MAX_WERFT && planet->p_new_pe > 0; wft++)
			{
				if (planet->p_new_werft[wft].w_groesse > 0)
				{
					pe = costs_of_ship(&planet->p_new_werft[wft]);
					/* pe is now pes we need to build ship */
					pe -= planet->p_new_werft[wft].w_pe;
					/* pe is now pes we need this round */
					if (pe > planet->p_new_werft[wft].w_groesse)
						pe = planet->p_new_werft[wft].w_groesse;
					/* pe is now how much we can */
					pe -= planet->p_new_werft[wft].w_pe_in_runde;
					/* pe is now how much we need for command */
					if (pe < 0)
						pe = 0;
					if (pe > (WORD)planet->p_new_pe)
						pe = planet->p_new_pe;
					if (pe > 0)
					{
						cmd = add_cmd(CMD_CONS_SHIP, planet->p_number, wft, pe);
						if (cmd == NULL)
							break;
						do_cmd(cmd);
						planet_changed(player, planet);
						did_some = TRUE;
					}
				}
			}
		}
	}
	if (did_some)
	{
		cmds_changed();
		cmds_have_changed = TRUE;
	}
}

