#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <math.h>
#include "gchdr.h"
#include "gcio.h"
#include "gcmapps.h"

#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif


#define XSIZE 2
#define YSIZE 2

#define XSPARE 4
#define YSPARE 2

#define N_ROWS(size) ((size) * YSIZE + YSPARE)
#define N_COLS(size) ((size) * XSIZE + XSPARE)

static void line_draw _(( WORD x1, WORD y1, WORD x2, WORD y2, char **lines, WORD xsize, WORD ysize ));
static LIMES *show_limes _(( LIMES *, char **, WORD ));


static void line_draw(P(WORD) x1, P(WORD) y1, P(WORD) x2, P(WORD) y2,
	P(char **) lines, P(WORD) xsize, P(WORD) ysize)
PP(WORD x1;)
PP(WORD y1;)
PP(WORD x2;)
PP(WORD y2;)
PP(char **lines;)
PP(WORD xsize;)
PP(WORD ysize;)
{
	WORD x, y;
	WORD dx, dy;
	WORD vec;
	WORD diff;
	
	dx = x2 - x1;
	vec = 0;
	if (dx < 0)
	{
		vec = 1;
		dx = -dx;
	}
	dy = y2 - y1;
	if (dy >= 0)
	{
		vec |= 2;
		dy = -dy;
	}
	diff = -dy;
	if (dx > diff)
		diff = dx;
	diff++;
	x = x1;
	y = y1;
	x1 = (dx + dy) / 2;
	for (;;)
	{
		if (x >= 0 && x < xsize &&
			y >= 0 && y < ysize)
		{
			lines[ysize - y - 1][x] = '+';
		}
		if (--diff == 0)
			break;
		if (x1 >= 0)
		{
			if (vec & 1)
				--x;
			else
				++x;
			x1 += dy;
		}
		if (x1 < 0)
		{
			if (vec & 2)
				++y;
			else
				--y;
			x1 += dx;
		}
	}
}


#define Wround(x,fac) ((WORD)(floor((((x) - 1.0) * (fac)) + 0.5)))

static LIMES *show_limes(P(LIMES *) limes, P(char **) lines, P(WORD) size)
PP(LIMES *limes;)
PP(char **lines;)
PP(WORD size;)
{
	WORD number;
	double x1, y1;
	double x2, y2;
	
	number = limes->l_limes_number;
	x1 = limes->l_x;
	y1 = limes->l_y;
	limes = limes->l_next;
	while (limes != NULL &&
		number == limes->l_limes_number)
	{
		x2 = limes->l_x;
		y2 = limes->l_y;
		line_draw(Wround(x1, XSIZE), Wround(y1, YSIZE),
			Wround(x2, XSIZE), Wround(y2, YSIZE), lines, N_COLS(size), size * YSIZE);
		limes = limes->l_next;
		x1 = x2;
		y1 = y2;
	}
	return(limes);
}


BYTE buildASC(P(char *) fname, P(PLAYER *) aWorld)
PP(char *fname;)
PP(PLAYER *aWorld;)
{
	char	fpsname[128];
	WORD	size;
	FILE	*fp;
	PlanetList	*list;
	WORD	i;
	char	**lines;
	char	c;
	WORD	x, y;
	char	numbuf[10];
	char player_names[MAX_SPIELER];
	char used_low[26];
	char used_high[26];
	Bool unknown_planets = FALSE;
	
	if (strcmp(fname, "-") == 0)
	{
		strcpy(fpsname, aWorld->pl_path);
		strcat (fpsname, EXT_ASC);
		fp = stdout;
	} else {
		strcpy (fpsname, fname);
		if (strlen(fpsname) < strlen(EXT_ASC) ||
			strcmp(fpsname + strlen(fpsname) - strlen(EXT_ASC), EXT_ASC) != 0)
		{
			strcat (fpsname, EXT_ASC);
		}
		fp = fopen (fpsname, "w");
		if (fp == NULL)
		{
			return(FEHLER_C);
		}
	}
	
	size = gc_global.maxMapSize;
	lines = (char **)MALLOC((size_t)(N_ROWS(size) * sizeof(char *)), "ascfunct: lines");
	if (lines == NULL)
	{
		if (fp != stdout)
			f_close(fp);
		return(FEHLER_M);
	}
	for (i = 0; i < N_ROWS(size); i++)
	{
		lines[i] = (char *)MALLOC((size_t)(N_COLS(size)+1), "ascfunct: line");
		if (lines[i] == NULL)
		{
			if (fp != stdout)
				f_close(fp);
			return(FEHLER_M);
		}
		memset(lines[i], ' ', (size_t)N_COLS(size));
		lines[i][N_COLS(size)] = '\0';
	}
	
	if (verbose)
		fprintf (stderr, "writing %s\n", fpsname);
	
	/*
	 * Grenzlinien zeichnen
	 */
	if (limesline)
	{
		LIMES *limes;
		
		limes = aWorld->pl_limes;
		while (limes != NULL)
		{
			limes = show_limes(limes, lines, size);
		}
	}
	
	memset(player_names, 0, sizeof(player_names));
	memset(used_low, 0, sizeof(used_low));
	memset(used_high, 0, sizeof(used_high));
	
	/*
	 * Planetenpositionen einzeichnen
	 */
	for (list = aWorld->pl_planetlist; list; list = list->l_next)
	{
		c = ' ';
		if (list->l_koordinate.x != 0 && list->l_koordinate.y != 0)
		{
			if (plotStatus)
			{
				int status = list->l_status;
				WORD owner;
				
				owner = list->l_owner;
				if (owner == 0 && list->l_planet != NULL)
					owner = list->l_planet->p_owner;
				if (status == STATUS_OWN && owner != aWorld->pl_number)
					status = STATUS_ENEMY;
				switch (status)
				{
				case STATUS_INFO:
					c = '@';
					break;
				case STATUS_OWN:
					c = '*';
					break;
				case STATUS_ENEMY:
					if (owner != 0)
					{
						c = player_names[owner-1];
						if (c == 0)
						{
							char c2, *p;
							
							p = spieler_name(owner);
							while (*p != '\0' && !isalpha(*p))
								p++;
							c = tolower(*p);
							c2 = c;
							do {
								if (used_low[c - 'a'] != 0)
								{
									c = toupper(c);
									if (used_high[c - 'A'] != 0)
									{
										c = tolower(c) + 1;
										if (c > 'z')
											c = 'a';
									} else {
										used_high[c - 'A'] = owner;
										player_names[owner-1] = c;
										break;
									}
								} else {
									used_low[c - 'a'] = owner;
									player_names[owner-1] = c;
									break;
								}
							} while (c != c2);
							if (c == c2)
							{
							}
						}
					} else {
						c = '^';
						unknown_planets = TRUE;
					}
					break;
				default:
					c = '?';
					break;
				}
			} else {
				c = '?';
			}
			if (c != ' ')
			{
				y = (size - list->l_koordinate.y) * YSIZE;
				x = (list->l_koordinate.x - 1) * XSIZE;
				lines[y][x] = c;
				sprintf(numbuf, "%d", list->l_number);
				if (x > 0)
					--x;
				strncpy(&lines[y+1][x], numbuf, strlen(numbuf));
			}
		}
	}
	
	i = N_COLS(size);
	for (y = 0; y < N_ROWS(size); y++)
	{
		for (x = 0; x < N_COLS(size) && lines[y][x] == ' '; x++)
			;
		if (x < i)
			i = x;
		for (x = N_COLS(size); --x >= 0 && lines[y][x] == ' '; )
			lines[y][x] = '\0';
	}
	
	for (y = 0; y < N_ROWS(size) && lines[y][0] == '\0'; y++)
	{
		FREE(lines[y], (size_t)(N_COLS(size)+1));
		lines[y] = NULL;
	}
	for (y = N_ROWS(size); --y >= 0 && (lines[y] == NULL || lines[y][0] == '\0'); )
	{
		if (lines[y] != NULL)
		{
			FREE(lines[y], (size_t)(N_COLS(size)+1));
			lines[y] = NULL;
		}
	}
	for (y = 0; y < N_ROWS(size); y++)
	{
		if (lines[y] != NULL)
			fprintf(fp, "%s\n", &lines[y][i]);
	}
	
	/*
	 * Legende
	 */
	fprintf(fp, "\n");
	if (limesline)
		fprintf(fp, "+: Grenzen\n");
	fprintf(fp, "*: eigene Planeten\n");
	fprintf(fp, "@: neutrale Planeten\n");
	if (unknown_planets)
		fprintf(fp, "^: feindliche Planeten\n");
	fprintf(fp, "?: Unbekannte Planeten\n");
	for (i = 0; i < MAX_SPIELER; i++)
	{
		if (player_names[i] != 0)
		{
			fprintf(fp, "%c: %s\n", player_names[i], spieler_name(i+1));
		}
	}
	
	fflush(fp);
	if (fp != stdout)
		f_close (fp);
	
	for (y = 0; y < N_ROWS(size); y++)
	{
		if (lines[y] != NULL)
			FREE(lines[y], (size_t)(N_COLS(size)+1));
	}
	FREE(lines, (size_t)(N_ROWS(size) * sizeof(char *)));
	
	return(OK);
}
