/**************************************************************
 * TMPMAP.C                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 play-by-mail space conquest game host.       *
 * Tmpmap file access module.                                 *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     13-Feb-97                                         *
 **************************************************************/


/* included files *********************************************/


#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "astrowar.h"


/* global variables *******************************************/


FILE *mapfile;       /* data file handle */
char  tmapname[128]; /* full name of data file */


/* level 1 routines *******************************************/


/* tmpmap_readrec() - generic read record function */
result tmpmap_readrec(pos *p)
{
    if(fread( &p, sizeof(pos), 1, mapfile ) == 0)
        return R_EOF;
    return R_OK;
}

/* tmpmap_searchindex() - search the index for an pos */
long tmpmap_searchindex(pos pp)
{
    long   filepos,      /* position of found record */
           currpos,      /* position before search */
           s_start,      /* start of search area [1] */
           s_middle,     /* middle of search area [1] */
           s_end,        /* end of search area [1] */
           recsize;      /* size of an index record */
    pos    i;            /* current index record */
           /* [1] used in binary search */

    /* initialise search */
    currpos = ftell(mapfile);
    recsize = sizeof(pos);

    /* initialise search positions */
    s_start = 0;
    fseek(mapfile, 0, SEEK_END);
    s_end = (( ftell(mapfile) - 8 ) / recsize) - 1;
    s_middle = ( (s_end - s_start) / 2 ) + s_start;
    if( ftell(mapfile) > 8 )
    {

        /* do the actual search */
        fseek(mapfile, 8 + (recsize * s_middle), SEEK_SET);
        fread(&i, sizeof(pos), 1, mapfile);
        while(( memcmp(&i, &pp, recsize) != 0 ) &&
              ( s_start <= s_end ))
        {
            if( memcmp(&i, &pp, recsize) > 0 )
                s_end = s_middle - 1;
            else
                s_start = s_middle + 1;
            s_middle = ( (s_end - s_start) / 2 ) + s_start;
            fseek(mapfile, 8 + (recsize * s_middle),
                SEEK_SET);
            fread(&i, sizeof(pos), 1, mapfile);
        }

        /* calculate the result */
        if( memcmp(&i, &pp, recsize) == 0 )
            filepos = 8 + (recsize * s_middle);
        else
            filepos = -1;
    }
    else filepos = -1;

    /* return file to previous position whether found or not */
    fseek(mapfile, currpos, SEEK_SET);

    return filepos;
}

/* tmpmap_sortindex() - sort the last index record into place */
void tmpmap_sortindex(void)
{
    long   filepos; /* position for index sort */
    int    sorted;  /* flag 0=unsorted !0=sorted */
    pos    index1,  /* first index to compare */
           index2;  /* second index to compare */

    /* initialise sort */
    fseek(mapfile, 0, SEEK_END);
    filepos = ftell(mapfile) - (2 * ( sizeof(pos) ));
    sorted = 0;

    /* perform sort */
    while( (filepos >= 8) && !sorted )
    {
        fseek(mapfile, filepos, SEEK_SET);
        fread(&index1, sizeof(pos), 1, mapfile);
        fread(&index2, sizeof(pos), 1, mapfile);
        if( memcmp( &index1, &index2, sizeof(pos) ) < 0 )
            sorted = !0;
        else
        {
            fseek(mapfile, filepos, SEEK_SET);
            fwrite(&index2, sizeof(pos), 1, mapfile);
            fwrite(&index1, sizeof(pos), 1, mapfile);
            filepos = filepos - sizeof(pos);
        }
    }
}


/* main function implementation *******************************/


/* tmpmap_open() - create a new pos file */
result tmpmap_open(char *path)
{
    sprintf(tmapname, "%spos.temp", path);
    if(( mapfile = fopen(tmapname, "wb") ) != NULL)
    {
        fwrite("AST100T\0", 8, 1, mapfile);
        fclose(mapfile);
    }
    else
        return R_FILE;
    if(( mapfile = fopen(tmapname, "r+b") ) == NULL)
        return R_FILE;

    return R_OK;
}

/* tmpmap_find() - read a specified pos (by name) */
result tmpmap_find(pos p)
{
    long filepos; /* position of record in index file */

    /* search for pos name */
    if(( filepos = tmpmap_searchindex(p) ) < 8) return R_EOF;
    return R_OK;
}

/* tmpmap_write() - add or update an pos */
result tmpmap_write(pos p)
{
    if( tmpmap_searchindex(p) < 0 )
    {

        /* add new record */
        fseek(mapfile, 0, SEEK_END);
        fwrite(&p, sizeof(pos), 1, mapfile);
        tmpmap_sortindex();
    }
    return R_OK;
}

/* tmpmap_close() - close the pos library/files */
void tmpmap_close(void)
{
    fclose(mapfile);
    remove(tmapname);
}
