/**************************************************************
 * REPORT.H                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 play-by-mail space conquest game host.       *
 * Report file access module.  Header file.                   *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     10-Feb-97                                         *
 **************************************************************/


#ifndef _REPORT_H_
#define _REPORT_H_


/* structure definitions **************************************/


typedef void report;


/* function prototypes ****************************************/


/* report_open() - open the report file */
result report_open(char *path);

/* report_create() - create a new report file */
result report_create(char *path);

/* report_first() - read the first report */
result report_first(report *r);

/* report_next() - read the next report */
result report_next(report *r);

/* report_write() - add or update an report */
result report_write(report *r);

/* report_firstentry() - choose first entry in linked list */
result report_firstentry(report *r);

/* report_nextentry() - choose next entry in linked list */
result report_nextentry(report *r);

/* report_addentry() - add an entry to the linked list */
result report_addentry(report *r);

/* report_new() - allocate memory for a new report */
report *report_new();

/* report_old() - free memory from an old report */
void report_old(report *r);

/* report_settype() - set the 'type' character */
void report_settype(report *r, char type);

/* report_settrans() - set the transaction number */
void report_settrans(report *r, long number);

/* report_sethomewld() - set the homeworld */
void report_sethomewld(report *r, char *name);

/* report_setempire() - set the empire name */
void report_setempire(report *r, char *name);

/* report_setfleetno() - set the fleet number */
void report_setfleetno(report *r, long number);

/* report_setorigin() - set the origin for a send report */
void report_setorigin(report *r, char *name);

/* report_setdest() - set the destination for a send report */
void report_setdest(report *r, char *name);

/* report_setships() - set the ships in a send report */
void report_setships(report *r, long ships);

/* report_setcentre() - set the centre in a map report */
void report_setcentre(report *r, char *name);

/* report_setsender() - set the sender in a write report */
void report_setsender(report *r, char *name);

/* report_setrecip() - set the recipient in a write report */
void report_setrecip(report *r, char *name);

/* report_setname() - set the planet name */
void report_setname(report *r, char *name);

/* report_settext() - set the message text in a write report */
void report_settext(report *r, char *text);

/* report_setvictor() - set the victor in a victory message */
void report_setvictor(report *r, char *name);

/* report_setowner() - set the owner of a fleet/planet */
void report_setowner(report *r, char *name);

/* report_setenemy() - set the number of enemy ships */
void report_setenemy(report *r, long number);

/* report_setpos() - set planet position */
void report_setpos(report *r, pos pp);

/* report_setprod() - set production figures */
void report_setprod(report *r, int prod);

/* report_setdist() - set the fleet distance */
void report_setdist(report *r, int dist);

/* report_setplanet() - set the planet defended */
void report_setplanet(report *r, char *planet);

/* report_seterror() - set the error code */
void report_seterror(report *r, char error);

/* report_gettype() - return the report type */
char report_gettype(report *r);

/* report_gettrans() - return the transaction number */
long report_gettrans(report *r);

/* report_gethomewld() - return the homeworld */
char *report_gethomewld(char *homewld, report *r);

/* report_getempire() - return the empire name */
char *report_getempire(char *name, report *r);

/* report_getfleetno() - return the fleet number */
long report_getfleetno(report *r);

/* report_getorigin() - return the origin planet in a send */
char *report_getorigin(char *name, report *r);

/* report_getdest() - return the destination planet in a send */
char *report_getdest(char *name, report *r);

/* report_getships() - return the number of ships in a send */
long report_getships(report *r);

/* report_getcentre() - return the centre planet of a map */
char *report_getcentre(char *name, report *r);

/* report_getsender() - return the sender of a written msg */
char *report_getsender(char *name, report *r);

/* report_getrecip() - return the recipient of a written msg */
char *report_getrecip(char *name, report *r);

/* report_getname() - return the planet name */
char *report_getname(char *name, report *r);

/* report_gettext() - return the text of a written msg */
char *report_gettext(report *r);

/* report_getvictor() - return the victor in a victory rpt */
char *report_getvictor(char *name, report *r);

/* report_getowner() - return the owner of a planet/fleet */
char *report_getowner(char *name, report *r);

/* report_getenemy() - return the number of enemy ships */
long report_getenemy(report *r);

/* report_getpos() - return a planet's position */
pos report_getpos(report *r);

/* report_getprod() - return a planet's production */
int report_getprod(report *r);

/* report_getdist() - return a planet's distuction */
int report_getdist(report *r);

/* report_getplanet() - return the planet defended */
char *report_getplanet(char *planet, report *r);

/* report_geterror() - get the error code */
char report_geterror(report *r);

/* report_close() - close report file/library */
void report_close(void);


#endif
