/**************************************************************
 * user.h                    Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - User Database File Maintenance (Header)   *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     24-Mar-97                                         *
 **************************************************************/


#ifndef _USER_H_
#define _USER_H_


/* structures *************************************************/


typedef void user;


/* enumerated types *******************************************/


/* user index */
typedef enum {
    U_NONE,   /* read without index */
    U_NUMBER, /* read by number index */
    U_NAME,   /* read by name index */
    U_LAST    /* placeholder */
} uindex;


/* function prototypes ****************************************/


/* user_open() - open user files */
result user_open(char *path);

/* user_create() - create user files */
result user_create(char *path);

/* user_close() - close user files */
result user_close(void);

/* user_new() - allocate memory for new user record */
user *user_new(void);

/* user_old() - free memory for new user record */
void user_old(user *u);

/* user_clear() - clear details from existing user record */
void user_clear(user *u);

/* user_setnumber() - set the user number */
void user_setnumber(user *u, long number);

/* user_getnumber() - return the user number */
long user_getnumber(user *u);

/* user_setname() - set the user name */
void user_setname(user *u, char *name);

/* user_getname() - return the user name */
char *user_getname(char *name, user *u);

/* user_setaddr() - set the fidonet address */
void user_setaddr(user *u, fido addr);

/* user_getaddr() - return the user address */
fido user_getaddr(user *u);

/* user_setdirect() - set the direct flag */
void user_setdirect(user *u, int direct);

/* user_getdirect() - return the direct flag */
int user_getdirect(user *u);

/* user_write() - write a record */
result user_write(user *u);

/* user_first() - read the first record */
result user_first(user *u, uindex inum);

/* user_next() - read the next record */
result user_next(user *u, uindex inum);

/* user_prev() - read the previous record */
result user_prev(user *u, uindex inum);

/* user_last() - read the last record */
result user_last(user *u, uindex inum);

/* user_find() - find a record by number or name */
result user_find(user *u, char *searchtext);

/* user_delete() - mark a record as deleted */
result user_delete(user *u);

/* user_deleted() - return the deleted status of a record */
int user_deleted(user *u);

/* user_pack() - pack a close data file */
result user_pack(char *path);


/* end of include file ****************************************/


#endif
