/**************************************************************
 * TRANSN.C                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - Transaction number maintenance            *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     03-Apr-97                                         *
 **************************************************************/


/* included headers *******************************************/


#include <stdio.h>


/* some macros ************************************************/


/* reading and writing long integers */
#define FREADLONG(l,d)  {                          \
                        l = fgetc(d);              \
                        l += 0x100 * fgetc(d);     \
                        l += 0x10000 * fgetc(d);   \
                        l += 0x1000000 * fgetc(d); \
                        }
#define FWRITELONG(l,d) {                               \
                        fputc(l & 0xff            , d); \
                        fputc(l / 0x100     & 0xff, d); \
                        fputc(l / 0x10000   & 0xff, d); \
                        fputc(l / 0x1000000 & 0xff, d); \
                        }


/* level 0 routines *******************************************/


/* transn_read() - read and increment */
long transn_read(char *path)
{
    char  filename[128]; /* name of transaction number file */
    FILE *datafile; /* data file handle */
    long  transno;  /* transaction number */

    /* build filename */
    sprintf(filename, "%stransaction.data", path);

    /* attempt to read/update existing file */
    if(( datafile = fopen(filename, "r+b") ) != NULL)
    {
        FREADLONG(transno, datafile);
        transno++;
        fseek(datafile, 0, SEEK_SET);
        FWRITELONG(transno, datafile);
        fclose(datafile);
        return transno - 1;
    }

    /* create new file */
    if(( datafile = fopen(filename, "wb") ) != NULL)
    {
        FWRITELONG(2, datafile);
        fclose(datafile);
        return 1;
    }

    /* whoops, error */
    return 0;
}
