/**************************************************************
 * PLYTXT.C                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - temporary text I/O.                       *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     03-Apr-97 (tmptxt.c)                              *
 *          08-Apr-97 (plytxt.c)                              *
 **************************************************************/


/* included headers *******************************************/


#include <stdio.h>
#include <stdlib.h>
#include "astroml.h"


/* globals ****************************************************/


char plytxt_path[72]; /* path to game */


/* level 0 routines *******************************************/


/* plytxt_open() - initialise the library */
result plytxt_open(char *path)
{
    FILE *textfile; /* file handle */
    char  filename[128]; /* filename */

    /* attempt to clear file */
    sprintf(filename, "%stestfile.tmp", path);
    if(( textfile = fopen(filename, "w") ) == NULL) return R_FILE;
    fclose(textfile);
    remove(filename);
    return R_OK;
}

/* plytxt_write() - add text to the file */
result plytxt_write(long number, char *text)
{
    FILE *textfile;      /* file handle */
    char  filename[128]; /* name of text file */

    sprintf(filename, "%s%08lx.tmp", plytxt_path, number);
    if(( textfile = fopen(filename, "ab") ) == NULL) return R_FILE;
    fputs(text, textfile);
    fclose(textfile);
    return R_OK;
}

/* plytxt_read() - read text from the file */
char *plytxt_read(long number)
{
    FILE *textfile;      /* file handle */
    char *text,          /* text to return */
          filename[128]; /* name of player's file */
    long  size;          /* size of text */

    sprintf(filename, "%s%08lx.tmp", plytxt_path, number);
    if(( textfile = fopen(filename, "rb") ) == NULL) return NULL;
    fseek(textfile, 0, SEEK_END);
    if( (text = malloc( size = ftell(textfile) + 1 )) == NULL )
        return NULL;
    fseek(textfile, 0, SEEK_SET);
    text[ fread(text, 1, size, textfile) ] = '\0';
    fclose(textfile);
    remove(filename);
    return text;
}

/* plytxt_close() - close the library and remove the file */
void plytxt_close(void)
{
}
