/**************************************************************
 * player.h                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - Player Database File Maintenance (header) *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     08-Apr-97                                         *
 **************************************************************/


#ifndef _PLAYER_H_
#define _PLAYER_H_


/* structures *************************************************/


typedef void player; /* hidden player type */


/* enumerated types *******************************************/


/* player index */
typedef enum {
    P_NONE,   /* read without index */
    P_NUMBER, /* read by number index */
    P_EMPIRE, /* read by empire index */
    P_LAST    /* placeholder */
} pindex;


/* function prototypes ****************************************/


/* player_open() - open player files */
result player_open(char *path);

/* player_create() - create player files */
result player_create(char *path);

/* player_close() - close player files */
result player_close(void);

/* player_new() - allocate memory for new player record */
player *player_new(void);

/* player_old() - free memory for new player record */
void player_old(player *p);

/* player_clear() - clear details from existing player record */
void player_clear(player *p);

/* player_setnumber() - set the player number */
void player_setnumber(player *p, long number);

/* player_getnumber() - return the player number */
long player_getnumber(player *p);

/* player_setempire() - set the player empire */
void player_setempire(player *p, char *empire);

/* player_getempire() - return the player empire */
char *player_getempire(char *empire, player *p);

/* player_write() - write a record */
result player_write(player *p);

/* player_first() - read the first record */
result player_first(player *p, pindex inum);

/* player_next() - read the next record */
result player_next(player *p, pindex inum);

/* player_prev() - read the previous record */
result player_prev(player *p, pindex inum);

/* player_last() - read the last record */
result player_last(player *p, pindex inum);

/* player_find() - find a record by number or empire */
result player_find(player *p, char *searchtext);

/* player_delete() - mark a record as deleted */
result player_delete(player *p);

/* player_deleted() - return the deleted status of a record */
int player_deleted(player *p);

/* player_pack() - pack a close data file */
result player_pack(char *path);


/* end of include file ****************************************/


#endif
