/**************************************************************
 * pfleet.h                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - Player Fleet Database File Maintenance.   *
 * Header file.                                               *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     24-Mar-97 (user.H)                                *
 *          04-Apr-97                                         *
 **************************************************************/


#ifndef _PFLEET_H_
#define _PFLEET_H_


/* enumerated types *******************************************/


/* pfleet index */
typedef enum {
    F_NONE,    /* read without index */
    F_FLEETNO, /* fleet number index */
    F_LAST     /* placeholder */
} findex;


/* structures *************************************************/


typedef void pfleet; /* player fleet record */


/* function prototypes ****************************************/


/* pfleet_open() - open pfleet files */
result pfleet_open(char *path);

/* pfleet_create() - create pfleet files */
result pfleet_create(char *path);

/* pfleet_close() - close pfleet files */
result pfleet_close(void);

/* pfleet_new() - allocate memory for new pfleet record */
pfleet *pfleet_new(void);

/* pfleet_old() - free memory for new pfleet record */
void pfleet_old(pfleet *f);

/* pfleet_clear() - clear details from existing pfleet record */
void pfleet_clear(pfleet *f);

/* pfleet_setfleetno() - set the fleetno */
void pfleet_setfleetno(pfleet *f, long fleetno);

/* pfleet_getfleetno() - return the pfleet fleetno */
long pfleet_getfleetno(pfleet *f);

/* pfleet_setuser() - set the user */
void pfleet_setuser(pfleet *f, long user);

/* pfleet_getuser() - return the pfleet user */
long pfleet_getuser(pfleet *f);

/* pfleet_setorigin() - set the planet of origin */
char *pfleet_setorigin(pfleet *f, char *origin);

/* pfleet_getorigin() - return the planet of origin */
char *pfleet_getorigin(char *origin, pfleet *f);

/* pfleet_setdest() - set the planet of dest */
char *pfleet_setdest(pfleet *f, char *dest);

/* pfleet_getdest() - return the planet of dest */
char *pfleet_getdest(char *dest, pfleet *f);

/* pfleet_setships() - set the ships */
void pfleet_setships(pfleet *f, long ships);

/* pfleet_getships() - return the pfleet ships */
long pfleet_getships(pfleet *f);

/* pfleet_write() - write a record */
result pfleet_write(pfleet *f);

/* pfleet_first() - read the first record */
result pfleet_first(pfleet *f, findex inum);

/* pfleet_next() - read the next record */
result pfleet_next(pfleet *f, findex inum);

/* pfleet_prev() - read the previous record */
result pfleet_prev(pfleet *f, findex inum);

/* pfleet_last() - read the last record */
result pfleet_last(pfleet *f, findex inum);

/* pfleet_find() - find a record by fleetno or name */
result pfleet_find(pfleet *f, long fleetno);

/* pfleet_delete() - mark a record as deleted */
result pfleet_delete(pfleet *f);

/* pfleet_deleted() - return the deleted status of a record */
int pfleet_deleted(pfleet *f);

/* pfleet_pack() - pack a close data file */
result pfleet_pack(char *path);


/* end of include file ****************************************/


#endif
