/**************************************************************
 * MSGLIB.H                  Copyright (C) Damian Walker 1996 *
 *------------------------------------------------------------*
 * MsgLib 1.01.  A generic message library shell, expandable  *
 * by adding modules to handle specific message bases.        *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     31-Dec-96 (msglib 1.00)                           *
 *          09-Apr-97 (msglib 1.01)                           *
 **************************************************************/


#ifndef _MSGLIB_H_
#define _MSGLIB_H_


/* type definitions *******************************************/


/* fido - fidonet address */
typedef struct {
    int zone,  /* zone number */
        net,   /* net number */
        node,  /* node number */
        point; /* point number */
} fido;

/* msg - fidonet message (hidden) */
typedef void msg;

/* area - message area (hidden) */
typedef void area;

/* mbase - message base type */
typedef struct {
    area *(*mopen)(char *);
    void  (*mclose)(area *);
    int   (*mfirst)(msg *, area *),
          (*mlast)(msg *, area *),
          (*mnext)(msg *, area *),
          (*mprev)(msg *, area *),
          (*mgoto)(msg *, area *, int),
          (*mpost)(area *, msg *),
          (*mkill)(area *, msg *),
          (*mrewrite)(area *, msg *);
} mbase;

/* msg_result - return codes for various actions */
enum msg_result {
    M_OK,   /* everything went fine */
    M_EOF,  /* no (more) messages */
    M_FILE, /* file I/O error */
    M_NEW,  /* cannot rewrite new message */
    M_LAST  /* place marker */
};


/* function prototypes ****************************************/


/* msg_new() - allocate memory for new message */
msg *msg_new(void);

/* msg_old() - free memory used by old message */
void msg_old(msg *m);

/* msg_setnumber() - set the message number */
void msg_setnumber(msg *m, int number);

/* msg_setfromname() - set the sender's name */
void msg_setfromname(msg *m, char *fromname);

/* msg_setfromaddr() - set the sender's address */
void msg_setfromaddr(msg *m, fido fromaddr);

/* msg_settoname() - set the sender's name */
void msg_settoname(msg *m, char *toname);

/* msg_settoaddr() - set the sender's address */
void msg_settoaddr(msg *m, fido toaddr);

/* msg_setdatetime() - set the date and time */
void msg_setdatetime(msg *m, time_t datetime);

/* msg_setcrash() - set crash flag */
void msg_setcrash(msg *m, int crash);

/* msg_setattach() - set file attach flag */
void msg_setattach(msg *m, int attach);

/* msg_sethold() - set hold flag */
void msg_sethold(msg *m, int hold);

/* msg_setfreq() - set freq flag */
void msg_setfreq(msg *m, int freq);

/* msg_setupdate() - set update flag */
void msg_setupdate(msg *m, int update);

/* msg_setkill() - set kill flag */
void msg_setkill(msg *m, int kill);

/* msg_setpvt() - set pvt flag */
void msg_setpvt(msg *m, int pvt);

/* msg_setlocal() - set local flag */
void msg_setlocal(msg *m, int local);

/* msg_setdirect() - set direct flag */
void msg_setdirect(msg *m, int direct);

/* msg_seterase() - set erase flag */
void msg_seterase(msg *m, int erase);

/* msg_setrcvd() - set rcvd flag */
void msg_setrcvd(msg *m, int rcvd);

/* msg_setsent() - set sent flag */
void msg_setsent(msg *m, int sent);

/* msg_setsubject() - set subject line */
void msg_setsubject(msg *m, char *subject);

/* msg_settext() - set message text */
void msg_settext(msg *m, char *text);

/* msg_getnumber() - return message number */
int msg_getnumber(msg *m);

/* msg_getfromname() - return the from name */
char *msg_getfromname(char *fromname, msg *m);

/* msg_getfromaddr() - return the from address */
fido msg_getfromaddr(msg *m);

/* msg_gettoname() - return the to name */
char *msg_gettoname(char *toname, msg *m);

/* msg_gettoaddr() - return the to address */
fido msg_gettoaddr(msg *m);

/* msg_getdatetime() - return the date and time sent */
time_t msg_getdatetime(msg *m);

/* msg_getcrash() - return the crash bit */
int msg_getcrash(msg *m);

/* msg_getattach() - return the attach bit */
int msg_getattach(msg *m);

/* msg_gethold() - return the hold bit */
int msg_gethold(msg *m);

/* msg_getfreq() - return the freq bit */
int msg_getfreq(msg *m);

/* msg_getupdate() - return the update bit */
int msg_getupdate(msg *m);

/* msg_getkill() - return the kill bit */
int msg_getkill(msg *m);

/* msg_getpvt() - return the pvt bit */
int msg_getpvt(msg *m);

/* msg_getlocal() - return the local bit */
int msg_getlocal(msg *m);

/* msg_getdirect() - return the direct bit */
int msg_getdirect(msg *m);

/* msg_geterase() - return the erase bit */
int msg_geterase(msg *m);

/* msg_getrcvd() - return the rcvd bit */
int msg_getrcvd(msg *m);

/* msg_getsent() - return the sent bit */
int msg_getsent(msg *m);

/* msg_getsubject() - return the subject */
char *msg_getsubject(char *subject, msg *m);

/* msg_gettext() - return the message text */
char *msg_gettext(msg *m);

/* msg_init() - initialise the *.MSG messagebase type */
void msg_init(mbase *b, int zone);


#endif
