/**************************************************************
 * joinrq.h                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - Join Request Database File Maintenance    *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     08-Apr-97                                         *
 **************************************************************/


#ifndef _JOINRQ_H_
#define _JOINRQ_H_


/* structures *************************************************/


typedef void joinrq; /* hidden join request */


/* enumerated types *******************************************/


/* joinrq index */
typedef enum {
    J_NONE,  /* read without index */
    J_TRANS, /* transaction number index */
    J_LAST   /* placeholder */
} jindex;


/* function prototypes ****************************************/


/* joinrq_open() - open joinrq files */
result joinrq_open(char *path);

/* joinrq_create() - create joinrq files */
result joinrq_create(char *path);

/* joinrq_close() - close joinrq files */
result joinrq_close(void);

/* joinrq_new() - allocate memory for new joinrq record */
joinrq *joinrq_new(void);

/* joinrq_old() - free memory for new joinrq record */
void joinrq_old(joinrq *j);

/* joinrq_clear() - clear details from existing joinrq record */
void joinrq_clear(joinrq *j);

/* joinrq_settrans() - set the trans */
void joinrq_settrans(joinrq *j, long trans);

/* joinrq_gettrans() - return the joinrq trans */
long joinrq_gettrans(joinrq *j);

/* joinrq_setuser() - set the user */
void joinrq_setuser(joinrq *j, long user);

/* joinrq_getuser() - return the joinrq user */
long joinrq_getuser(joinrq *j);

/* joinrq_setempire() - set the requested empire name */
char *joinrq_setempire(joinrq *j, char *empire);

/* joinrq_getempire() - return the requested empire name */
char *joinrq_getempire(char *empire, joinrq *j);

/* joinrq_write() - write a record */
result joinrq_write(joinrq *j);

/* joinrq_first() - read the first record */
result joinrq_first(joinrq *j, jindex inum);

/* joinrq_next() - read the next record */
result joinrq_next(joinrq *j, jindex inum);

/* joinrq_prev() - read the previous record */
result joinrq_prev(joinrq *j, jindex inum);

/* joinrq_last() - read the last record */
result joinrq_last(joinrq *j, jindex inum);

/* joinrq_find() - find a record by trans or name */
result joinrq_find(joinrq *j, long trans);

/* joinrq_delete() - mark a record as deleted */
result joinrq_delete(joinrq *j);

/* joinrq_deleted() - return the deleted status of a record */
int joinrq_deleted(joinrq *j);

/* joinrq_pack() - pack a close data file */
result joinrq_pack(char *path);


/* end of include file ****************************************/


#endif
