/**************************************************************
 * config.c                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroMail 1.00 - configuration file maintenance (header)   *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     28-Mar-97 - AstroMail 1.00 config.c               *
 **************************************************************/


#ifndef _CONFIG_H_
#define _CONFIG_H_


/* function prototypes ****************************************/


/* config_open() - intialise the library */
result config_open(char *path);

/* config_close() - clean up and close */
void config_close(void);

/* config_read() - open (and read) the configuration file */
result config_read(char *path, int *line);

/* config_write() - write the config to a file */
result config_write(char *path);

/* config_set...() - set field values */
char *config_setname(char *astname);
char *config_setnetmail(char *netmail);
char *config_setlogfile(char *logfile);
int config_setudirect(int direct);
int config_setrattr(int rattr);
int config_setdattr(int dattr);

/* config_get...() - get field values */
char *config_getname(char *astname);
char *config_getnetmail(char *netmail);
char *config_getlogfile(char *logfile);
int config_getudirect(void);
int config_getrattr(void);
int config_getdattr(void);

/* config_firstaka() - return first aka */
result config_firstaka(fido *f);

/* config_nextaka() - return the next aka */
result config_nextaka(fido *f);

/* config_findaka() - find an AKA in the list */
result config_findaka(fido n);

/* config_addaka() - add an AKA to the list */
result config_addaka(fido n);

/* config_deleteaka() - delete an AKA from the list */
result config_deleteaka(fido n);


#endif
