/**************************************************************
 * FORECS.H                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 - Planet database library header file.       *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     28-Apr-97                                         *
 **************************************************************/


#ifndef _FORECS_H_
#define _FORECS_H_


/* enumerated types *******************************************/


/* forecs index */
typedef enum {
    Z_NONE, /* read without index */
    Z_NAME, /* forecs name index */
    Z_LAST  /* placeholder */
} zindex;


/* structures & prototypes ************************************/


#ifndef _FORECS_C_

typedef void forecs; /* hidden join request */

/* forecs_open() - open forecs files */
result forecs_open(char *path);

/* forecs_create() - create forecs files */
result forecs_create(char *path);

/* forecs_close() - close forecs files */
result forecs_close(void);

/* forecs_new() - allocate memory for new forecs record */
forecs *forecs_new(void);

/* forecs_old() - free memory for new forecs record */
void forecs_old(forecs *w);

/* forecs_clear() - clear details from existing forecs record */
void forecs_clear(forecs *w);

/* forecs_setname() - set the forecs name */
char *forecs_setname(forecs *w, char *name);

/* forecs_getname() - return the forecs name */
char *forecs_getname(char *name, forecs *w);

/* forecs_setowner() - set the owner */
char *forecs_setowner(forecs *w, char *owner);

/* forecs_getowner() - return the owner */
char *forecs_getowner(char *owner, forecs *w);

/* forecs_setships() - set the ships in orbit */
long forecs_setships(forecs *w, long ships);

/* forecs_getships() - return the ships in orbit */
long forecs_getships(forecs *w);

/* forecs_write() - write a record */
result forecs_write(forecs *w);

/* forecs_first() - read the first record */
result forecs_first(forecs *w, zindex inum);

/* forecs_next() - read the next record */
result forecs_next(forecs *w, zindex inum);

/* forecs_prev() - read the previous record */
result forecs_prev(forecs *w, zindex inum);

/* forecs_last() - read the last record */
result forecs_last(forecs *w, zindex inum);

/* forecs_find() - find a record by trans or name */
result forecs_find(forecs *w, char *name);

/* forecs_delete() - mark a record as deleted */
result forecs_delete(forecs *w);

/* forecs_deleted() - return the deleted status of a record */
int forecs_deleted(forecs *w);

/* forecs_pack() - pack a close data file */
result forecs_pack(char *path);

#endif /*_FORECS_C_*/


/* end of include file ****************************************/


#endif /*_FORECS_H_*/
