/**************************************************************
 * FLEETS.H                  Copyright (C) Damian Walker 1997 *
 *------------------------------------------------------------*
 * AstroWar 1.00 - Empire database library header file.       *
 *------------------------------------------------------------*
 * Author   Damian G Walker                                   *
 * Date     28-Apr-97                                         *
 **************************************************************/


#ifndef _FLEETS_H_
#define _FLEETS_H_


/* enumerated types *******************************************/


/* fleet index */
typedef enum {
    F_NONE,   /* read without index */
    F_NUMBER, /* fleet name index */
    F_LAST    /* placeholder */
} findex;


/* structures & prototypes ************************************/


#ifndef _FLEETS_C_

typedef void fleet; /* hidden join request */

/* fleets_open() - open fleet files */
result fleets_open(char *path);

/* fleets_create() - create fleet files */
result fleets_create(char *path);

/* fleets_close() - close fleet files */
result fleets_close(void);

/* fleets_new() - allocate memory for new fleet record */
fleet *fleets_new(void);

/* fleets_old() - free memory for new fleet record */
void fleets_old(fleet *e);

/* fleets_clear() - clear details from existing fleet record */
void fleets_clear(fleet *e);

/* fleets_setnumber() - set the fleet number */
long fleets_setnumber(fleet *f, long number);

/* fleets_getnumber() - return the fleet number */
long fleets_getnumber(fleet *f);

/* fleets_setdest() - set the homeworld number */
char *fleets_setdest(fleet *f, char *dest);

/* fleets_getdest() - return the homeworld */
char *fleets_getdest(char *dest, fleet *f);

/* fleets_setorigin() - set the homeworld number */
char *fleets_setorigin(fleet *f, char *origin);

/* fleets_getorigin() - return the homeworld */
char *fleets_getorigin(char *origin, fleet *f);

/* fleets_setowner() - set the homeworld number */
char *fleets_setowner(fleet *f, char *owner);

/* fleets_getowner() - return the homeworld */
char *fleets_getowner(char *owner, fleet *f);

/* fleets_setships() - set ship count */
long fleets_setships(fleet *f, long ships);

/* fleets_getships() - return the fleet ships */
long fleets_getships(fleet *f);

/* fleets_setdist() - set distance */
int fleets_setdist(fleet *f, int dist);

/* fleets_getdist() - return the fleet dist */
int fleets_getdist(fleet *f);

/* fleets_write() - write a record */
result fleets_write(fleet *f);

/* fleets_first() - read the first record */
result fleets_first(fleet *e, findex inum);

/* fleets_next() - read the next record */
result fleets_next(fleet *e, findex inum);

/* fleets_prev() - read the previous record */
result fleets_prev(fleet *e, findex inum);

/* fleets_last() - read the last record */
result fleets_last(fleet *e, findex inum);

/* fleets_find() - find a record by trans or name */
result fleets_find(fleet *e, long number);

/* fleets_delete() - mark a record as deleted */
result fleets_delete(fleet *e);

/* fleets_deleted() - return the deleted status of a record */
int fleets_deleted(fleet *e);

/* fleets_pack() - pack a close data file */
result fleets_pack(char *path);

#endif /*_FLEETS_C_*/


/* end of include file ****************************************/


#endif /*_FLEETS_H_*/

