/**********************************************************************
 * F2M.C                             Copyright (C) Damian Walker 1997 *
 *--------------------------------------------------------------------*
 * Ash 1.00 - Files-to-Message conversion program.                    *
 *--------------------------------------------------------------------*
 * Author   Damian G Walker                                           *
 * Date     20-Jul-97                                                 *
 **********************************************************************/


#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "ash.h"
#include "orders.h"


/* level 1 routines ***************************************************/


/* f2m_openfiles() - open all files */
FILE *f2m_openfiles(char *gamepath)
{
    char   filename[128]; /* name of message file */
    FILE  *textfile;      /* message file */

    /* attempt to open message file */
    sprintf(filename, "%sorders-file", gamepath);
    return textfile = fopen(filename, "w");
}

/* f2m_writeorders() - write orders to ASCII file */
void f2m_writeorders(FILE *textfile)
{
    order *o = orders_new();
    result r;
    long   ships;
    char   origin[16],
           dest[16],
           centre[16];

    r = orders_first(o);
    while(!r)
    {
        switch( orders_gettype(o) )
        {
            case 'S': ships = orders_getships(o);
                      orders_getorigin(origin, o);
                      orders_getdest(dest, o);
                      fprintf(textfile, "send %ld %s %s\n", ships,
                          origin, dest);
                      break;
            case 'M': orders_getcentre(centre, o);
                      fprintf(textfile, "map %s\n", centre);
                      break;
        }
        r = orders_next(o);
    }
    fprintf(textfile, "planets\nfleets\n--- Ash 1.00\n");
    orders_old(o);
}

/* f2m_closefiles() - close all files */
void f2m_closefiles(FILE *textfile)
{
    fclose(textfile);
}


/* level 0 routines ***************************************************/


/* f2m_main() - main program */
result f2m_main(char *gamepath)
{
    FILE *textfile; /* message file */

    if(( textfile = f2m_openfiles(gamepath) ))
    {
        f2m_writeorders(textfile);
        f2m_closefiles(textfile);
    }

    return R_OK;
}
