/**********************************************************************
 * ASH.C                             Copyright (C) Damian Walker 1996 *
 *--------------------------------------------------------------------*
 * Quick & Dirty AstroWar help program                                *
 *--------------------------------------------------------------------*
 * Author   Damian G Walker                                           *
 * Date     20-Jul-97                                                 *
 **********************************************************************/


#include <stdio.h>
#include "ash.h"
#include "planet.h"
#include "fleets.h"
#include "detail.h"
#include "orders.h"
#include "m2f.h"
#include "plinfo.h"
#include "f2m.h"
#include "forecs.h"


/* level 1 routines ***************************************************/


/* ash_open() - open or create necessary files */
result ash_open(detail **d, char *ename, char *pname, char *path)
{
  result r;
  FILE  *ashfile;
  char   filename[128],
    line[81],
    word[81];

  /* read ASH config */
  sprintf(filename, "%sash.data", path);
  if(( ashfile = fopen(filename, "r") ))
    {
      while( fgets(line, 81, ashfile) )
	if( sscanf(line, "empire=%s", word) == 1 )
	  strcpy(ename, word);
	else if( sscanf(line, "planet=%s", word) == 1 )
	  strcpy(pname, word);
      fclose(ashfile);
    }
  else
    {
      printf("Cannot open %sash.data\n", path);
      return R_FILE;
    }

  /* attempt to open */
  if(( r = fleets_open(path) ))
    if(( r = fleets_create(path) ))
      {
	printf("Cannot create %sfleets.data\n", path);
	goto nofleets;
      }
    else if(( r = fleets_open(path) ))
      {
	printf("Cannot open %sfleets.data\n", path);
	goto nofleets;
      }
  if(( r = planet_open(path) ))
    if(( r = planet_create(path) ))
      {
	printf("Cannot create %splanet.data\n", path);
	goto noplanet;
      }
    else if(( r = planet_open(path) ))
      {
	printf("Cannot open %splanet.data\n", path);
	goto noplanet;
      }
  if(( r = detail_open(d, path) )) 
    {
      printf("Cannot open %sdetail.data\n", path);
      goto nodetail;
    }
  if(( r = orders_open(path) ))
    if(( r = orders_create(path) ))
      {
	printf("Cannot create %sorders.data\n", path);
	goto noorders;
      }
    else if(( r = orders_open(path) ))
      {
	printf("Cannot open %sorders.data\n", path);
	goto noorders;
      }
  if(( r = forecs_open(path) ))
    if(( r = forecs_create(path) ))
      {
	printf("Cannot create %sorders.data\n", path);
	goto noforecs;
      }
    else if(( r = forecs_open(path) ))
      {
	printf("Cannot open %sorders.data\n", path);
	goto noforecs;
      }
  return R_OK;

  /* errors */
noforecs:
  orders_close();
noorders:
  detail_close(*d);
nodetail:
  planet_close();
noplanet:
  fleets_close();
nofleets:
  return r;
}

/* ash_close() - close files */
void ash_close(detail *d, char *path)
{
    forecs_close();
    orders_close();
    detail_close(d);
    planet_close();
    fleets_close();
    fleets_pack(path);
}

/* level 0 routines ***************************************************/


/* main() */
int main(int argc, char **argv)
{
    detail *d; /* detail record */
    result  r;
    char    path[128],
            ename[16],
            pname[16];

    if(argc == 2) strcpy(path, argv[1]); else *path = 0;
    if(!( r = ash_open(&d, ename, pname, path) ))
    {
        m2f_main(path, ename, d);
        plinfo_main(pname, ename, d);
        f2m_main(path);
        ash_close(d, path);
    }

    return r;
}
