/******************************************************************************
 *                                                                            *
 * File:   strupr  .c         Version  1.01            Date: 1996-06-01       *
 *                                                                            *
 * Copyright (C) 1993-1997 by kostis@acm.org (Kosta Kostis)                   *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *    1996-06-01: KK V1.01                                                    *
 *        - prepare for the unexpected by using unsigned char cast            *
 *    1993-05-25: KK V1.00                                                    *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <string.h>
#include <ctype.h>

#include "strupr.h"

/******************************************************************************

	Function:
		convert US ASCII string to upper case

	Parameters:
		char    *String         string to be converted

	Returns:
		char    *String

	Note:
		Allthough this is not strictly ANSI-C, I feel it should be
		in every standard library.

 *****************************************************************************/

char    *strupr
(
	char    *String
)
{
	char    *Help = String ;

	for ( ; *Help != '\0' ; ++Help)
		if (islower ((unsigned char) *Help))
			*Help = (char) toupper ((unsigned char) *Help) ;

	return (String) ;
}
