#! /bin/sh
# rcnew.t - make new cookbook pages with nroff or the typesetter
#   linked to rcnew.n
#
# Spencer Thomas, January 1986
# after rcbook.t by Brian Reid, November 1985
#
# Modifed by:  David Messer, Febuary 1987
#
TROFF="nroff -man"
FRACTIONS=0
RCINDEX="-w 56"
case $0 in
	*.t)	TROFF="ditroff -man"
		FRACTIONS=1
		RCINDEX=-t
		;;
	esac
PATH=:$HOME:.:/usr/users/kiravuo/bin:/usr/hut/bin:/usr/ucb:/bin:/usr/bin:/usr/local/bin:/usr/games:/oppilaat/bin:/etc
export PATH
TMAC=/tmp/tmac.$$
INDEX=/tmp/Index.$$
ENDEX=/tmp/Endex.$$
RECIPES=/tmp/Recipes.$$
trap "rm -f /tmp/*.$$; exit" 0 1 2 3 15
TFLAG=
FRACTIONS=1
METFLAG="-rM1"
KEEPDIR=$HOME/Recipes
while [ $# -gt 0 ];
do
    case $1 in
	    -t) TFLAG="$1";;
	    -m) METFLAG="-rM1";;
	    -M) METFLAG="-rM0";;
	    -f) FRACTIONS=0;;
	    -*) echo $0: Unknown option $1 1>&2 ; exit;;
	    "") KEEPDIR=$HOME/Recipes;;
	    *) KEEPDIR=$1;;
    esac
    shift
done
if [ ! -d $KEEPDIR ]; then
	echo rcnew: Your keep directory $KEEPDIR does not seem to exist. 1>&2
	exit 1
fi;
# if Index.keep exists, then a previous rcnew bombed.  Use the old one.
if [ ! -f Index.keep ]; then
	mv INDEX Index.keep
fi;
echo Typesetting cookbook update 1>&2
echo from files newer than \
    `ls -l Index.keep | awk '/./ {printf("%s %s %s", $5, $6, $7);}'` 1>&2
echo in $KEEPDIR 1>&2
rcindex $RCINDEX $KEEPDIR
cat > $TMAC << 'tmac.recip'
.de RH
.ie '\\$5'' .ds YR 1985
.el .ds YR \\$5
.ie n .ds YC Copyright \\*(YR USENET
.el .ds YC Copyright \(co \\*(YR USENET Community Trust
.ie n .TH \\$2 "\\$3" "\\$4" " " "USENET Cookbook"
.el .TH \\$2 "\\$3" "alt.gourmand \\$4" " " "USENET Cookbook"
.ds ]H \\$2
..
.de RZ
.SH \\s14\\$1
.rs
.ie n .sp 1
.el   .sp 6p
\\*(]H \- \\$2
.fi
.PP
..
.de IG
.ds =1 \\$1
.ds =2 \\$2
.if \\n(.$>2 .if  \\nM .ds =1 \\$3
.TP 10
\&\\*(=1
.I \\*(=2
..
.de SK
.IP "(\\$1)" 5n
..
.de IH
.ds =1 \\$1
.if \\n(.$>1 .if \\nM .ds =1 \\$2
.SH INGREDIENTS (\\*(=1)
.fi
.PD 0
..
.de PH
.PD
.ie '\\$1'' .SH PROCEDURE
.el .SH PROCEDURE \\$1
.RS 5
..
.de TE
.ds =2
.if \\n($>2 .ds =2 \\$3
.ie n .ds =1 \\$1 deg. F
.el .ds =1 \\$1\(deF
.ie n .if \\n(.$>1 .if \\nM .ds =1 \\$2 deg. C
.el .if \\n(.$>1 .if \\nM .ds =1 \\$2\(deC
\\*(=1\\*(=2
..
.de AB
.ds =1 \\$1
.if \\nM .ds =1 \\$2
.ds =2
.if \\n($>2 .ds =2 \\$3
\\*(=1\\*(=2
..
.de NX
.PD
.SH NOTES
..
.de WR
.RE 5
.PD
.SH CONTRIBUTOR
.nf
..
.de CS  \" do the fancy "go into cs mode right" guy
.   ie \\n(.z .cs \\$1 \\$2 \\$3
.   el              \!.CS \\$1 \\$2 \\$3
..
.de FW \" Go into fixed-width mode: put both italic and bold fonts in it
.   CS B 21 \\(.s
.   CS I 21 \\(.s
.   ss 24
.   lg 0
..
.de Fw \" Leave fixed-width mode
.   CS B
.   CS I
.   ss 12
.   lg 1
..
tmac.recip
set `date`
#  Thu Mar 27 22:56:49 PST 1986
YEAR="$6"
YR=`expr $YEAR - 1900`
TODAY="$3 $2 $YR"
sed -e "s/DATE/$TODAY/g" -e "s/YEAR/$YEAR/g" > $INDEX << 'Index'
.RH MOD.RECIPES-SOURCE INDEX Recipes "DATE" YEAR
.ll 6.5i
.nf
.br
.de XX
.tr ~ 
.ta 2.4iR 2.6i 5.3i
.ie !"\\$2""	\\$1~~~~~\\$2	\\$3 \\$4	\\$5
.el	\\$1	\\$3 \\$4	\\$5
..
.ps 8
.vs 10p
Index
cat > $ENDEX << 'Endex'
.vs
Endex
# This next kludge (using file $RECIPES) is because some versions of troff
# can take only a very small number of argument files.
cat `find $KEEPDIR -name '[a-z]*' -newer Index.keep -print | grep '^./[^/]*$' | sort` > $RECIPES
case $FRACTIONS in
  1) cat $INDEX INDEX $ENDEX $RECIPES;;
  *) cat $INDEX INDEX $ENDEX $RECIPES |\
	 sed -e 's/\([0-9a-zA-Z]\)\(\\([1-3]\)/\1 \2/g' \
	     -e 's|\\(12|1/2|' -e 's|\\(14|1/4|' -e 's|\\(34|3/4|' \
	     -e 's|``|"|'     -e "s|''|\"|" ;;
esac | \
$TROFF $METFLAG $TFLAG $TMAC - > Update
echo Update created 2>&1
rm Index.keep
