/* file: util.c

	Purpose:Utility routines for CTHREAD.

	Contents:
		strtran(string,to,from) - string transliteration
		chop(string)		- chop excess spaces from string
		Upper(string)		- convert string to upper case
		strstr(s,pat)		- search for substring

	John Pearson
*/

static char Sccs_Id[]="@(#)util.c	1.1    7/29/94";

#include <string.h>
#include "cthread.h"

/* module: strtran.c

        Purpose:Transliterate characters in string from set in {to,from}.

        Syntax: strtran(string,to,from)
                char *string;                   source string to transliterate
                char *to;                       transliteration set
                char *from;

        John Pearson
*/

strtran(string,to,from)
char *string;
char *to;
char *from;
{
  char *tp;
  char *fp;

  while(*string) {                              /* for each char in     */
    tp = to;                                    /*  string              */
    fp = from;

    while(*fp) {                                /* compare string char  */
      if(*string == *fp)                        /*  to each char in the */
        *string = *tp;                          /*  from set, and if a  */
                                                /*  match, convert to   */
      ++fp;                                     /*  char in to set      */
      ++tp;
    }

    ++string;                                   /* bump to next char    */
  }                                             /*  in string           */
}

/* module: chop.c

	Purpose:Chop off trailing "space" chars from the given string.

	Syntax:	chop(string)
		char *string;

	Return:	none (void)

	Notes:	Will not otherwise modify the string; in particular it
		will not affect embedded "space" chars.
		A "space" char is anything for which the standard C
		macro "isspace" is true.

	John Pearson
*/

#include <stdio.h>
#include <ctype.h>

void chop(string)
register char *string;
{
  register char *p;

  if(string != NULL && *string != 0) {		/* if null ptr or empty	*/
    p = string+(strlen(string)-1);		/*  string, do nothing	*/
						/* else point to last	*/
    while(p >= string && isspace(*p))		/*  char and remove all	*/
      --p;					/*  'spaces' until you	*/
						/*  reach a non-space or*/
    *++p = '\0';				/*  the first char	*/
  }
}

/*----------------------------------------------------------------------*
*                           Function Upper                             *
*                            July 18, 1992                             *
* -------------------------------------------------------------------- *
* AUTHOR:  Tom Kaltenbach                                              *
*          429 Woodsong Lane                                           *
*          Rochester, New York 14612                                   *
*          Email:  tom@kalten.bach1.sai.com                            *
* -------------------------------------------------------------------- *
*                                                                      *
* SUMMARY:                                                             *
*                                                                      *
*    This function takes an input STRING parameter, converts all lower *
* case ltters to uppercase, and returns the string as the function     *
* return value.                                                        *
*                                                                      *
* HISTORY:                                                             *
* slightly modified fuction to use pointers instead of array indexes.  *
* rick larson, August 11, 1992                                         *
*                                                                      *
* 07-29-94     John T. Pearson - changed to void, return never used.   *
*              Eliminate temporary 't' var, unnecessary.               *
*----------------------------------------------------------------------*/
void Upper(d, s)
register char *d, *s;
{
  while (*s) {
    *d = toupper(*s);
    s++;
    d++;
  }

  *d = '\0';
  return;
}

#ifdef M_XENIX
#define WANT_STRSTR
extern char *strstr();
#endif

#ifdef WANT_STRSTR
/*
 * strstr - find a pattern in a string.
 *                - this function mimics the UNIX equivalent.
 */
char *
strstr(s1, s2)
char *s1, *s2;
{
        register int len = strlen(s2);

        while ((s1 = strchr(s1, *s2))) {
                if (strncmp(s1, s2, len) == 0)
                        return s1;
                s1++;
        }
        return NULL;
}
#endif
