/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*              (See file 'brewnix.h' for warranty              */
/*               and redistribution information.)               */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <ctype.h>
#include "brewnix.h"

int get_int(int Default, int field_width)
/*
   AUTHOR
   George W. Sherouse
   6 April 1984
   
   Revised and updated by N.S. "Teddy" Winstead
   3 June 1994
 
*/
{
	int c, val;
	int loop;
	char line_buff[20];
	char Format[80];
	char pad;
	int count;
	int where_x,
	where_y,
	x,
	y;

	pad = ' ';
	getyx(stdscr, where_y, where_x);
	if (field_width > 1)
	{
	    standout();
	}

	for (loop = 0; loop < field_width; loop++)
	    printw(" ");

	sprintf(Format, "%%%dd", field_width);
	mvprintw(where_y, where_x, Format, Default);
	move(where_y, where_x);
	refresh();
	for (loop = 0; loop <= field_width; loop++)
	    line_buff[loop] = 0;

	count = 0;
	while (1)
	{
	    switch (c = (getch() & 0177))
	    {
#ifdef ABORT_CHAR
	    case ABORT_CHAR:
		clear();
		if (field_width > 1)
		{
		    standend();
		}
		mvprintw(0, 0, "Program aborted at your request...");
		move(LINES - 1, 0);
		refresh();
		nl();
		endwin();
		exit(0);
		break;
#endif ABORT_CHAR

	    case '\015':
		if (count && line_buff[count - 1] != '-')
		{
		    sscanf(line_buff, "%d", &val);
		    if (field_width > 1)
		    {
			clean_up(where_y, where_x, Format, val, 1);
		    }
		    else
		    {
			clean_up(where_y, where_x, Format, val, 0);
		    }
		    return(val);
		}
		else
		{
		    if (field_width > 1)
		    {
			clean_up(where_y, where_x, Format, Default, 1);
		    }
		    else
		    {
			clean_up(where_y, where_x, Format, Default, 0);
		    }
		    return(Default);
		}
		break;
	    case 030:
		for (loop = 0; loop < field_width; loop++)
		    line_buff[loop] = 0;
		count = 0;
		mvprintw(where_y, where_x, Format, Default);
		move(where_y, where_x);
		break;
	    case '\021':
	    case '\023':
		break;
	    default:
		if (c == erase_char && count)
		{
		    getyx(stdscr, y, x);
		    mvprintw(y, x - 1, "%c", pad);
		    move(y, x - 1);
		    line_buff[--count] = 0;
		    break;
		}

		if (!count && c == '-')
		{
		    for (loop = 0; loop < field_width; loop++)
			printw("%c", pad);
		    move(where_y, where_x);
		    for (loop = 0; loop < field_width; loop++)
		        line_buff[loop] = 0;

		    line_buff[count++] = (char) c;
		    printw("-");
		    break;
		}

		if (isdigit(c) && count < field_width)
		{
		    if (!count)
		    {
			for (loop = 0; loop < field_width; loop++)
			    printw("%c", pad);
			move(where_y, where_x);
			for (loop = 0; loop < field_width; loop++)
			    line_buff[loop] = 0;
		    }
		    printw("%c", c);
		    line_buff[count++] = (char) c;
		}
		else
		    fprintf(stderr, "%c", '\007');
	    }
	refresh();
	}
}

void clean_up(int where_y, int where_x, char *Format, int val, int end_highlight)

{

    if (end_highlight)
    {
	standend();
    }
    mvprintw(where_y, where_x, Format, val);
    refresh();
}
