/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*              (See file 'brewnix.h' for warranty              */
/*               and redistribution information.)               */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <ctype.h>
#include <strings.h>
#include "brewnix.h"

int pick_one_unit(unit *ChoiceList, int ChoiceCount, int ChoiceVal)

/*
   AUTHOR
   R.J. "Spike" Procassini
   6 July 1995
 
*/
{
    int c;
    int val;
    int biggest;
    int temp;
    int loop;
    int	where_y,
	where_x;
    char Format[80];

/*
In the silly case where there is only one choice, just print it
and return the index 0.
*/
    if (ChoiceCount == 1)
    {
	printw("%s", ChoiceList[0].name);
	return(0);
    }
/*
Find the longest string in the bunch
*/
    biggest = strlen(ChoiceList[0].name);
    for (loop = 1; loop < ChoiceCount; loop++)
	if ((temp = strlen(ChoiceList[loop].name)) > biggest)
	    biggest = temp;

    getyx(stdscr, where_y, where_x);
    standout();
    for (loop = 0; loop < biggest; loop++)
	printw(" ");

    sprintf(Format, "%%-%ds", biggest);

    val = ChoiceVal;
    while (1)
    {
	mvprintw(where_y, where_x, Format, ChoiceList[val].name);
	refresh();

	switch (c = (getch() & 0177))
	{
#ifdef ABORT_CHAR
	case ABORT_CHAR:
	    clear();
	    standend();
	    mvprintw(0, 0, "Program aborted at your request...");
	    move(LINES - 1, 0);
	    refresh();
	    nl();
	    endwin();
	    exit(0);
	    break;
#endif ABORT_CHAR

	case '\015':
	    standend();
	    mvprintw(where_y, where_x, Format, ChoiceList[val].name);
	    refresh();
	    return(val);
	case ' ':
	    if (++val == ChoiceCount)
		val = 0;
	    break;
	case '^':
	    if (--val < 0)
		val = ChoiceCount - 1;
	    break;
	case '\021':
	case '\023':
	    break;
	default:
	    fprintf(stderr, "%c", '\007');
	}
    }
}
