/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*     This program is free software.  You can redistribute     */
/*     it and/or modify it under the terms of Version 2 of      */
/*     the GNU General Public License as published by the       */
/*     Free Software Foundation.                                */
/*                                                              */
/*     This program is distributed in the hope that it will     */
/*     be useful, but WITHOUT ANY WARRANTY, and without even    */
/*     the implied warranty of MERCHANTABILITY or FITNESS       */
/*     FOR A PARTICULAR PURPOSE.  See the GNU General Public    */
/*     License for more details.                                */
/*                                                              */
/*     You should have received a copy of the GNU General       */
/*     Public License along with this program.  If you have     */
/*     not received a copy of the GNU General Public License,   */
/*     then write to:                                           */
/*                                                              */
/*              The Free Software Foundation, Inc.              */
/*              675 Massachusetts Avenue                        */
/*              Cambridge, MA  02139                            */
/*              United States of America                        */
/*                                                              */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*                                                              */
/*           (See file 'COPYING' for the text of the            */
/*                 GNU General Public License.)                 */
/*                                                              */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#ifdef LINUX
#include </usr/include/bsd/sgtty.h>
#endif
#ifdef SUNOS
#include </usr/include/sgtty.h>
#endif
#include <stdio.h>
#include <curses.h>


#define VERSION 0.5
#define MAX_NAME_SIZE_1 40
#define MAX_NAME_SIZE_2 25
#define MAX_NUM_DB_STYLES 150
#define MAX_NUM_DB_MALTS 100
#define MAX_NUM_DB_HOPS 50
#define MAX_NUM_MALTS 8
#define MAX_NUM_HOPS 6


/* Typedefs used for the data base files. */

struct style_struct
{
  char name[MAX_NAME_SIZE_2];
  float original_gravity_min;
  float original_gravity_max;
  float alcohol_min;
  float alcohol_max;
  int IBU_min;
  int IBU_max; 
  float color_min;
  float color_max;
};

typedef struct style_struct style;

struct malt_struct
{
  char name[MAX_NAME_SIZE_2];
  float gravity;
  float color;
  int converted;
};

typedef struct malt_struct malt;

struct hop_struct
{
  char name[MAX_NAME_SIZE_2];
  float alpha_acid_percentage;
};

typedef struct hop_struct hop;

struct beer_struct
{
  char name[MAX_NAME_SIZE_1];
  int style;
  float total_volume;
  int total_volume_units;
  float boil_volume;
  int boil_volume_units;
  malt malts[MAX_NUM_MALTS];
  int num_malts;
  float malt_amounts[MAX_NUM_MALTS];
  float malt_colors[MAX_NUM_MALTS];
  float malt_gravities[MAX_NUM_MALTS];
  int malt_units[MAX_NUM_MALTS];
  hop hops[MAX_NUM_HOPS];
  int num_hops;
  float hop_amounts[MAX_NUM_HOPS];
  int hop_times[MAX_NUM_HOPS];
  float hop_IBUs[MAX_NUM_HOPS];
  int hop_units[MAX_NUM_HOPS];
  int IBU_method;
  float extraction_efficiency;
  float apparent_attenuation;
  float real_attenuation;
  float original_gravity;
  float final_gravity;
  float alcohol_by_volume;
  float color;
  float IBUs;
};

typedef struct beer_struct beer;

struct unit_struct
{
  char name[8];
  float conversion_factor;
};

typedef struct unit_struct unit;

struct order_struct
{
  char name[MAX_NAME_SIZE_1];
  int data_base_location;
};

typedef struct order_struct order;

struct method_struct
{
  char name[8];
};

typedef struct method_struct method;

struct cubic_spline_data_struct
{
  float t_data;
  float y_data;
  float z_data;
};

typedef struct cubic_spline_data_struct cubic_spline_data;


/* Global symbols. */

style *styles;
malt *malts;
hop *hops;
beer *recipe_data_base;
beer current_brew;
unit *volume_units;
unit *malt_weight_units;
unit *hop_weight_units;
order *ordered_recipes;
method *IBU_method_names;
cubic_spline_data *Garetz_data;
int data_base_location;
int data_base_modified;
int max_num_recipes;
int num_hops;
int num_malts;
int num_styles;
int num_recipes;


/* Prototypes for brewnix.c */

extern void Read_Recipe_Data_Base(void);
extern void Read_Styles(void);
extern void Read_Malts(void);
extern void Read_Hops(void);
extern void Set_Units(void);
extern void Set_IBU_Methods(void);
extern void Start_Up(void);
extern void New_Recipe(void);
extern void Load_Recipe(void);
extern void Delete_Recipe(void);
extern void Write_Recipe_Data_Base(void);
extern void Shut_Down(void);
extern void Quit(void);
extern void Clear_Extra_Recipes(void);
extern void Sort_Recipe_Names(void);
extern void Edit_Recipe(int);
extern void Save_Recipe(void);
extern void Real_Attenuation(void);
extern void Select_Malts(int);
extern void Total_Gravity(void);
extern void Total_Alcohol(void);
extern void Total_Color(void);
extern void Select_Hops(int);
extern void Total_IBUs(void);
extern void Print_Guidelines(void);
extern void Print_Recipe_File(void);
extern void Select_Option(void);
extern void Select_IBU_Method(void);
extern float Bitterness(float, float, float, float, float, float);
extern float Hop_Utilization(float);
extern float Specific_Gravity(float, float, float);
extern float Color(float, float, float);
extern float Alcohol_by_Weight(float, float);
extern float Alcohol_by_Volume(float, float);
extern float Evaluate_Cubic_Spline(float, int, cubic_spline_data*);


/* Prototypes for CURSES related files. */

#define ABORT_CHAR ('\03')

char erase_char;

extern int pick_one_style(style*, int, int);
extern int pick_one_malt(malt*, int, int);
extern int pick_one_hop(hop*, int, int);
extern int pick_one_unit(unit*, int, int);
extern int pick_one_method(method*, int, int);
extern int pick_one_recipe(order*, int);
extern char get_erase(void);
extern void get_string(char*, int, int, int);
extern float get_float(float, int, int);
extern void f_clean_up(int, int, char*, float, int);
extern int get_int(int, int);
extern void clean_up(int, int, char*, int, int);


/* Miscellaneous Prototypes. */
extern void *malloc(int);
extern void *realloc(void*, int);
extern void free(void*);
extern int strcasecmp(const char*, const char*);
extern unsigned int sleep(unsigned int);
