/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*             (See file 'brewcalc.h' for warranty              */
/*               and redistribution information.)               */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <stdio.h>
#include <ctype.h>
#include "brewcalc.h"

float get_float(float Default, int field_width, int places)
/*
   AUTHOR
   George W. Sherouse
   9 April 1984

   Revised and updated by N.S. "Teddy" Winstead
   3 June 1994
 
*/
{
	int c;
	float val;
	int loop;
	char line_buff[20];
	char Format[80];
	char pad;
	int point, frac_count;
	int count;
	int int_part;
	int	where_x,
	where_y,
	x,
	y;

	pad = ' ';
	point = 0;
	frac_count = 0 ;

	getyx(stdscr, where_y, where_x);
	standout();

	for (loop = 0; loop < field_width; loop++)
	  printw(" ");

	move(where_y, where_x);
	refresh();

	sprintf(Format, "%%%d.%df", field_width, places);
	printw(Format, Default);
	move(where_y, where_x);
	refresh();
	for (loop = 0; loop <= field_width; loop++)
	    line_buff[loop] = 0;

	count = 0;
	int_part = field_width - places - 1;
	while (1)
	{
	  if (!point && count == int_part)
	    {
		printw(".");
		line_buff[count++] = '.';
		point++;
		continue;
	    }
	    refresh();

	    c = (getch() & 0x7f);
	    switch(c)
	    {
#ifdef ABORT_CHAR
	    case ABORT_CHAR:
		clear();
		standend();
		mvprintw(0, 0, "Program aborted at your request...");
		move(LINES -1 , 0);
		refresh();
		nl();
		endwin();
		exit(1);
		break;
#endif ABORT_CHAR

	    case '\r':
		if (count && line_buff[count - 1] != '-')
		{
		    sscanf(line_buff, "%f", &val);
		    f_clean_up(where_y, where_x, Format, val);
		    return(val);
		}
		else
		{
		    f_clean_up(where_y, where_x, Format, Default);
		    return(Default);
		}
		break;
	    case '\030':
		move(where_y, where_x);
		for (loop = 0; loop < field_width; loop++)
		    line_buff[loop] = 0;
		count = frac_count = point = 0;
		printw(Format, Default);
		move(where_y, where_x);
		break;
	    case '.':
		if (!point)
		{
		    if (!count)
		    {
			for (loop = 0; loop < field_width; loop++)
			    printw("%c", pad);
			move(where_y, where_x);
			for (loop = 0; loop < field_width; loop++)
			    line_buff[loop] = 0;
		    }
		    printw(".");
		    line_buff[count++] = '.';
		    point++;
		    break;
		}
	    case '\021':
	    case '\023':
		break;
	    default:
		if (c == erase_char && count)
		{
		    getyx(stdscr, y, x);
		    move(y, x - 1);
		    printw("%c", pad);
		    move(y, x - 1);
		    if (point)
		    {
			if (frac_count)
			    frac_count--;
			else
			    point--;
		    }
		    line_buff[--count] = 0;
		    break;
		}

		if (!count && c == '-')
		{
		    for (loop = 0; loop < field_width; loop++)
			printw("%c", pad);
		    move(where_y, where_x);
		    for (loop = 0; loop < field_width; loop++)
		        line_buff[loop] = 0;

		    line_buff[count++] = (char) c;
		    printw("-");
		    break;
		}

		if (isdigit(c) && count < field_width && frac_count < places)
		{
		    if (!count)
		    {
			for (loop = 0; loop < field_width; loop++)
			    printw("%c", pad);
			move(where_y, where_x);
			for (loop = 0; loop < field_width; loop++)
			    line_buff[loop] = 0;
		    }
		    printw("%c", c);
		    line_buff[count++] = (char) c;
		    if (point)
			frac_count++;
		}
		else
		    fprintf(stderr, "%c", '\007');
	    }
	}
}

void f_clean_up(int where_y, int where_x, char *Format, float val)
{

    standend();
    move(where_y, where_x);
    printw(Format, val);

    refresh();
}
