/****************************************************************/
/*                                                              */
/*                                                              */
/*                            RDBInit                           */
/*                                                              */
/*              Initialize A BrewCalc Recipe Data Base          */
/*                                                              */
/*                                                              */
/****************************************************************/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*          Copyright (C) 1995   Richard J. Procassini          */
/*                                                              */
/*             (See file 'rdbinit.h' for warranty              */
/*               and redistribution information.)               */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*  Include Files  */
#include <stdio.h>

#include "rdbinit.h"

/****************************************************************/


void main(void)
/****************************************************************/
/*  Program RDBInit initializes a recipe data base binary       */
/*  for use by BrewCalc.                                        */
/****************************************************************/
{
    int error;
    int i;
    int j;
    int num_recipes;
    FILE *file_pointer;

    /* Initialize some variables. */
    num_recipes = 1;
    
    /* Open the recipe data base binary file. */
    file_pointer = fopen("recipes.rdb", "w");
    if (file_pointer == NULL)
    {
	fprintf(stderr, "RDBInit: Open of 'recipes.rdb' failed!\n");
	exit(1);
    }
    
    /* Initialize the first entry in the recipe data base. */
    for (i = 0; i < NAMESIZE; i++)
    {
	recipe_data_base.name[i] = 0;
    }
    recipe_data_base.name[0] = '(';
    recipe_data_base.name[1] = 'N';
    recipe_data_base.name[2] = 'O';
    recipe_data_base.name[3] = 'N';
    recipe_data_base.name[4] = 'E';
    recipe_data_base.name[5] = ')';
    for (i = 0; i < MAX_NUM_MALTS; i++)
    {
	for (j = 0; j < NAMESIZE; j++)
	{
	    recipe_data_base.malts[i].name[j] = 0;
	}
	recipe_data_base.malts[i].gravity = 0;
	recipe_data_base.malts[i].color = 0;
	recipe_data_base.malts[i].converted = 0;
	recipe_data_base.malt_amounts[i] = 0;
	recipe_data_base.malt_colors[i] = 0;
	recipe_data_base.malt_gravities[i] = 0;
	recipe_data_base.malt_units[i] = 0;
    }
    for (i = 0; i < MAX_NUM_HOPS; i++)
    {
	for (j = 0; j < NAMESIZE; j++)
	{
	    recipe_data_base.hops[i].name[j] = 0;
	}
	recipe_data_base.hops[i].alpha_acid_percentage = 0;
	recipe_data_base.hop_amounts[i] = 0;
	recipe_data_base.hop_times[i] = 0;
	recipe_data_base.hop_IBUs[i] = 0;
	recipe_data_base.hop_units[i] = 0;
    }
    recipe_data_base.style = 0;
    recipe_data_base.total_volume = 0;
    recipe_data_base.total_volume_units = 0;
    recipe_data_base.boil_volume = 0;
    recipe_data_base.boil_volume_units = 0;
    recipe_data_base.num_malts = 0;
    recipe_data_base.num_hops = 0;
    recipe_data_base.extraction_efficiency = 0;
    recipe_data_base.apparent_attenuation = 0;
    recipe_data_base.real_attenuation = 0;
    recipe_data_base.original_gravity = 0;
    recipe_data_base.final_gravity = 0;
    recipe_data_base.alcohol_by_volume = 0;
    recipe_data_base.color = 0;
    recipe_data_base.IBUs = 0;
    
    /* Write the number of recipes to the recipe data base binary file. */
    error = 0;
    error = fwrite(&num_recipes, sizeof(char), sizeof(int),
		  file_pointer);
    if (error != sizeof(int))
    {
	fprintf(stderr, "RDBInit: Error writing the variable\n");
	fprintf(stderr, "\t num_recipes to 'recipes.rdb'!\n");
	exit(1);
    }
    
    /* Read the existing entries in the recipe data base. */
    error = 0;
    error = fwrite(&recipe_data_base, sizeof(char), num_recipes*sizeof(beer),
		  file_pointer);
    if (error != num_recipes*sizeof(beer))
    {
	fprintf(stderr, "RDBInit: Error writing %d\n", num_recipes);
	fprintf(stderr, "\t recipe(s) to 'recipes.rdb'!\n");
	exit(1);
    }
    
    /* Close the recipe data base binary file. */
    fclose(file_pointer);
    
    fprintf(stderr, "\n\t****  Recipe Data Base 'recipes.rdb' Written  ****\n\n");
    
}  /* End main */
