SUBROUTINE MySolver(Model, Solver, dt, Transient)
  Use DefUtils
  IMPLICIT NONE
  TYPE(Solver_t) :: Solver
  TYPE(Model_t) :: Model
  REAL(KIND=dp) :: dt
  LOGICAL :: Transient

  ! Read vector from Simulation-block:
  !------------------------------------
  REAL(KIND=dp), POINTER :: MyVector(:,:)
  LOGICAL :: Found
  CALL GetConstRealArray(Solver % Values, MyVector, "MyVector", Found)
  IF(.NOT.Found) CALL Fatal("MySolver", "Unable to find MyVector")
  PRINT *, "MyVector =", MyVector(:,1)

END SUBROUTINE MySolver
