/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the mingw-w64 runtime package.
 * No warranty is given; refer to the file DISCLAIMER.PD within this package.
 */

#ifndef _SENSORS_H_
#define _SENSORS_H_

#include "propkeydef.h"

DEFINE_GUID(SENSOR_PROPERTY_COMMON_GUID,                      0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_TYPE,                      0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 2);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_STATE,                     0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 3);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_PERSISTENT_UNIQUE_ID,      0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 5);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_MANUFACTURER,              0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 6);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_MODEL,                     0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 7);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_SERIAL_NUMBER,             0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 8);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_FRIENDLY_NAME,             0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 9);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_DESCRIPTION,               0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 10);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_CONNECTION_TYPE,           0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 11);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_MIN_REPORT_INTERVAL,       0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 12);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_CURRENT_REPORT_INTERVAL,   0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 13);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_CHANGE_SENSITIVITY,        0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 14);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_DEVICE_PATH,               0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 15);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_LIGHT_RESPONSE_CURVE,      0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 16);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_ACCURACY,                  0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 17);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_RESOLUTION,                0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 18);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_LOCATION_DESIRED_ACCURACY, 0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 19);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_RANGE_MINIMUM,             0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 20);
DEFINE_PROPERTYKEY(SENSOR_PROPERTY_RANGE_MAXIMUM,             0x7f8383ec, 0xd3ec, 0x495c, 0xa8, 0xcf, 0xb8, 0xbb, 0xe8, 0x5c, 0x29, 0x20, 21);

DEFINE_GUID(SENSOR_TYPE_ACCELEROMETER_1D, 0xc04d2387, 0x7340, 0x4cc2, 0x99, 0x1e, 0x3b, 0x18, 0xcb, 0x8e, 0xf2, 0xf4);
DEFINE_GUID(SENSOR_TYPE_ACCELEROMETER_2D, 0xb2c517a8, 0xf6b5, 0x4ba6, 0xa4, 0x23, 0x5D, 0xf5, 0x60, 0xb4, 0xcc, 0x07);
DEFINE_GUID(SENSOR_TYPE_ACCELEROMETER_3D, 0xc2fb0f5f, 0xe2d2, 0x4c78, 0xbc, 0xd0, 0x35, 0x2a, 0x95, 0x82, 0x81, 0x9d);
DEFINE_GUID(SENSOR_TYPE_MOTION_DETECTOR,  0x5c7c1a12, 0x30a5, 0x43b9, 0xa4, 0xb2, 0xcf, 0x09, 0xec, 0x5b, 0x7b, 0xe8);
DEFINE_GUID(SENSOR_TYPE_GYROMETER_1D,     0xfa088734, 0xf552, 0x4584, 0x83, 0x24, 0xed, 0xfa, 0xf6, 0x49, 0x65, 0x2c);
DEFINE_GUID(SENSOR_TYPE_GYROMETER_2D,     0x31ef4f83, 0x919b, 0x48bF, 0x8d, 0xe0, 0x5d, 0x7a, 0x9d, 0x24, 0x05, 0x56);
DEFINE_GUID(SENSOR_TYPE_GYROMETER_3D,     0x09485F5a, 0x759e, 0x42c2, 0xbd, 0x4b, 0xa3, 0x49, 0xb7, 0x5c, 0x86, 0x43);
DEFINE_GUID(SENSOR_TYPE_SPEEDOMETER,      0x6bd73c1f, 0x0bb4, 0x4310, 0x81, 0xb2, 0xdf, 0xc1, 0x8a, 0x52, 0xbf, 0x94);

DEFINE_GUID(SENSOR_DATA_TYPE_MOTION_GUID,                                              0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_ACCELERATION_X_G,                                  0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 2);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_ACCELERATION_Y_G,                                  0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 3);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_ACCELERATION_Z_G,                                  0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 4);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_ANGULAR_ACCELERATION_X_DEGREES_PER_SECOND_SQUARED, 0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 5);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_ANGULAR_ACCELERATION_Y_DEGREES_PER_SECOND_SQUARED, 0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 6);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_ANGULAR_ACCELERATION_Z_DEGREES_PER_SECOND_SQUARED, 0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 7);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_SPEED_METERS_PER_SECOND,                           0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 8);
DEFINE_PROPERTYKEY(SENSOR_DATA_TYPE_MOTION_STATE,                                      0x3f8a69a2, 0x7c5, 0x4e48, 0xa9, 0x65, 0xcd, 0x79, 0x7a, 0xab, 0x56, 0xd5, 9);

#endif
