
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>

#include "fdefs.h"

#include "fvars_ext.com"

int gx_drawaxes(xstr,ystr,zstr,fmat,pal)
char *xstr,*ystr,*zstr;
float fmat[][3];
unsigned char pal[PALBUFSIZE][3];
{
	int err_ret;
	long xsize,ysize,zsize;
	short ir,ig,ib;
	long ir1,ig1,ib1,ir21,ig21,ib21;
	long dist,maxdist;
	Colorindex icol;
	Coord lrsize,btsize;
	Coord rnear,rfar,ttz;
	int rgbflag;
	float sx,sy,sz;
	float scl,rval;
	int i;

/* if color map mode, find the color geometrically furthest from */
/* the background color						 */
	ir1 = (long)pal[0][0];
	ig1 = (long)pal[0][1];
	ib1 = (long)pal[0][2];
	maxdist = 0;
	for(i=1; i<PALBUFSIZE; i++){
		ir21 = (long)pal[i][0] - ir1;
		ig21 = (long)pal[i][1] - ig1;
		ib21 = (long)pal[i][2] - ib1;
		dist = (ir21*ir21) + (ig21*ig21) + (ib21*ib21);
		if(dist > maxdist){
			maxdist = dist;
			icol = i + LUTOFFSET;
		}
	}

	gx_scrsize(&xsize,&ysize,&zsize);
	rgbflag = (zsize == 3);

	ir = 255 - (long)fmat[BKC][0];
	ig = 255 - (long)fmat[BKC][1];
	ib = 255 - (long)fmat[BKC][2];

	lrsize = 1.33333333;
	btsize = 1.0;

	rnear = 5.0;
	rfar = 100.0;
	ttz = -6.5;
	loadmatrix(idmatrix);
	mmode(MVIEWING);
	window(-lrsize,lrsize,-btsize,btsize,rnear,rfar);

	loadmatrix(idmatrix);
	translate(0.0,0.0,ttz);

	lsetdepth(0, 0x7fffff);

/* uncomment this line if Z-buffered axes aren't desired */
/*	zbuffer(FALSE); */

	scl = 1.2;
	sx = scl * fmat[SCA][0];
	sy = scl * fmat[SCA][1];
	sz = scl * fmat[SCA][2];
	sx = max(sx,scl);
	sy = max(sy,scl);
	sz = max(sz,scl);

	if(rgbflag)
		RGBcolor(ir,ig,ib);
	else
		color(icol);

	pushmatrix();
	translate(fmat[TRA][0],fmat[TRA][1],fmat[TRA][2]);
	rot(fmat[ROT][2], 'z');
	rot(fmat[ROT][1], 'y');
	rot(fmat[ROT][0], 'x');
	scale(sx,sy,sz);

	rval = 0.6;
	linewidth(2);
	move(0.0,0.0,0.0);	
	draw(rval,0.0,0.0);
	cmov(rval,0.0,0.0);
	charstr(xstr);

	move(0.0,0.0,0.0);	
	draw(0.0,rval,0.0);
	cmov(0.0,rval,0.0);
	charstr(ystr);

	move(0.0,0.0,0.0);	
	draw(0.0,0.0,rval);
	cmov(0.0,0.0,rval);
	charstr(zstr);

	popmatrix();

	return(0);
}
