/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: profSupport.c,v 1.3 1993/07/21 21:57:39 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>

#include "netdata.h"
#include "data.h"
#include "net.h"
#include "profUI.h"


#define        ABS(x)  ((x)>0) ? (x): (-1.0*(x))



extern GC invGC;
extern Display *myDpy;


static int start_x, end_x, start_y, end_y;



ProfileSetup(rootWidget)
Widget rootWidget;
{
	NetRegisterModule("Profile",NETCOL,
			ProfNew,(caddr_t)0,
			ProfChange,(caddr_t)0,
			ProfDestroy,(caddr_t)0);

	NetRegisterModule("Profile",NETDOL,
			ProfNewDOL,(caddr_t)0,
			ProfChangeDOL,(caddr_t)0,
			ProfDestroy,(caddr_t)0);

	ProfileInit(rootWidget);
}
/*EJB*/


static void
ProfRubberBox(w)
	Widget w;
{
	int x, y;
	unsigned int width, height;

	if (start_x <= end_x)
	{
		x = start_x;
		width = end_x - start_x;
	}
	else
	{
		x = end_x;
		width = start_x - end_x;
	}
	if (start_y <= end_y)
	{
		y = start_y;
		height = end_y - start_y;
	}
	else
	{
		y = end_y;
		height = start_y - end_y;
	}
	XDrawRectangle(myDpy, XtWindow(w), invGC, x, y, width, height);
}


void CBInitProfBox(w, data, event)
	Widget w;
	caddr_t data;
	XEvent *event;
{
        XButtonPressedEvent *BuEvent = (XButtonPressedEvent *)event;
	Profile *profile = (Profile *)data;

	start_x = BuEvent->x;
	start_y = BuEvent->y;
	end_x = start_x;
	end_y = start_y;
	ProfRubberBox(w);
}


void
CBProfBox(w, data, event)
	Widget w;
	caddr_t data;
	XEvent *event;
{
	XPointerMovedEvent *MoEvent = (XPointerMovedEvent *)event;
	Profile *profile = (Profile *)data;

	if ((MoEvent->x != end_x)||(MoEvent->y != end_y))
	{
		ProfRubberBox(w);
		end_x = MoEvent->x;
		end_y = MoEvent->y;
		ProfRubberBox(w);
	}
}


void
CBDoneProfBox(w, data, event)
	Widget w;
	caddr_t data;
	XEvent *event;
{
        XButtonReleasedEvent *BuEvent = (XButtonReleasedEvent *)event;
	Profile *profile = (Profile *)data;
	int tmp, win_x, win_y;
	XWindowAttributes attr;
	int x1, y1, x2, y2;
	int nx1, ny1, nx2, ny2;
	int gwidth, gheight, dwidth, dheight;

	win_x = BuEvent->x;
	win_y = BuEvent->y;

	if (start_x > end_x)
	{
		tmp = start_x;
		start_x = end_x;
		end_x = tmp;
	}
	if (start_y > end_y)
	{
		tmp = start_y;
		start_y = end_y;
		end_y = tmp;
	}

	ProfRubberBox(w);

	if ((start_x == end_x)||(start_y == end_y))
	{
		return;
	}

	XGetWindowAttributes(myDpy, XtWindow(w), &attr);

	if (profile->selBegX <= profile->selEndX) 
	{
		x1 = profile->selBegX;
		y1 = profile->selBegY;
		x2 = profile->selEndX;
		y2 = profile->selEndY;
	}
	else
	{
		x1 = profile->selEndX;
		y1 = profile->selEndY;
		x2 = profile->selBegX;
		y2 = profile->selBegY;
	}
	gwidth = attr.width - 60 /*left*/ - 70 /*right */;
	gheight = attr.height - 40 /*bottom*/ - 20 /*top*/;
	dwidth = ABS(x2 - x1);
	dheight = ABS(y2 - y1);

	if (start_x < 70)
	{
		start_x = 70;
	}
	if (end_x > (attr.width - 60))
	{
		end_x = attr.width - 60;
	}
	nx1 = x1 + ((start_x - 70) * dwidth / gwidth);
	ny1 = y1 + ((start_x - 70) * (y2 - y1) / gwidth);
	nx2 = x1 + ((end_x - 70) * dwidth / gwidth);
	ny2 = y1 + ((end_x - 70) * (y2 - y1) / gwidth);

	if ((nx1 > x2)||(nx2 < x1))
	{
		return;
	}

	if (profile->data->type == D_FLOAT)
	  {
	    float range;
	    range = profile->maxValue.f - profile->minValue.f;
	    profile->maxValue.f = ((gheight - start_y + 20) * range /
				   gheight ) +	profile->minValue.f;
	    profile->minValue.f = ((gheight - end_y + 20) * range / gheight) +
		profile->minValue.f;
	  }
	else
	  {
	    int range = profile->maxValue.i - profile->minValue.i;
	    profile->maxValue.i = ((gheight - start_y + 20) * range /
				   gheight ) +	profile->minValue.i;
	    profile->minValue.i = ((gheight - end_y + 20) * range / gheight) +
		profile->minValue.i;
	  }
	profile->selBegX = nx1;
	profile->selBegY = ny1;
	profile->selEndX = nx2;
	profile->selEndY = ny2;

	XClearArea(myDpy, XtWindow(w), 0, 0, 1, 1, True);
}

