(*^

::[paletteColors = 128; 
	fontset = title, "Geneva", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Geneva", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Geneva", 14, L2, center, bold, nohscroll;
	fontset = section, "Geneva", 14, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Geneva", 12, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Geneva", 10, L2, bold, nohscroll, whiteBox;
	fontset = text, "Geneva", 12, L2, nohscroll;
	fontset = smalltext, "Geneva", 10, L2, nohscroll;
	fontset = input, "Courier", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R65535, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Geneva", 10, L2, italic, B65535, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Geneva", 10, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "New York", 12, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
The Collatz Problem
:[font = text; inactive; ]
This example comes from subsection 9.3.2
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

;[s]
3:0,0;67,1;93,0;470,-1;
2:2,14,10,Geneva,0,10,0,0,0;1,14,10,Geneva,2,10,0,0,0;
:[font = section; inactive; startGroup; Cclosed; ]
Examples
:[font = subsection; inactive; startGroup; Cclosed; ]
The Length the Collatz Sequence
:[font = input; endGroup; ]
length[ 27 ]
:[font = subsection; inactive; startGroup; Cclosed; ]
Finding Maximal Lengths
:[font = text; inactive; ]
The following calculation is infinite. It will not stop by itself. To stop it, interrupt Mathematica.
;[s]
3:0,0;89,1;100,0;102,-1;
2:2,17,12,Geneva,0,12,0,0,0;1,17,12,Geneva,2,12,0,0,0;
:[font = input; endGroup; ]
max[1]
:[font = subsection; inactive; startGroup; Cclosed; ]
Plotting Values
:[font = text; inactive; ]
This plot is from page 207
:[font = input; ]
vals = Array[length, 300];
:[font = input; endGroup; endGroup; ]
ListPlot[vals, PlotRange->All];
:[font = section; inactive; startGroup; Cclosed; ]
Implementation
:[font = input; initialization; ]
*)
length[n_Integer?Positive] :=
	Block[{i=1, m=n}, While[m != 1, m = If[OddQ[m], 3m+1, m/2]; i++];i ]
length[_] = 0
(*
:[font = input; initialization; endGroup; ]
*)
max[low_] :=
	Block[{m=0, n=0, i=low, j},
		While[ True,
			j = length[i];
			If[j > m, m = j; n = i; Print["length[", n, "] = ", m] ];
			i++;
			If[ Mod[i, 100] == 0, Print["i = ", i] ]
		]
	]

(*
^*)