C
C $Header: /hdf/hdf/v3.2/test/RCS/tdfsd_ntF.f,v 1.1 1992/02/29 22:53:38 mfolk beta $
C
C $Log: tdfsd_ntF.f,v $
c Revision 1.1  1992/02/29  22:53:38  mfolk
c Initial revision
c
C

      program ntcheckF
C
C
C  Program to test writing SDSs with different types of data and
C  scales and max/min values.
C
C  Input file:  none
C  Output files: o0, o1, ... o6
C

      integer dsgdata, dsadata, dssdims, dssmaxm, dsgmaxm, dssnt
      integer dssdisc, dsgdisc

      real*4 f32(10,10), tf32(10,10)
      real*4 f32scale(10), tf32scale(10)
      real*4 f32max, f32min, tf32max, tf32min

      character i8(10,10), ti8(10,10)
      character i8scale(10), ti8scale(10), i8max, i8min
      character ti8max, ti8min

      integer*2 i16(10,10), ti16(10,10)
      integer*2 i16scale(10), ti16scale(10), i16max, i16min
      integer*2 ti16max, ti16min

      integer*4 i32(10,10), ti32(10,10)
      integer*4 i32scale(10), ti32scale(10), i32max, i32min
      integer*4 ti32max, ti32min

      integer i, j, err, err1, err2, err3
      integer rank, dims(2)
      integer number_failed
      integer DFNT_FLOAT32, DFNT_INT8, DFNT_INT16, DFNT_INT32

      f32max = 40.0
      f32min = 0.0
      i8max = char(127)
C NOTE: the next assignment will not work in some Fortran implementations.
      i8min = char(-128)
      i16max = 1200
      i16min = -1200
      i32max = 99999999
      i32min = -999999999
      
      rank = 2
      dims(1) = 10
      dims(2) = 10
      number_failed = 0
      DFNT_FLOAT32 = 5
      DFNT_INT8 = 20
      DFNT_INT16 = 22
      DFNT_INT32 = 24
      
      print *, 'Creating arrays...'
      
      do 110 i=1,10
          do 100 j=1,10
            f32(i,j) = (i * 40) + j
            i8(i,j) = char( (i * 10) + j )
            i16(i,j) = (i * 3000) + j
            i32(i,j) = (i * 20) + j
  100     continue
          f32scale(i) = (i * 40) + j
          i8scale(i) = char((i * 10) + j)
      	  i16scale(i) = (i * 3000) + j
      	  i32scale(i) = (i * 20) + j
  110 continue

      err1 = dssdims(rank, dims)
      
C
C  Writing dimscale, max/min, and arrays to a single file 
C
      print *, 'Writing arrays to single file...'

      err  = dssnt(DFNT_FLOAT32)
      err1 = dssdisc(1, 10, f32scale)
      err2 = dssmaxm(f32max, f32min)
      err3 = dsadata('o.hdf', rank, dims, f32)
      call errchkio(err1, err2, err3, number_failed, 'float32 write')

      err  = dssnt(DFNT_INT8)
      err1 = dssdisc(1, 10, i8scale)
      err2 = dssmaxm(i8max, i8min)
      err3 = dsadata('o.hdf', rank, dims, i8)
      call errchkio(err1, err2, err3, number_failed, 'int8 write')
      
      
      err  = dssnt(DFNT_INT16)
      err1 = dssdisc(1, 10, i16scale)
      err2 = dssmaxm(i16max, i16min)
      err3 = dsadata('o.hdf', rank, dims, i16)
      call errchkio(err1, err2, err3, number_failed, 'int16 write')
      
      err  = dssnt(DFNT_INT32)
      err1 = dssdisc(1, 10, i32scale)
      err2 = dssmaxm(i32max, i32min)
      err3 = dsadata('o.hdf', rank, dims, i32)
      call errchkio(err1, err2, err3, number_failed, 'int32 write')
      
C
C  Reading back dimscales, max/min, and arrays from single file
C
      err1 = dsgdata('o.hdf', rank, dims, tf32)
      err2 = dsgdisc(1, 10, tf32scale)
      err3 = dsgmaxm(tf32max, tf32min)
      call errchkio(err1, err2, err3, number_failed, 'float32 read')
      
      err1 = dsgdata('o.hdf', rank, dims, ti8)
      err2 = dsgdisc(1, 10, ti8scale)
      err3 = dsgmaxm(ti8max, ti8min)
      call errchkio(err1, err2, err3, number_failed, 'int8 read')
      
      err1 = dsgdata('o.hdf', rank, dims, ti16)
      err2 = dsgdisc(1, 10, ti16scale)
      err3 = dsgmaxm(ti16max, ti16min)
      call errchkio(err1, err2, err3, number_failed, 'int16 read')
      
      err1 = dsgdata('o.hdf', rank, dims, ti32)
      err2 = dsgdisc(1, 10, ti32scale)
      err3 = dsgmaxm(ti32max, ti32min)
      call errchkio(err1, err2, err3, number_failed, 'int32 read')
      
C
C  Checking dimscales, max/min and arrays from single file
C
      print *, 'Checking dimscales, max/min & arrays from single file'

C  float32
      err1 = 0
      err2 = 0
      err3 = 0
      do 1010 i=1,10
         do 1000 j=1,10
           if (f32(i,j) .ne. tf32(i,j)) err1 = 1
 1000    continue
         if (f32scale(i) .ne. tf32scale(i)) err2 = 1
 1010 continue

      if ((f32max .ne. tf32max) .or. (f32min .ne. tf32min)) err3 = 1
      call errchkarr(err1, err2, err3, number_failed, 'float32')

C  int8
      err1 = 0
      err2 = 0
      err3 = 0
      do 1110 i=1,10
         do 1100 j=1,10
           if (i8(i,j) .ne. ti8(i,j)) err = 1
 1100    continue
         if (i8scale(i) .ne. ti8scale(i)) err2 = 1
 1110 continue

      if ((i8max .ne. ti8max) .or. (i8min .ne. ti8min)) err3 = 1
      call errchkarr(err1, err2, err3, number_failed, 'int8')

C  int16
      do 1210 i=1,10
         do 1200 j=1,10
           if (i16(i,j) .ne. ti16(i,j)) err = 1
 1200    continue
         if (i16scale(i) .ne. ti16scale(i)) err2 = 1
 1210 continue

      if ((i16max .ne. ti16max) .or. (i16min .ne. ti16min)) err3 = 1
      call errchkarr(err1, err2, err3, number_failed, 'int16')

C  int32
      do 1310 i=1,10
         do 1300 j=1,10
           if (i32(i,j) .ne. ti32(i,j)) err = 1
 1300    continue
      	 if (i32scale(i) .ne. ti32scale(i)) err2 = 1
 1310 continue

      if ((i32max .ne. ti32max) .or. (i32min .ne. ti32min)) err3 = 1
      call errchkarr(err1, err2, err3, number_failed, 'int32')
C
C  Sum up
C
      
      if (number_failed .gt. 0 ) then
          print *, '        >>> ', number_failed, ' TESTS FAILED <<<'
      else
          print *, '        >>> ALL TESTS PASSED <<<'
      endif

      stop
      end


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     SUBROUTINE errchkio
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      subroutine errchkio(err1, err2, err3, num_fail, msg)
      integer err1, err2, err3, num_fail
      character*(*)  msg

      integer FAIL

      FAIL = -1

      if (err1.eq.FAIL .or. err2.eq.FAIL .or. err3.eq.FAIL) then
          num_fail = num_fail + 1
          print *
          print *,'>>> Test failed for ',msg, ' <<<'
          print *, '  err1=',err1, '   err2=',err2, '   err3=',err3
      else
          print *,'Test passed for ', msg
      endif
      print *

      return
      end

      
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     SUBROUTINE errchkarr
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      subroutine errchkarr(err1, err2, err3, num_fail, type)
      integer err1, err2, err3, num_fail
      character*(*)  type
      
      print *
      if (err1 .eq. 1) then
        print *, '>>> Test failed for ', type, ' array' 
      else
        print *, 'Test passed for ', type, ' array'
      endif

      if (err2 .eq. 1) then
        print *, '>>> Test failed for ',type, ' scales.'
      else
        print *, 'Test passed for ', type, ' scales.'
      endif

      if (err3 .eq. 1) then
        print *, '>>> Test failed for ', type, ' max/min.'
      else
        print *, 'Test passed for ', type, ' max/min.'
      endif

      print *

      return
      end

