/* misc.c -- contains some miscellaneous functions */
#include "he.h"

struct {
    char *str;
    int key;
} he_optTab[] =
{
{"readonly", HE_RDONLY},
{"all", HE_ALL},
{"backup", HE_BACKUP},
{"batch", HE_BATCH},
{"help", HE_HELP},
{"longout", HE_LONGOUT},
{"nobackup", HE_NOBACKUP},
{"remote", HE_REMOTE},
{"verbose", HE_VERBOSE},
{"position", HE_POSITION},
{"expansion", HE_EXPANSION},
{"large", HE_LARGE},
{"offset", HE_OFFSET},
{"ascii", HE_ASCII},
{"octal", HE_OCTAL},
{"hexadecimal", HE_HEX},
{"decimal", HE_DECIMAL},
{"float", HE_FLOAT},
{"dimensions", HE_DIMS},
{"image", HE_IMAGE},
{"palette", HE_PALETTE},
{"raster", HE_RASTER},
{"rle", HE_RLE},
{"compress", HE_RLE},
{"imcomp", HE_IMCOMP},
{"group", HE_DOGROUP},
{"file", HE_FILE},
{"keep", HE_KEEP},
{"length", HE_LENGTH},
{"attachto", HE_ATTACHTO},
{"label", HE_LABEL},
{"descriptor", HE_DESCRIPTOR},
{"editor", HE_EDITOR},
{NULL, 0},
};

int findOpt(word)
    char *word;
{
    int len;
    int found = -1;
    register int i;

    len = strlen(word);

    for (i = 0; he_optTab[i].str; i++)
	if (!strncmp(he_optTab[i].str, word, len))
	{
	    /* exact match */
	    if (strlen(he_optTab[i].str) == len)
		return he_optTab[i].key;

	    if (found < 0)
		found = i;
	    else
		return HE_AMBIG;
	}

    if (found < 0)
	return HE_NOTFOUND;

    return he_optTab[found].key;
}

char * catStr(s, s1)
    register char *s, *s1;
{
    char *t;

    t = (char *) malloc(strlen(s) + strlen(s1) + 1);
    strcpy(t, s);
    strcat(t, s1);
    return t;
}

char *copyStr(s)
    register char *s;
{
    char *t;

    t = (char *) malloc(strlen(s) + 1);
    strcpy(t, s);
    return t;
}

int isGrp(tag)
    uint16 tag;
{
    switch(tag)
    {
    case DFTAG_RIG:
    case DFTAG_SDG:
	/* and other group tags */
	return 1;
    default:
	return 0;
    }
}

int HEquit(cmd)
    HE_CMD *cmd;
{
    if (cmd->argc > 1)
    {
	puts("quit");
	puts("\tQuits this application.");
	return HE_OK;
    }
    return quit(0);
}

int quit(status)
    int status;
{
    if (fileOpen())
    {
	if (closeFile(0) < 0)
	    return HE_FAIL;
    }
    return exit(status);
}

int HEhelp()
{
    return help();
}

int help()
{
    /* print some help informations */
    puts("Type <command> -help for usage of command");
    puts("e.g. \"open -help\" give help on the open command");
    puts("DO NOT just type the command and expect a help line");
    puts("Some commands line delete do not need any argument");
    puts("If you are just starting to learn, try this program on");
    puts("a file that is expendable");
    puts("");
    puts("List of commands:");
    puts("----------------");
    puts("open\tOpen hdf file");
    puts("close\tClose hdf file");
    puts("revert\tRevert to original file");
    puts("next\tGo to next element/group that satisfy predicate");
    puts("prev\tGo to previous...");
    puts("help\tThis");
    puts("info\tShow information about data");
    puts("dump\tDo binary display of data");
    puts("display\tDisplay image using ICR");
    puts("put\tPut data element as binary into raw file");
    puts("putr8\tPut r8 group into raw files");
    puts("getr8\tGet r8 group from raw files");
    puts("delete\tDelete an element/group");
    puts("write\tWrite data element/group to another hdf file");
    puts("annotate Annotate an element");
    puts("*Special Commands");
    puts("if\tConditional statement");
    puts("select\tLoop for each element");
    puts("alias\tSet/show aliases");
    puts("unalias");
    puts("wait\tMessage and wait for return");
    return HE_OK;
}

int HEwait(cmd)
    HE_CMD *cmd;
{
    int c;

    if (cmd->argv[1][0] == '-' && findOpt(cmd->argv[1] + 1) == HE_HELP)
    {
	puts("wait [<message>]");
	puts("\tPrints message and then wait for user to hit return");
	return HE_OK;
    }

    printf("%s\nReturn to continue.", cmd->argv[1]);
    do c = getchar();
    while (c != '\n');

    return HE_OK;
}

void deleteCmd(cmd)
    HE_CMD *cmd;
{
    register int i;

    if (cmd == NULL) return;
    if (cmd->next != NULL) deleteCmd(cmd->next);
    if (cmd->sub != NULL) deleteCmd(cmd->sub);
    for (i = 0; i < cmd->argc; i++)
	if (cmd->argv[i] != NULL) free(cmd->argv[i]);
    free(cmd);
}

int isAnnot(tag)
    uint16 tag;
{
    return (tag == DFTAG_DIL || tag == DFTAG_DIA);
}

/* end of misc.c */
