
C************************************************************
C
C Test program: tests speed writing float data in three ways:
C
C                  1. to HDF SDS, default conversion
C                  2. to HDF SDS, no conversion
C                  3. to raw file, no conversion
C
C Note: in DFSDsettype routine, parameter #3 (DFNTF_CRAY), should
C       be replaced when using other machines.  Currently, the
C       only allowable replacement is 0. (July 1990)
C
C
C Input files:  None.  The data is generated by the program.
C Output files: Three files, named by the user on the command line.
C
C*********************************************************** */


      program speedtst

      integer dssdims, dspdata, dsstype
      integer ret, i, j, x, y
      integer rank, dimsizes(2)
      integer DFNTF_CRAY, DFNT_FLOAT, DFO_FORTRAN
      real    data(1000,1000)
      integer time, tloc1, tloc2

      data DFNTF_CRAY/3/, DFNT_FLOAT/5/, DFO_FORTRAN/1/

      x = 1000
      y = 1000

      rank = 2
      dimsizes(1) = x
      dimsizes(2) = y

      do 110 i = 1, x
        do 100 j = 1, y
          data(i,j) = 10.0
  100   continue
  110 continue

C Write out scientific data set -- default conversion
      tloc1 = time(0)
      ret = dssdims(rank, dimsizes)
      ret = dspdata('fa',rank, dimsizes, data)
      tloc2 = time(0)
      print *,  'Default conversion:    ', tloc2-tloc1

C Write out scientific data set -- no conversions
      tloc1 = time(0)
      ret = dssdims(rank, dimsizes)
      ret = dsstype(DFNT_FLOAT, 0, DFNTF_CRAY,  DFO_FORTRAN)
      ret = dspdata('fb',rank, dimsizes, data)
      tloc2 = time(0)
      print *,  'No conversion:         ', tloc2-tloc1

C Write out raw data to a file
      tloc1 = time(0)
      open(unit=10, file='fc', form='UNFORMATTED')
      write(10)  data
      tloc2 = time(0)
      print *,  'Write raw binary:      ', tloc2-tloc1

      end

