/*****************************************************************
*
*  Program for creating an image and storing it in an HDF file
*
*
*  If "row order" is selected the image created, with it's palette,
*  should display as an increasingly dark gray scale going from top
*  to bottom, up to 256 rows, then repeating.  If "column order" is
*  chosen, this pattern will be transposed.
*
*  User supplies filename, height, width, compression, and whether
*  to store image in row or column order.
*
*****************************************************************/

#include <stdio.h>
#include <ctype.h>
#define TRUE    1
#define FALSE   0
char *malloc();

main(argc,argv)
int argc;
char *argv[];
{
	int	      Height, Width;
	int       Color;
	int       Compress;
	int       ReturnCode;
	int       Index1, Index2, Index3;
	char      Image[307200];
	char      Palette[768];
	char      Order='R';
	char      Filename[65];

    if (argc != 6) {
        printf("Usage: %s outfile height width compress order\n", argv[0]);
        printf("\tHeight Value: 1-480\n");
        printf("\tWidth Value: 1-640\n");
        printf("\tCompression Code: 0=None, 11=Run Length, 12=IMCOMP\n");
        printf("\tOrder: R (row major), C (column major)\n");
        exit(1);
    }
	printf("HDFTEST - Generate HDF Test File\n");

    strcpy(Filename, argv[1]);
    Height = atoi(argv[2]);
    Width  = atoi(argv[3]);
    

    if (Height>480)  {
        printf( "Error in command line\n\tHeight Value: 1-480\n");
        exit(1);
    }
    if (Width>640)  {
        printf( "Error in command line\n\tWidth Value: 1-640\n");
        exit(1);
    }


    Compress = atoi(argv[4]);
    if ( (Compress != 0) && (Compress!=11) && (Compress!=12) ) { 
        printf( "Error in command line:\n");
        printf("\tCompression Code: 0=None, 11=Run Length, 12=IMCOMP\n");
        exit(1);
    }

    Order = argv[5][0];
    if ((Order=='C') || (Order == 'c')){
       for (Index1=1; Index1<Height; Index1++) {
           Color=0;
           for (Index2=1; Index2<Width; Index2++) {
               Image[((Index1*Width)-Width)+Index2] = (char) Color;
               Color = (Color+1) %256;
           }
       }
    } 
    else {
	for (Index1=1; Index1<Width; Index1++) {
            Color=0;
            for (Index2=1; Index2<Height; Index2++) {
                Image[((Index2*Width)-Width)+Index1] = (char) Color;
                Color = (Color+1) %256;
	    }
       }
    }

	Color=255;
	for (Index3=0; Index3 < 768; Index3 += 3) {
	   Palette[Index3+0]=(char) Color;
	   Palette[Index3+1]=(char) Color;
	   Palette[Index3+2]=(char) Color;
	   Color--;
	   if (Color < 0)
	      Color=255;
    }

	ReturnCode = DFR8setpalette(Palette);
	if (ReturnCode != 0) 
	   printf("Error calling DFR8setpalette\n");

	ReturnCode=DFR8putimage(Filename,Image,Width,Height,Compress);
	if (ReturnCode != 0) 
	   printf("Error calling DFR8putimage\n");

	printf("HDFTEST - Finished\n");
}

