/* Open a simple X window and display a given HDF image. */

#include <stdio.h>

char *pgm;
char *readhdf();

main(argc,argv)
	int argc;
	char *argv[];
{
  int palsize, x, y, imagenum, palnum, argindex;
  char pal[768];
  char *tmpstr;
  char *image, *imagefile, *palfile;

  /* init for those systems who don't do these things cleanly */
  imagenum = 0;
  palnum = 0;
  palfile = NULL;
  imagefile = NULL;

  /* parse command line */
  pgm = argv[0];
  argindex = 1;
  while (argindex < argc)
    {
      if (argv[argindex][0] == '-')
	{
	  switch (argv[argindex][1])
	    {
            case 'i':           /* Image File */
	      argindex++;
	      imagefile = argv[argindex];
	      break;
	    case 'n':		/* use image number */
	      argindex++;
	      tmpstr = argv[argindex];
	      imagenum = atoi(tmpstr);
	      break;
	    case 'p':		/* use palette number */
	      argindex++;
	      tmpstr = argv[argindex];
	      palnum = atoi(tmpstr);
	      break;
	    case 'f':		/* use palette file */
	      argindex++;
	      palfile = argv[argindex];
	    }
	}
      else
	{
	  usage();
	}
        argindex++;
    }      
  if (imagefile == NULL)
    usage();

  /* read HDF image */
  image = readhdf(imagefile,imagenum,&x,&y,pal,&palsize,palnum,palfile);

  /* display image and palette in an X window */
  xdis(image,pal,x,y,palsize);
}

usage()
{
  (void) fprintf(stderr,"Usage:\n");
   fprintf(stderr,"%s -i imagefile [-f palettefile] [-p palettenumber]\n",pgm);
   fprintf(stderr,"                      [-n imagenumber]\n");
   fprintf(stderr,"        imagefile argument MUST be present\n");
  exit(-1);
}
