#include "df.h"
#include <stdio.h>

#define MAX_ROW      10
#define MAX_COL      10
#define SIZE_ARRAY   (MAX_ROW * MAX_COL)

extern void randArray();
void findMaxMin();

main()
{
   int ret, i, j;
   int rank, inRank;
   int32 shape[2], inShape[2];
   float32 pressure[MAX_ROW][MAX_COL], inPressure[MAX_ROW][MAX_COL];
   float32 xscales[MAX_ROW], inXscales[MAX_ROW];
   float32 yscales[MAX_ROW], inYscales[MAX_COL];
   float32 maxpressure, inMaxpressure;
   float32 minpressure, inMinpressure;
   char *datalabel, inDatalabel[256];
   char *dataunit, inDataunit[256];
   char *datafmt, inDatafmt[256];
   char *dimlabels[2], inDimlabels[2][256];
   char *dimunits[2], inDimunits[2][256];
   char *dimfmts[2], inDimfmts[2][256];
   char *inDummy[256];
   
   rank=2;
   shape[0] = MAX_ROW;
   shape[1] = MAX_COL;
   
   datalabel = "Pressure 1";
   dataunit  = "Pascals";
   datafmt   = "E15.9";
   dimlabels[0] = "x";
   dimlabels[1] = "y";
   dimunits[0]  = "cm";
   dimunits[1]  = "cm";
   dimfmts[0]   = "F10.2";
   dimfmts[1]   = "F10.2";
   
   randArray(pressure, SIZE_ARRAY);
   findMaxMin(pressure, SIZE_ARRAY,&maxpressure,&minpressure);
   
   for(i=0;i<MAX_ROW;i++)
      xscales[i] = i;
   for(i=0;i<MAX_COL;i++)
      yscales[i] = i;
      
   ret = DFSDsetdims(rank, shape);
   printf("Return %d\n",ret);
   ret = DFSDsetdatastrs(datalabel, dataunit, datafmt, "");
   printf("Return %d\n", ret);
   ret = DFSDsetdimstrs(1, dimlabels[0], dimunits[0], dimfmts[0]);
   printf("Return %d\n",ret);
   ret = DFSDsetdimstrs(2, dimlabels[1], dimunits[1], dimfmts[1]);
   printf("Return %d\n",ret);
   ret = DFSDsetdimscale(1, shape[0], xscales);
   printf("Return %d\n", ret);
   ret = DFSDsetdimscale(2, shape[1], yscales);
   printf("Return %d\n",ret);
   ret = DFSDsetmaxmin(maxpressure, minpressure);
   printf("Return %d\n",ret);
   ret = DFSDputdata("testsds.df", 2, shape, pressure);
   printf("Return %d\n",ret);
   
   puts("Getting");
   ret = DFSDgetdims("testsds.df", &inRank, inShape, 2);
   printf("Return %d\n",ret);               
   ret = DFSDgetdata("testsds.df", 2, inShape, inPressure);
   printf("Return %d\n",ret);
   ret = DFSDgetdatastrs(inDatalabel, inDataunit, inDatafmt, inDummy);
   printf("Return %d\n",ret);
   ret = DFSDgetdimstrs(1, inDimlabels[0], inDimunits[0], inDimfmts[0]);
   printf("Return %d\n",ret);
   ret = DFSDgetdimstrs(2, inDimlabels[1], inDimunits[1], inDimfmts[1]);
   printf("Return %d\n",ret);
   ret = DFSDgetdimscale(1, inShape[0], inXscales);
   printf("Return %d\n",ret);
   ret = DFSDgetdimscale(2, inShape[1], inYscales);
   printf("Return %d\n",ret);
   ret = DFSDgetmaxmin(&inMaxpressure, &inMinpressure);
   printf("Return %d\n",ret);

   printf("Output rank is %d\nInput rank is %d\n",rank, inRank);
   
   printf("Output shape is %d, %d\nInput shape is %d, %d\n",
            shape[0],shape[1],inShape[0],inShape[1]);
            
   for(i=0;i<MAX_ROW;i++)
      for(j=0;j<MAX_COL;j++)
         if (pressure[i][j] != inPressure[i][j])
            printf("Array position %d, %d is different\n", i, j);

   printf("Output datalabel is %s\nInput datalabel is %s\n",datalabel,inDatalabel);
   printf("Output dataunit is %s\nInput dataunit is %s\n",dataunit,inDataunit);
   printf("Output datafmt is %s\nInput datafmt is %s\n",datafmt,inDatafmt);
   printf("Output dimlabels[0] is %s\nInput dimlabels[0] is %s\n",
            dimlabels[0], inDimlabels[0]);
   printf("Output dimunits[0] is %s\nInput dimunits[0] is %s\n",dimunits[0],inDimunits[0]);
   printf("Output dimfmts[0] is %s\nInput dimfmts[0] is %s\n",dimfmts[0],inDimfmts[0]);
   printf("Output dimlabels[1] is %s\nInput dimlabels[1] is %s\n",
            dimlabels[1], inDimlabels[1]);
   printf("Output dimunits[1] is %s\nInput dimunits[1] is %s\n",dimunits[1],inDimunits[1]);
   printf("Output dimfmts[1] is %s\nInput dimfmts[1] is %s\n",dimfmts[1],inDimfmts[1]);

   for(i=0;i<MAX_ROW;i++)
      if (xscales[i] != inXscales[i])
         printf("Xscales is different at position %d\n", i);
   for(i=0;i<MAX_COL;i++)
      if (yscales[i] != inYscales[i])
         printf("Yscales is different at position %d\n", i);

   printf("Output maxpressure is %e\nInput maxpressure is %e\n",
            maxpressure, inMaxpressure);
   printf("Output minpressure is %e\nInput minpressure is %e\n",
            minpressure, inMinpressure);
            
   puts("Check completed");
}

void
findMaxMin(data, size, max, min)
float32 data[];
int32 size;
float32 *max, *min;
{
   int32 i;
   *max = *min = data[0];
   for(i=1;i<size;i++) {
      if (*max < data[i]) *max = data[i];
      else if (*min > data[i]) *min = data[i];
   }
}

                     
