extern char *malloc(), *realloc();

# line 2 "interp.y"
/*************************************************************************
**
** interp.y - the following yacc code is used to parse the configuration
**		files.
**
*************************************************************************/

/*
 * $Log: interp.y,v $
 * Revision 1.6  1991/10/22  18:55:18  jplevyak
 * Allow comma in arguments.
 *
 * Revision 1.5  1991/10/17  12:28:42  jplevyak
 * Fixed bug with malloc of 1 to few bytes.
 *
 * Revision 1.4  1991/10/16  17:04:19  jplevyak
 * Added support of . in filenames.
 *
 * Revision 1.3  1991/10/16  16:22:46  jplevyak
 * Put ; after last entry in union decl (sgi requires it).
 *
 * Revision 1.2  1991/10/14  22:18:19  jefft
 * Fixed problem with path definition with AGENT statements
 *
 * Revision 1.1  1991/10/11  23:16:01  jefft
 * Initial revision
 *
 */


#include	<stdio.h>
#include	<string.h>


static char **add_list(list, cptr)
  char	**list, *cptr;
{
  int	i = 0;

  /* create the list if neccessary */
  if (list == NULL)
    if ((list = (char **)malloc(16 * sizeof (char*))) == NULL)  {
      fprintf(stderr, "Error: out of memory.\n");
      exit(-1);
      }
    else
      *list = NULL;

  /* add pointer to beginning of list */
  for(i=0; i<16; i+=1)
    if (*(list+i) == NULL)  {
      *(list+i) = cptr;
      *(list+i+1) = NULL;
      break;
      }

  return list;
}


# line 62 "interp.y"
typedef union  { int y_int; char *y_str; char **y_ptr;} YYSTYPE;
# define NAME 257
# define AOP 258
# define IOP 259
# define COP 260
# define CSYM 261
# define PORTSEP 262
# define Sconstant 263
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 154 "interp.y"



yyerror(s)
	register char	*s;
{

	fprintf(stderr, "'%s'\n", s);
}

#ifdef DEBUG
main()
{
	char	buf[256];

	while	(gets(buf))
           lexi_buf(buf), yyparse();

	return 0;
}
#endif
int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 26
# define YYLAST 225
int yyact[]={

    32,    19,    10,    57,    46,    10,    26,     6,     7,     8,
    40,    16,    48,    45,    39,    48,    17,     9,    11,    13,
    37,    53,    44,    26,    47,    20,    21,    13,    24,    34,
    20,    28,    26,    42,    29,    30,    20,    33,    56,    15,
    35,    13,    14,    38,    12,     5,     4,    18,     3,     2,
     1,    22,     0,    50,     0,     0,     0,     0,    52,    55,
     0,    23,    54,    52,    49,    52,    51,    27,     0,     0,
     0,     0,     0,    31,     0,    36,     0,     0,    41,     0,
     0,    43,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    10,     0,    25 };
int yypact[]={

  -251, -1000, -1000, -1000, -1000, -1000,  -258,  -258,  -258,     2,
 -1000,    -1,  -250,   -30,  -261,  -258,  -258,  -258,   -38,  -258,
 -1000,   -10,    -9, -1000, -1000,   -41,  -258,   -12, -1000,  -258,
  -258,   -21,  -258, -1000,  -258,   -11, -1000,  -258,  -259,   -34,
 -1000,  -259,  -258,  -259,  -259,   -23, -1000,  -258,  -258,  -259,
    -3,  -259,   -23,  -260,   -31, -1000, -1000, -1000 };
int yypgo[]={

     0,    10,    22,    43,    44,    14,    13,    47,    51,    50,
    49,    48,    46,    45 };
int yyr1[]={

     0,     9,     9,    10,    10,    10,    11,    11,    11,     7,
     7,     3,     3,     5,     5,     2,     2,    12,    12,    13,
     8,     8,     4,     1,     6,     6 };
int yyr2[]={

     0,     0,     2,     2,     2,     2,    19,    17,    17,     3,
     7,     2,     7,     2,     7,     2,     5,    11,    19,     9,
     3,     7,     7,     2,     2,     7 };
int yychk[]={

 -1000,    -9,   -10,   -11,   -12,   -13,   258,   259,   260,    -1,
   263,    -1,    -4,    -1,    40,    40,   261,    46,    -7,   262,
    -1,    -1,    -8,    -4,    -1,   262,    44,    -7,    41,    44,
    44,    -7,    41,    -1,    41,    -1,    -4,    41,    -3,    -5,
    -1,    -3,    44,    -3,    -2,    -6,   263,    58,    46,    -2,
    -1,    -2,    -6,    44,    -5,    -1,    41,   263 };
int yydef[]={

     1,    -2,     2,     3,     4,     5,     0,     0,     0,     0,
    23,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     9,     0,    19,    20,    22,     0,     0,     0,    17,     0,
     0,     0,     0,    10,     0,     0,    21,     0,     0,    11,
    13,     0,     0,     0,     8,    15,    24,     0,     0,     7,
     0,     6,    16,     0,    12,    14,    18,    25 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"NAME",	257,
	"AOP",	258,
	"IOP",	259,
	"COP",	260,
	"CSYM",	261,
	"PORTSEP",	262,
	"Sconstant",	263,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"buffer : /* empty */",
	"buffer : stmts",
	"stmts : Astmt",
	"stmts : Istmt",
	"stmts : Cstmt",
	"Astmt : AOP se '(' plist PORTSEP plist ')' path args",
	"Astmt : AOP se '(' PORTSEP plist ')' path args",
	"Astmt : AOP se '(' plist PORTSEP ')' path args",
	"plist : se",
	"plist : plist ',' se",
	"path : name",
	"path : name ':' name",
	"name : se",
	"name : name '.' se",
	"args : arg_se",
	"args : args arg_se",
	"Istmt : IOP se '(' se ')'",
	"Istmt : IOP se '(' se ',' se ',' se ')'",
	"Cstmt : COP port CSYM dstlist",
	"dstlist : port",
	"dstlist : dstlist ',' port",
	"port : se '.' se",
	"se : Sconstant",
	"arg_se : Sconstant",
	"arg_se : arg_se ',' Sconstant",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 6:
# line 88 "interp.y"
{ agentStatement(yypvt[-7].y_str, yypvt[-5].y_ptr, yypvt[-3].y_ptr, yypvt[-1].y_str, yypvt[-0].y_str); } break;
case 7:
# line 90 "interp.y"
{ agentStatement(yypvt[-6].y_str, NULL, yypvt[-3].y_ptr, yypvt[-1].y_str, yypvt[-0].y_str); } break;
case 8:
# line 92 "interp.y"
{ agentStatement(yypvt[-6].y_str, yypvt[-4].y_ptr, NULL, yypvt[-1].y_str, yypvt[-0].y_str); } break;
case 9:
# line 95 "interp.y"
{ yyval.y_ptr = add_list(NULL, yypvt[-0].y_str); } break;
case 10:
# line 97 "interp.y"
{ yyval.y_ptr = add_list(yyval.y_ptr, yypvt[-0].y_str); } break;
case 12:
# line 102 "interp.y"
{ yyval.y_str = (char*)malloc(strlen(yypvt[-2].y_str) + strlen(yypvt[-0].y_str) + 2);
			  strcat(strcat(strcpy(yyval.y_str, yypvt[-2].y_str), ":"), yypvt[-0].y_str);
			  free(yypvt[-2].y_str); free(yypvt[-0].y_str);
			} break;
case 14:
# line 109 "interp.y"
{ yyval.y_str = (char*)malloc(strlen(yypvt[-2].y_str) + strlen(yypvt[-0].y_str) + 2);
			  strcat(strcat(strcpy(yyval.y_str, yypvt[-2].y_str), "."), yypvt[-0].y_str);
			  free(yypvt[-2].y_str); free(yypvt[-0].y_str);
			} break;
case 16:
# line 116 "interp.y"
{ yyval.y_str = (char*)malloc(strlen(yypvt[-1].y_str) + strlen(yypvt[-0].y_str) + 2);
			  strcat(strcat(strcpy(yyval.y_str, yypvt[-1].y_str), " "), yypvt[-0].y_str);
			  free(yypvt[-1].y_str); free(yypvt[-0].y_str);
			} break;
case 17:
# line 124 "interp.y"
{ invokeStatement(yypvt[-3].y_str, yypvt[-1].y_str, -1, -1); } break;
case 18:
# line 126 "interp.y"
{ invokeStatement(yypvt[-7].y_str, yypvt[-5].y_str, atoi(yypvt[-3].y_str), atoi(yypvt[-1].y_str)); } break;
case 19:
# line 130 "interp.y"
{ connectStatement(yypvt[-2].y_str, yypvt[-0].y_ptr); } break;
case 20:
# line 133 "interp.y"
{ yyval.y_ptr = add_list(NULL, yypvt[-0].y_str); } break;
case 21:
# line 135 "interp.y"
{ yyval.y_ptr = add_list(yyval.y_ptr, yypvt[-0].y_str); } break;
case 22:
# line 138 "interp.y"
{ yyval.y_str = (char*)malloc(strlen(yypvt[-2].y_str) + strlen(yypvt[-0].y_str) + 2);
			  strcat(strcat(strcpy(yyval.y_str, yypvt[-2].y_str), "."), yypvt[-0].y_str);
			  free(yypvt[-2].y_str); free(yypvt[-0].y_str);
			} break;
case 25:
# line 148 "interp.y"
{ yyval.y_str = (char*)malloc(strlen(yypvt[-2].y_str) + strlen(yypvt[-0].y_str) + 2);
			  strcat(strcat(strcpy(yyval.y_str, yypvt[-2].y_str), ","), yypvt[-0].y_str);
			  free(yypvt[-2].y_str); free(yypvt[-0].y_str);
			} break;
	}
	goto yystack;		/* reset registers in driver code */
}
