$l= $u= $config_l_decrypt; $u =~ y/a-z/A-Z/; # -*- nroff -*-
print <<END
.TH $u 1
.SH NAME
$l \- decrypt and/or check signature or a PGP message
.SH SYNOPSYS
.B $l
.RB [ debug ]
.RI < "input-file " > output-file
.SH DESCRIPTION
.B $l
is a filter which interprets an armoured PGP message and does
something appropriate with it (by invoking
.BR $config_x_normalpgp )
as follows:

If the message is encrypted the plaintext is sent to standard output
preceded by a list of the recipients (or their key IDs if their keys
are not available to be looked up).

If the message is both signed and encrypted a clearsig version is sent
to standard output, again preceded by the list of recipients.

If the message is a signed or clearsig message the signature is
checked.

Informative progress messages from
.B $config_x_normalpgp
which are not particularly important are preceded by a space on each
line. Messages whose meaning was not understood by the scripts are
preceded by
.B ???
- this often indicates some kind of failure.

Informational and progress messages are always written to standard
error. Any message text is always written to standard output, preceded
by the message

.B Enclosed message text
.BI ( "n " bytes):

This will be the last message written to standard error. This scheme
is designed to make it easer for Emacs to parse the output of
.BR $l .

If the message is not of one of the structures above an error is
signaled.

Errors are introduced by the string

.B Error:

If a clearsig message contained trailing spaces and the signature did
not match the file contents (using the default action of PGP in this
situation, which is to ignore trailing whitespace),
.B $l
will try checking the signature again but this time taking account of
trailing whitespace.

.B $l
calls
.BR $config_x_normalpgp " and " $config_l_pgpauto
to do the various processing steps.
.SH BUGS
PGP versions 2.0 and 2.1 always counted trailing spaces in all
messages; 2.2 ignores them when generating or checking a clearsig
message. This behaviour makes it impossible to produce a clearsig file
which will be accepted by version 2.2 from an encrypted,
fully-armoured or detached signature file which has any trailing
spaces in the text.

.B $l
resolves this problem by checking for trailing spaces when checking
signatures. If there were any it runs PGP again after doing part of
the dearmouring itself, so that trailing spaces are counted. Hopefully
PGP 2.3 will always ignore trailing whitespace when signing text files
and will take the responsibility for compatibility for previous
versions on itself.

You must not try to run two copies of
.B $l
(with the same
.BR PGPPATH )
simultaneously, as version of PGP up to at least 2.2 do not correctly
generate unique temporary file names.
.SH FILES
.TP
.B \$PGPPATH/.wrapper/*
Temporary files.
.SH SEE ALSO
.BR pgp "(1), " $config_l_pgpauto "(1), " $config_l_pixie "(1),"
.BR $config_l_decrypt (1),
.B $config_lisp.el
.SH AUTHOR
The Emacs Auto-PGP package was written by Ian Jackson. Copyright 1993;
for copying conditions see the GNU General Public Licence. This
software is distributed as-is with no warranty.
END
